/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;
import org.json.JSONArray;

class ArraySchemaValidatingVisitor
extends Visitor {
    private final ValidatingVisitor owner;
    private JSONArray arraySubject;
    private ArraySchema arraySchema;
    private int subjectLength;
    private Schema containedSchema;

    public ArraySchemaValidatingVisitor(ValidatingVisitor owner) {
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitArraySchema(ArraySchema arraySchema) {
        this.owner.ifPassesTypeCheck(JSONArray.class, arraySchema.requiresArray(), arraySchema.isNullable(), arraySubject -> {
            this.arraySubject = arraySubject;
            this.subjectLength = arraySubject.length();
            this.arraySchema = arraySchema;
            super.visitArraySchema(arraySchema);
        });
    }

    @Override
    void visitMinItems(Integer minItems) {
        if (minItems != null && this.subjectLength < minItems) {
            this.owner.failure("expected minimum item count: " + minItems + ", found: " + this.subjectLength, "minItems");
        }
    }

    @Override
    void visitMaxItems(Integer maxItems) {
        if (maxItems != null && maxItems < this.subjectLength) {
            this.owner.failure("expected maximum item count: " + maxItems + ", found: " + this.subjectLength, "maxItems");
        }
    }

    @Override
    void visitUniqueItems(boolean uniqueItems) {
        if (!uniqueItems || this.subjectLength == 0) {
            return;
        }
        ArrayList<Object> uniques = new ArrayList<Object>(this.subjectLength);
        for (int i = 0; i < this.subjectLength; ++i) {
            Object item = this.arraySubject.get(i);
            for (Object e : uniques) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                this.owner.failure("array items are not unique", "uniqueItems");
                return;
            }
            uniques.add(item);
        }
    }

    @Override
    void visitAllItemSchema(Schema allItemSchema) {
        if (allItemSchema != null) {
            this.validateItemsAgainstSchema(IntStream.range(0, this.subjectLength), allItemSchema);
        }
    }

    @Override
    void visitItemSchema(int index, Schema itemSchema) {
        if (index >= this.subjectLength) {
            return;
        }
        Object subject = this.arraySubject.get(index);
        String idx = String.valueOf(index);
        this.ifFails(itemSchema, subject).map(exc -> exc.prepend(idx)).ifPresent(this.owner::failure);
    }

    @Override
    void visitAdditionalItems(Boolean additionalItems) {
        int itemSchemaCount;
        List<Schema> itemSchemas = this.arraySchema.getItemSchemas();
        int n = itemSchemaCount = itemSchemas == null ? 0 : itemSchemas.size();
        if (itemSchemas != null && additionalItems != null && !additionalItems.booleanValue() && this.subjectLength > itemSchemaCount) {
            this.owner.failure(String.format("expected: [%d] array items, found: [%d]", itemSchemaCount, this.subjectLength), "items");
        }
    }

    @Override
    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        if (schemaOfAdditionalItems == null || this.arraySchema.getItemSchemas() == null) {
            return;
        }
        int validationFrom = Math.min(this.subjectLength, this.arraySchema.getItemSchemas().size());
        this.validateItemsAgainstSchema(IntStream.range(validationFrom, this.subjectLength), schemaOfAdditionalItems);
    }

    @Override
    void visitUnevaluatedItems(Boolean unevaluatedItems) {
        Boolean nestedPermits = this.nestedSchemasPermit();
        List<Schema> itemSchemas = this.arraySchema.getItemSchemas();
        int itemSchemaCount = this.getAllItemsSchemaCount();
        if (!(itemSchemas == null && this.arraySchema.getAllItemSchema() != null || unevaluatedItems == null || unevaluatedItems.booleanValue() || nestedPermits != null && nestedPermits.booleanValue() || this.subjectLength <= itemSchemaCount)) {
            this.owner.failure(String.format("expected: [%d] array items, found: [%d]", itemSchemaCount, this.subjectLength), "items");
        }
    }

    @Override
    void visitSchemaOfUnevaluatedItems(Schema schemaOfUnevaluatedItems) {
        if (schemaOfUnevaluatedItems == null) {
            return;
        }
        int itemSchemaCount = this.getAllItemsSchemaCount();
        int validationFrom = Math.min(this.subjectLength, itemSchemaCount);
        this.validateItemsAgainstSchema(IntStream.range(validationFrom, this.subjectLength), schemaOfUnevaluatedItems);
    }

    @Override
    void visitMinContains(Integer minContains) {
        int contains;
        if (minContains != null && this.containedSchema != null && (contains = this.validateItemsAgainstContainedSchema(i -> this.containedSchema)) < minContains) {
            this.owner.failure("expected minimum contained items count: " + minContains + ", found: " + contains, "minContains");
        }
    }

    @Override
    void visitMaxContains(Integer maxContains) {
        if (maxContains != null && this.containedSchema != null) {
            int contains = this.validateItemsAgainstContainedSchema(i -> this.containedSchema);
            if (maxContains < contains) {
                this.owner.failure("expected maximum contained items count: " + maxContains + ", found: " + contains, "maxContains");
            }
        }
    }

    private Boolean nestedSchemasPermit() {
        Boolean nestedSchemasPermit = null;
        if (this.owner.getCombinedSchemaParent() != null) {
            for (Schema subschema : this.owner.getCombinedSchemaParent().getSubschemas()) {
                if (subschema instanceof ArraySchema) {
                    nestedSchemasPermit = this.getNestedPermits((ArraySchema)subschema);
                    if (nestedSchemasPermit == null || nestedSchemasPermit.booleanValue()) continue;
                    break;
                }
                if (!(subschema instanceof CombinedSchema)) continue;
                for (Schema nestedSubschema : ((CombinedSchema)subschema).getSubschemas()) {
                    if (nestedSubschema instanceof ArraySchema && (nestedSchemasPermit = this.getNestedPermits((ArraySchema)nestedSubschema)) != null && !nestedSchemasPermit.booleanValue()) break;
                }
                if (nestedSchemasPermit == null) continue;
                break;
            }
        }
        return nestedSchemasPermit;
    }

    private Boolean getNestedPermits(ArraySchema subschema) {
        if (subschema.permitsAdditionalItems() != null) {
            return subschema.permitsAdditionalItems();
        }
        if (subschema.permitsUnevaluatedItems() != null) {
            return subschema.permitsUnevaluatedItems();
        }
        return null;
    }

    private int validateItemsAgainstContainedSchema(IntFunction<Schema> schemaForIndex) {
        int contains = 0;
        for (int i : IntStream.range(0, this.subjectLength).toArray()) {
            if (this.ifFails(schemaForIndex.apply(i), this.arraySubject.get(i)).isPresent()) continue;
            ++contains;
        }
        return contains;
    }

    private int getAllItemsSchemaCount() {
        int nestedSchemasSize;
        int itemSchemaCount;
        List<Schema> itemSchemas = this.arraySchema.getItemSchemas();
        int n = itemSchemaCount = itemSchemas == null ? 0 : itemSchemas.size();
        if (this.owner.getCombinedSchemaParent() != null && (nestedSchemasSize = this.owner.getCombinedSchemaParent().getNestedItemSchemas().size()) > itemSchemaCount) {
            itemSchemaCount = nestedSchemasSize;
        }
        if (this.owner.getConditionalSchemaSibling() != null && (nestedSchemasSize = this.owner.getConditionalSchemaSibling().getNestedItemSchemas().size()) > itemSchemaCount) {
            itemSchemaCount = nestedSchemasSize;
        }
        return itemSchemaCount += this.containedSchema != null ? 1 : 0;
    }

    private void validateItemsAgainstSchema(IntStream indices, Schema schema) {
        this.validateItemsAgainstSchema(indices, (int i) -> schema);
    }

    private void validateItemsAgainstSchema(IntStream indices, IntFunction<Schema> schemaForIndex) {
        for (int i : indices.toArray()) {
            String copyOfI = String.valueOf(i);
            this.ifFails(schemaForIndex.apply(i), this.arraySubject.get(i)).map(exc -> exc.prepend(copyOfI)).ifPresent(this.owner::failure);
        }
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        return Optional.ofNullable(this.owner.getFailureOfSchema(schema, input));
    }

    @Override
    void visitContainedItemSchema(Schema containedItemSchema) {
        if (containedItemSchema == null) {
            return;
        }
        this.containedSchema = containedItemSchema;
        for (int i = 0; i < this.arraySubject.length(); ++i) {
            Optional<ValidationException> exception = this.ifFails(containedItemSchema, this.arraySubject.get(i));
            if (exception.isPresent()) continue;
            return;
        }
        if (this.arraySchema.getMinContains() != null && this.arraySchema.getMinContains() == 0) {
            return;
        }
        this.owner.failure("expected at least one array item to match 'contains' schema", "contains");
    }
}

