/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.console;

import de.schlichtherle.key.PromptingKeyProvider;
import java.io.Console;
import java.util.Arrays;
import java.util.ResourceBundle;

public class PromptingKeyProviderUI
implements de.schlichtherle.key.PromptingKeyProviderUI {
    private static final String CLASS_NAME = "de/schlichtherle/key/passwd/console/PromptingKeyProviderUI".replace('/', '.');
    protected static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    protected static final Console con = System.console();
    private static final PromptingLock lock = new PromptingLock();
    private static final int MIN_PASSWD_LEN = 6;
    private static String lastResourceID = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void promptCreateKey(PromptingKeyProvider promptingKeyProvider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            char[] cArray;
            String string = promptingKeyProvider.getResourceID();
            if (!string.equals(lastResourceID)) {
                this.printf(resources.getString("createKey.banner"), promptingKeyProvider.getResourceID());
            }
            lastResourceID = string;
            while (true) {
                if ((cArray = this.readPassword(resources.getString("createKey.newPasswd1"))) == null || cArray.length <= 0) {
                    return;
                }
                char[] cArray2 = this.readPassword(resources.getString("createKey.newPasswd2"));
                if (cArray2 == null) {
                    return;
                }
                if (!Arrays.equals(cArray, cArray2)) {
                    this.printf(resources.getString("createKey.passwd.noMatch"));
                    continue;
                }
                if (cArray.length >= 6) break;
                this.printf(resources.getString("createKey.passwd.tooShort"));
            }
            promptingKeyProvider.setKey(cArray);
            this.promptExtraData(promptingKeyProvider);
        }
    }

    protected void promptExtraData(PromptingKeyProvider promptingKeyProvider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean promptUnknownOpenKey(PromptingKeyProvider promptingKeyProvider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            return this.promptOpenKey(promptingKeyProvider, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean promptInvalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            return this.promptOpenKey(promptingKeyProvider, true);
        }
    }

    private boolean promptOpenKey(PromptingKeyProvider promptingKeyProvider, boolean bl) {
        String string;
        String string2;
        if (bl) {
            this.printf(resources.getString("openKey.invalid"));
        }
        if (!(string2 = promptingKeyProvider.getResourceID()).equals(lastResourceID)) {
            this.printf(resources.getString("openKey.banner"), promptingKeyProvider.getResourceID());
        }
        lastResourceID = string2;
        char[] cArray = this.readPassword(resources.getString("openKey.passwd"));
        if (cArray == null || cArray.length <= 0) {
            promptingKeyProvider.setKey(null);
            return false;
        }
        promptingKeyProvider.setKey(cArray);
        do {
            if ((string = this.readLine(resources.getString("openKey.change"))) == null) {
                return false;
            }
            if ((string = string.toLowerCase()).length() > 0 && !string.equals(resources.getString("no"))) continue;
            return false;
        } while (!string.equals(resources.getString("yes")));
        return true;
    }

    protected final Console printf(String string) {
        return con.printf(string, null);
    }

    protected final Console printf(String string, Object object) {
        return con.printf(string, object);
    }

    protected final String readLine(String string) {
        return con.readLine(string, null);
    }

    protected final String readLine(String string, Object object) {
        return con.readLine(string, object);
    }

    protected final char[] readPassword(String string) {
        return con.readPassword(string, null);
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }
}

