/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private final byte[] buf = new byte[8];
    protected volatile long written;

    public LEDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private final void incCount(int n) {
        long l = this.written + (long)n;
        this.written = l >= 0L ? l : Long.MAX_VALUE;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public final void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    public final void writeShort(int n) throws IOException {
        this.buf[0] = (byte)n;
        this.buf[1] = (byte)(n >>= 8);
        this.out.write(this.buf, 0, 2);
        this.incCount(2);
    }

    public final void writeInt(int n) throws IOException {
        this.buf[0] = (byte)n;
        this.buf[1] = (byte)(n >>= 8);
        this.buf[2] = (byte)(n >>= 8);
        this.buf[3] = (byte)(n >>= 8);
        this.out.write(this.buf, 0, 4);
        this.incCount(4);
    }

    public final void writeLong(long l) throws IOException {
        this.buf[0] = (byte)l;
        this.buf[1] = (byte)(l >>= 8);
        this.buf[2] = (byte)(l >>= 8);
        this.buf[3] = (byte)(l >>= 8);
        this.buf[4] = (byte)(l >>= 8);
        this.buf[5] = (byte)(l >>= 8);
        this.buf[6] = (byte)(l >>= 8);
        this.buf[7] = (byte)(l >>= 8);
        this.out.write(this.buf, 0, 8);
        this.incCount(8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeShort(string.charAt(i));
        }
    }

    public void writeUTF(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long size() {
        return this.written;
    }
}

