/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.FilterReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BufferedReadOnlyFile
extends FilterReadOnlyFile {
    public static final int WINDOW_LEN = 4096;
    private long length;
    private long fp;
    private long windowOff;
    private final byte[] window;
    private boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected static final long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    protected static final long max(long l, long l2) {
        return l < l2 ? l2 : l;
    }

    public BufferedReadOnlyFile(File file) throws NullPointerException, FileNotFoundException, IOException {
        this(null, file, 4096);
    }

    public BufferedReadOnlyFile(File file, int n) throws NullPointerException, FileNotFoundException, IOException {
        this(null, file, n);
    }

    public BufferedReadOnlyFile(ReadOnlyFile readOnlyFile) throws NullPointerException, FileNotFoundException, IOException {
        this(readOnlyFile, null, 4096);
    }

    public BufferedReadOnlyFile(ReadOnlyFile readOnlyFile, int n) throws NullPointerException, FileNotFoundException, IOException {
        this(readOnlyFile, null, n);
    }

    private BufferedReadOnlyFile(ReadOnlyFile readOnlyFile, File file, int n) throws NullPointerException, FileNotFoundException, IOException {
        super(readOnlyFile);
        if (readOnlyFile == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            readOnlyFile = this.createReadOnlyFile(file);
        } else if (!$assertionsDisabled && file != null) {
            throw new AssertionError();
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.rof = readOnlyFile;
        this.length = readOnlyFile.length();
        this.fp = readOnlyFile.getFilePointer();
        this.window = new byte[n];
        this.invalidateWindow();
        if (!$assertionsDisabled && this.window.length <= 0) {
            throw new AssertionError();
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws IOException {
        return new SimpleReadOnlyFile(file);
    }

    public long length() throws IOException {
        long l = this.rof.length();
        if (l != this.length) {
            this.length = l;
            this.invalidateWindow();
        }
        return this.length;
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.fp;
    }

    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        long l2 = this.length();
        if (l > l2) {
            throw new IOException("file pointer (" + l + ") is larger than file length (" + l2 + ")");
        }
        this.fp = l;
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.fp >= this.length()) {
            return -1;
        }
        this.positionWindow();
        return this.window[(int)(this.fp++ % (long)this.window.length)] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        this.ensureOpen();
        long l = this.length();
        if (this.fp >= l) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        int n3 = n + n2;
        if ((n | n2 | n3 | byArray.length - n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = this.window.length;
        int n5 = 0;
        int n6 = (int)(this.fp % (long)n4);
        if (n6 != 0) {
            this.positionWindow();
            n5 = (int)BufferedReadOnlyFile.min(n2, n4 - n6);
            n5 = (int)BufferedReadOnlyFile.min(n5, l - this.fp);
            System.arraycopy(this.window, n6, byArray, n, n5);
            this.fp += (long)n5;
        }
        while (n5 + n4 < n2 && this.fp + (long)n4 <= l) {
            this.positionWindow();
            System.arraycopy(this.window, 0, byArray, n + n5, n4);
            n5 += n4;
            this.fp += (long)n4;
        }
        if (n5 < n2 && this.fp < l) {
            this.positionWindow();
            n6 = (int)BufferedReadOnlyFile.min(n2 - n5, l - this.fp);
            System.arraycopy(this.window, 0, byArray, n + n5, n6);
            n5 += n6;
            this.fp += (long)n6;
        }
        if (!$assertionsDisabled && n5 <= 0) {
            throw new AssertionError();
        }
        return n5;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rof.close();
    }

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("file is closed");
        }
    }

    private void positionWindow() throws IOException {
        long l = this.fp;
        int n = this.window.length;
        long l2 = this.windowOff + (long)n;
        if (this.windowOff <= l && l < l2) {
            return;
        }
        try {
            int n2;
            this.windowOff = l / (long)n * (long)n;
            if (this.windowOff != l2) {
                this.rof.seek(this.windowOff);
            }
            int n3 = 0;
            while ((n2 = this.rof.read(this.window, n3, n - n3)) >= 0 && (n3 += n2) < n) {
            }
        }
        catch (IOException iOException) {
            this.windowOff = -n - 1;
            throw iOException;
        }
    }

    private final void invalidateWindow() {
        this.windowOff = Long.MIN_VALUE;
    }

    static {
        $assertionsDisabled = !BufferedReadOnlyFile.class.desiredAssertionStatus();
    }
}

