/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RaesFiles {
    protected RaesFiles() {
    }

    public static void encrypt(String string, String string2) throws IOException {
        RaesFiles.encrypt(string, string2, File.getDefaultArchiveDetector());
    }

    public static void encrypt(String string, String string2, ArchiveDetector archiveDetector) throws IOException {
        RaesOutputStream raesOutputStream;
        File file = RaesFiles.getNonArchiveFile(string, archiveDetector);
        FileInputStream fileInputStream = archiveDetector.createFileInputStream(file);
        try {
            File file2 = RaesFiles.getNonArchiveFile(string2, archiveDetector);
            KeyManagerRaesParameters keyManagerRaesParameters = new KeyManagerRaesParameters(file2.getCanonicalPath());
            raesOutputStream = RaesOutputStream.getInstance(archiveDetector.createFileOutputStream(file2, false), keyManagerRaesParameters);
        }
        catch (IOException iOException) {
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
        File.cp(fileInputStream, raesOutputStream);
    }

    public static void decrypt(String string, String string2, boolean bl) throws IOException {
        RaesFiles.decrypt(string, string2, bl, File.getDefaultArchiveDetector());
    }

    public static void decrypt(String string, String string2, boolean bl, ArchiveDetector archiveDetector) throws IOException {
        FileOutputStream fileOutputStream;
        ReadOnlyFileInputStream readOnlyFileInputStream;
        File file = RaesFiles.getNonArchiveFile(string, archiveDetector);
        KeyManagerRaesParameters keyManagerRaesParameters = new KeyManagerRaesParameters(file.getCanonicalPath());
        RaesReadOnlyFile raesReadOnlyFile = RaesReadOnlyFile.getInstance(file, (RaesParameters)keyManagerRaesParameters);
        try {
            if (bl) {
                raesReadOnlyFile.authenticate();
            }
            readOnlyFileInputStream = new ReadOnlyFileInputStream(raesReadOnlyFile);
            File file2 = RaesFiles.getNonArchiveFile(string2, archiveDetector);
            fileOutputStream = archiveDetector.createFileOutputStream(file2, false);
        }
        catch (IOException iOException) {
            raesReadOnlyFile.close();
            throw iOException;
        }
        File.cp(readOnlyFileInputStream, fileOutputStream);
    }

    private static final File getNonArchiveFile(String string, ArchiveDetector archiveDetector) {
        File file = archiveDetector.createFile(string);
        return ArchiveDetector.NULL.createFile(file.getParentFile(), file.getName());
    }
}

