/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class CountingOutputStream
extends FilterOutputStream {
    private static volatile long total;
    private static volatile boolean reset;

    CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
        CountingOutputStream.init();
    }

    static long getTotal() {
        return total;
    }

    static void init() {
        if (reset) {
            reset = false;
            total = 0L;
        }
    }

    static void resetOnInit() {
        reset = true;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        ++total;
    }

    public void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.out.write(byArray, 0, n);
        total += (long)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        total += (long)n2;
    }
}

