/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.util.SuffixSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

class ArchiveDriverRegistry
extends HashMap {
    private static final long serialVersionUID = 3445783613096128268L;
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final Logger logger;
    static final String KWD_DRIVER = "DRIVER";
    static final String KWD_DEFAULT = "DEFAULT";
    private final ArchiveDriverRegistry delegate;
    static final /* synthetic */ boolean $assertionsDisabled;

    ArchiveDriverRegistry() {
        this.delegate = null;
    }

    ArchiveDriverRegistry(ArchiveDriverRegistry archiveDriverRegistry, Map map) {
        if (archiveDriverRegistry == null) {
            throw new NullPointerException(ArchiveDriverRegistry.getString("null", "delegate"));
        }
        this.delegate = archiveDriverRegistry;
        this.registerArchiveDrivers(map, true);
    }

    final void registerArchiveDrivers(Map map, boolean bl) {
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (KWD_DRIVER.equals(string)) {
                    throw new IllegalArgumentException(ArchiveDriverRegistry.getString("keyword", KWD_DRIVER));
                }
                Object v = entry.getValue();
                if (KWD_DEFAULT.equals(string)) {
                    if (bl) {
                        throw new IllegalArgumentException(ArchiveDriverRegistry.getString("keyword", KWD_DEFAULT));
                    }
                    SuffixSet suffixSet = (SuffixSet)super.get(string);
                    if (suffixSet != null) {
                        suffixSet.addAll((String)v);
                        continue;
                    }
                    super.put(string, new SuffixSet((String)v));
                    continue;
                }
                this.registerArchiveDriver(string, v, bl);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(runtimeException.toString());
            illegalArgumentException.initCause(runtimeException);
            throw illegalArgumentException;
        }
    }

    private void registerArchiveDriver(String string, Object object, boolean bl) {
        if (string == null) {
            throw new NullPointerException(ArchiveDriverRegistry.getString("noSuffixes"));
        }
        SuffixSet suffixSet = new SuffixSet(string);
        if (suffixSet.isEmpty()) {
            if (bl) {
                throw new IllegalArgumentException(ArchiveDriverRegistry.getString("noSuffixes"));
            }
            logger.log(Level.WARNING, "noSuffixes");
        } else {
            object = bl ? ArchiveDriverRegistry.createArchiveDriver(object) : (String)object;
            Iterator iterator = suffixSet.iterator();
            while (iterator.hasNext()) {
                super.put((String)iterator.next(), object);
            }
        }
    }

    public final synchronized ArchiveDriver getArchiveDriver(String string) {
        Object object = super.get(string);
        if (!(object instanceof ArchiveDriver)) {
            if (object == null) {
                if (super.containsKey(string) || this.delegate == null) {
                    return null;
                }
                object = this.delegate.getArchiveDriver(string);
            } else {
                object = ArchiveDriverRegistry.createArchiveDriver(object);
                logger.log(Level.FINE, "installed", new Object[]{string, object});
            }
            super.put(string, object);
        }
        return (ArchiveDriver)object;
    }

    private static final ArchiveDriver createArchiveDriver(Object clazz) {
        try {
            if (clazz instanceof String) {
                clazz = Thread.currentThread().getContextClassLoader().loadClass((String)((Object)clazz));
            }
            if (clazz instanceof Class) {
                clazz = ((Class)clazz).newInstance();
            }
            return (ArchiveDriver)((Object)clazz);
        }
        catch (Exception exception) {
            throw new IllegalArchiveDriverException(ArchiveDriverRegistry.getString("cannotCreate"), exception);
        }
    }

    public final SuffixSet suffixes() {
        return this.decorate(this.delegate != null ? this.delegate.suffixes() : new SuffixSet());
    }

    public final SuffixSet decorate(SuffixSet suffixSet) {
        SuffixSet suffixSet2 = new SuffixSet(super.keySet());
        Iterator iterator = suffixSet2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!$assertionsDisabled && !super.containsKey(string)) {
                throw new AssertionError();
            }
            if (super.get(string) != null) {
                suffixSet.addAll(string);
                continue;
            }
            suffixSet.removeAll(string);
        }
        return suffixSet;
    }

    private static final String getString(String string) {
        return resources.getString(string);
    }

    private static final String getString(String string, String string2) {
        return MessageFormat.format(resources.getString(string), string2);
    }

    static {
        $assertionsDisabled = !ArchiveDriverRegistry.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/ArchiveDriverRegistry".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    static class IllegalArchiveDriverException
    extends IllegalArgumentException {
        private IllegalArchiveDriverException(String string, Exception exception) {
            super(string);
            this.initCause(exception);
        }
    }
}

