/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import de.schlichtherle.crypto.SeekableBlockCipher;
import de.schlichtherle.io.rof.FilterReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import org.bouncycastle.crypto.Mac;

public abstract class CipherReadOnlyFile
extends FilterReadOnlyFile {
    private static final int MAX_WINDOW_LEN = 1024;
    private long start;
    private long length;
    private long fp;
    private long windowOff;
    private byte[] window;
    private SeekableBlockCipher cipher;
    private long blockOff;
    private byte[] block;
    private boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static final long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public CipherReadOnlyFile(ReadOnlyFile readOnlyFile) {
        super(readOnlyFile);
    }

    public void init(SeekableBlockCipher seekableBlockCipher, long l, long l2) throws IOException {
        if (this.closed) {
            throw new IOException("file has been closed");
        }
        if (this.cipher != null) {
            throw new IllegalStateException("file is already initialized");
        }
        if (this.rof == null) {
            throw new NullPointerException("rof");
        }
        if (seekableBlockCipher == null) {
            throw new NullPointerException("cipher");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.cipher = seekableBlockCipher;
        this.start = l;
        this.length = l2;
        this.blockOff = l2;
        int n = seekableBlockCipher.getBlockSize();
        this.block = new byte[n];
        this.windowOff = Long.MIN_VALUE;
        this.window = new byte[1024 / n * n];
        if (!$assertionsDisabled && this.fp != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.block.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length % this.block.length != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] computeMac(Mac mac) throws IOException {
        int n = this.window.length;
        byte[] byArray = new byte[mac.getMacSize()];
        long l = this.getFilePointer();
        try {
            this.fp = 0L;
            while (this.fp < this.length) {
                this.positionWindow();
                long l2 = this.length - this.windowOff;
                mac.update(this.window, 0, (int)CipherReadOnlyFile.min(n, l2));
                this.fp += (long)n;
            }
            int n2 = mac.doFinal(byArray, 0);
            if (!$assertionsDisabled && n2 != byArray.length) {
                throw new AssertionError();
            }
        }
        finally {
            this.fp = l;
        }
        return byArray;
    }

    public long length() throws IOException {
        this.ensureInit();
        return this.length;
    }

    public long getFilePointer() throws IOException {
        this.ensureInit();
        return this.fp;
    }

    public void seek(long l) throws IOException {
        this.ensureInit();
        if (l < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        if (l > this.length) {
            throw new IOException("file pointer (" + l + ") is larger than file length (" + this.length + ")");
        }
        this.fp = l;
    }

    public int read() throws IOException {
        this.ensureInit();
        if (this.fp >= this.length) {
            return -1;
        }
        this.positionBlock();
        return this.block[(int)(this.fp++ % (long)this.block.length)] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        this.ensureInit();
        if (this.fp >= this.length) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        int n3 = n + n2;
        if ((n | n2 | n3 | byArray.length - n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = this.block.length;
        int n5 = 0;
        int n6 = (int)(this.fp % (long)n4);
        if (n6 != 0) {
            this.positionBlock();
            n5 = (int)CipherReadOnlyFile.min(n2, n4 - n6);
            n5 = (int)CipherReadOnlyFile.min(n5, this.length - this.fp);
            System.arraycopy(this.block, n6, byArray, n, n5);
            this.fp += (long)n5;
        }
        long l = this.fp / (long)n4;
        while (n5 + n4 < n2 && this.fp + (long)n4 <= this.length) {
            this.positionWindow();
            this.cipher.setBlockCounter(l++);
            this.cipher.processBlock(this.window, (int)(this.fp - this.windowOff), byArray, n + n5);
            n5 += n4;
            this.fp += (long)n4;
        }
        if (n5 < n2 && this.fp < this.length) {
            this.positionBlock();
            int n7 = (int)CipherReadOnlyFile.min(n2 - n5, this.length - this.fp);
            System.arraycopy(this.block, 0, byArray, n + n5, n7);
            n5 += n7;
            this.fp += (long)n7;
        }
        if (!$assertionsDisabled && n5 <= 0) {
            throw new AssertionError();
        }
        return n5;
    }

    private final void ensureInit() throws IOException {
        if (this.cipher == null) {
            throw new IOException("file is closed or not initialized");
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cipher = null;
        this.rof.close();
    }

    private void positionBlock() throws IOException {
        long l;
        long l2 = this.fp;
        int n = this.block.length;
        if (this.blockOff <= l2 && l2 < (l = this.blockOff + (long)n)) {
            return;
        }
        this.positionWindow();
        l = l2 / (long)n;
        this.blockOff = l * (long)n;
        this.cipher.setBlockCounter(l);
        this.cipher.processBlock(this.window, (int)(this.blockOff - this.windowOff), this.block, 0);
    }

    private void positionWindow() throws IOException {
        long l = this.fp;
        int n = this.window.length;
        long l2 = this.windowOff + (long)n;
        if (this.windowOff <= l && l < l2) {
            return;
        }
        try {
            int n2;
            int n3 = this.block.length;
            this.windowOff = l / (long)n3 * (long)n3;
            if (this.windowOff != l2) {
                this.rof.seek(this.windowOff + this.start);
            }
            int n4 = 0;
            while ((n2 = this.rof.read(this.window, n4, n - n4)) >= 0 && (n4 += n2) < n) {
            }
        }
        catch (IOException iOException) {
            this.windowOff = -n - 1;
            throw iOException;
        }
    }

    static {
        $assertionsDisabled = !CipherReadOnlyFile.class.desiredAssertionStatus();
    }
}

