/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.StandardDiagnostics;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.Message;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class MessageInstr
extends Instruction {
    private final Operand selectOp;
    private final Operand terminateOp;
    private final Operand errorCodeOp;
    private boolean isAssert;

    public MessageInstr(Expression select, Expression terminate, Expression errorCode) {
        if (errorCode == null) {
            errorCode = new StringLiteral(BMPString.of("Q{http://www.w3.org/2005/xqt-errors}XTMM9000"));
        }
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.terminateOp = new Operand(this, terminate, OperandRole.SINGLE_ATOMIC);
        this.errorCodeOp = new Operand(this, errorCode, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getTerminate() {
        return this.terminateOp.getChildExpression();
    }

    public void setTerminate(Expression terminate) {
        this.terminateOp.setChildExpression(terminate);
    }

    public Expression getErrorCode() {
        return this.errorCodeOp.getChildExpression();
    }

    public void setErrorCode(Expression errorCode) {
        this.errorCodeOp.setChildExpression(errorCode);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp, this.terminateOp, this.errorCodeOp);
    }

    public void setIsAssert(boolean isAssert) {
        this.isAssert = isAssert;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        MessageInstr exp = new MessageInstr(this.getSelect().copy(rebindings), this.getTerminate().copy(rebindings), this.getErrorCode().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getInstructionNameCode() {
        return this.isAssert ? 136 : 178;
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public int getCardinality() {
        return 24576;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return super.optimize(visitor, contextInfo);
    }

    private Message makeMessage(boolean abort, StructuredQName errorCode, NodeInfo content) {
        return new Message((XdmNode)XdmNode.wrap(content), new QName(errorCode), abort, this.getLocation());
    }

    private static Result standardErrorResult() {
        return new StreamResult(System.err);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("message", this);
        out.setChildRole("select");
        this.getSelect().export(out);
        out.setChildRole("terminate");
        this.getTerminate().export(out);
        out.setChildRole("error");
        this.getErrorCode().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new MessageInstrElaborator();
    }

    private static class MessageInstrElaborator
    extends PushElaborator {
        private MessageInstrElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            MessageInstr expr = (MessageInstr)this.getExpression();
            PushEvaluator select = expr.getSelect().makeElaborator().elaborateForPush();
            StringEvaluator terminate = expr.getTerminate().makeElaborator().elaborateForString(true);
            StringEvaluator errorCodeEval = expr.getErrorCode().makeElaborator().elaborateForString(true);
            return (out, context) -> {
                StructuredQName errorCode;
                String code;
                String term;
                if (!(context.getController() instanceof XsltController)) {
                    SequenceIterator iter = expr.getSelect().iterate(context);
                    QueryResult.serializeSequence(iter, context.getConfiguration(), MessageInstr.standardErrorResult(), new Properties());
                    return null;
                }
                XsltController controller = (XsltController)context.getController();
                if (expr.isAssert && !controller.isAssertionsEnabled()) {
                    return null;
                }
                boolean abort = false;
                switch (term = Whitespace.trim(terminate.eval(context))) {
                    case "no": 
                    case "false": 
                    case "0": {
                        break;
                    }
                    case "yes": 
                    case "true": 
                    case "1": {
                        abort = true;
                        break;
                    }
                    default: {
                        throw new XPathException("The terminate attribute of xsl:message must be yes|true|1 or no|false|0").withXPathContext(context).withErrorCode("XTDE0030");
                    }
                }
                try {
                    code = errorCodeEval.eval(context);
                }
                catch (XPathException err) {
                    code = err.getErrorCodeQName().getEQName();
                }
                try {
                    errorCode = StructuredQName.fromLexicalQName(code, false, true, expr.getRetainedStaticContext());
                }
                catch (XPathException err) {
                    errorCode = new StructuredQName("err", NamespaceUri.ERR, "XTMM9000");
                }
                controller.incrementMessageCounter(errorCode);
                Builder builder = controller.makeBuilder();
                builder.setDurability(Durability.TEMPORARY);
                builder.setTiming(false);
                MessageAdapter rec = new MessageAdapter(new TreeReceiver(builder));
                rec.open();
                ComplexContentOutputter cco = new ComplexContentOutputter(rec);
                cco.startDocument(abort ? 16384 : 0);
                try {
                    TailCall tc = select.processLeavingTail(cco, context);
                    Expression.dispatchTailCall(tc);
                }
                catch (XPathException e) {
                    cco.append(StringValue.bmp("Error " + e.showErrorCode() + " while evaluating xsl:message at line " + expr.getLocation().getLineNumber() + " of " + expr.getLocation().getSystemId() + ": " + e.getMessage()));
                }
                cco.endDocument();
                cco.close();
                builder.close();
                NodeInfo content = builder.getCurrentRoot();
                Message message = expr.makeMessage(abort, errorCode, content);
                controller.getMessageHandler().accept(message);
                if (abort) {
                    TerminationException te = new TerminationException("Processing terminated by " + StandardDiagnostics.getInstructionNameDefault(expr) + " at line " + expr.getLocation().getLineNumber() + " in " + StandardDiagnostics.abbreviateLocationURIDefault(expr.getLocation().getSystemId()));
                    te.setLocation(expr.getLocation());
                    te.setErrorCodeQName(errorCode);
                    te.setErrorObject(content);
                    throw te;
                }
                return null;
            };
        }
    }

    private static class MessageAdapter
    extends ProxyReceiver {
        public MessageAdapter(SequenceReceiver next) {
            super(next);
        }

        @Override
        public void startDocument(int properties) throws XPathException {
            super.startDocument(properties);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            super.startElement(elemName, type, attributes, namespaces, location, properties);
        }

        @Override
        public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
            if (item instanceof NodeInfo) {
                int kind = ((NodeInfo)item).getNodeKind();
                if (kind == 2) {
                    String attName = ((NodeInfo)item).getDisplayName();
                    this.processingInstruction("attribute", StringView.of("name=\"" + attName + "\" value=\"" + item.getUnicodeStringValue() + "\""), locationId, 0);
                    return;
                }
                if (kind == 13) {
                    String prefix = ((NodeInfo)item).getLocalPart();
                    this.processingInstruction("namespace", StringView.of("prefix=\"" + prefix + "\" uri=\"" + item.getUnicodeStringValue() + "\""), Loc.NONE, 0);
                    return;
                }
            } else if (item instanceof FunctionItem && !((FunctionItem)item).isArray()) {
                String representation = ((FunctionItem)item).isMap() ? Err.depict(item) : "Function " + Err.depict(item);
                this.nextReceiver.characters(StringView.of(representation), locationId, 0);
                return;
            }
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
    }
}

