/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.dom;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.execution.ExecutionStopper;
import ro.sync.basic.execution.StoppedByUserXNIException;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.XercesOutputInhibitor;
import ro.sync.basic.xml.dom.location.DocHeaderExtractorReader;
import ro.sync.basic.xml.dom.location.NodeRange;
import ro.sync.basic.xml.dom.location.SyntacticRange;

public class LocationDomParser
extends DOMParser {
    private static final String BASE = "base";
    private static final String HTTP_WWW_W3_ORG_XML_1998_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String COMPUTE_ATTR_LOCATION_FEATURE = "COMPUTE_ATTR_LOCATION_FEATURE";
    private XMLLocator xLocator;
    private boolean containsRelativeExternalEntityDeclarations;
    private int lastLine;
    private int lastColumn;
    private static Logger logger = LoggerFactory.getLogger((String)LocationDomParser.class.getName());
    private DocHeaderExtractorReader reader;
    private boolean inDoctype = false;
    private Field errorReporterLocatorField;
    private int lastReportedLineInDTD = 0;
    private int lastReportedColumnInDTD = 0;
    private Node dtdNode;
    private boolean hasInternalSubsetOrInExternalDTD;
    private boolean createDTDNodeRange = false;
    private int endDTDLineMarker = -1;
    private int endDTDColumnMarker = -1;
    private boolean expandsExternalEntities;
    private ExecutionStopper executionStopper = null;
    private XMLErrorReporter errorReporter;
    private String mainSystemID;
    private HashMap xmlBaseElements;
    private List allElemsOfExtEntity;
    private String lastSystemId = null;
    private Stack locationBeforeEntStack = new Stack();

    private final XMLLocator getLocator() {
        XMLLocator loc = this.xLocator;
        if (this.errorReporter != null) {
            try {
                loc = (XMLLocator)this.errorReporterLocatorField.get(this.errorReporter);
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.errorReporter = null;
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.errorReporter = null;
            }
        }
        return loc;
    }

    public LocationDomParser() {
        this(false);
        this.findErrorReporter();
    }

    LocationDomParser(boolean forXPath) {
        this.setFeatures(forXPath);
        this.findErrorReporter();
        this.expandsExternalEntities = forXPath;
    }

    public void setExecutionStopper(ExecutionStopper executionStopper) {
        this.executionStopper = executionStopper;
    }

    private void findErrorReporter() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    LocationDomParser.this.errorReporterLocatorField = XMLErrorReporter.class.getDeclaredField("fLocator");
                    LocationDomParser.this.errorReporterLocatorField.setAccessible(true);
                }
                catch (SecurityException e) {
                    logger.error("Cannot identify the locator field in the error reporter (1).", (Throwable)e);
                    LocationDomParser.this.errorReporterLocatorField = null;
                }
                catch (NoSuchFieldException e) {
                    logger.error("Cannot identify the locator field in the error reporter (2).");
                    LocationDomParser.this.errorReporterLocatorField = null;
                }
                LocationDomParser.this.errorReporter = (XMLErrorReporter)LocationDomParser.this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-reporter");
                if (LocationDomParser.this.errorReporterLocatorField == null) {
                    LocationDomParser.this.errorReporter = null;
                }
                return null;
            }
        });
    }

    public LocationDomParser(XMLParserConfiguration config, boolean forXPath) {
        super(config);
        this.setFeatures(forXPath);
        this.findErrorReporter();
    }

    public void setInputSource(InputSource inputSource) {
        this.mainSystemID = inputSource.getSystemId();
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            throw new UnsupportedOperationException("This class requires a character stream to be set on the given input source");
        }
        this.reader = new DocHeaderExtractorReader(reader);
        inputSource.setCharacterStream(this.reader);
    }

    private void setFeatures(boolean forXPath) {
        try {
            this.setFeature(COMPUTE_ATTR_LOCATION_FEATURE, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", true);
            this.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            if (forXPath) {
                this.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
                this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            } else {
                this.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", true);
                this.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                this.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            this.setErrorHandler(new XercesOutputInhibitor());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.xLocator = locator;
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        boolean rootElementNotEncountered;
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("Start Element: elemName = " + element + " line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber() + " sysID = " + URLUtil.filterPasswords(locator.getExpandedSystemId()));
        }
        super.startElement(element, attributes, augs);
        Node elementObj = this.fCurrentNode;
        int len = attributes.getLength();
        String[] order = new String[len];
        for (int i = 0; i < len; ++i) {
            String qName;
            order[i] = qName = attributes.getQName(i);
        }
        if (elementObj != null) {
            BasicXmlUtil.setAttributesOrderData(elementObj, order);
        }
        boolean bl = rootElementNotEncountered = this.reader != null && !this.reader.isRootReached();
        if (rootElementNotEncountered) {
            int[] temp = LocationDomParser.getLocationOfSeqBeforeLineCol(this.getDocHeader(), locator.getLineNumber(), locator.getColumnNumber(), "<");
            this.lastLine = temp[0];
            this.lastColumn = temp[1];
        }
        if (!rootElementNotEncountered && !Equaler.verifyEquals(this.lastSystemId, locator.getExpandedSystemId())) {
            this.lastLine = locator.getLineNumber();
            this.lastColumn = 1;
            this.updateLocationFromXInclude();
        }
        NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
        nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
        if (this.createDTDNodeRange) {
            this.endDTDLineMarker = this.lastLine;
            this.endDTDColumnMarker = this.lastColumn;
        }
        BasicXmlUtil.setUserdata(elementObj, "Ld", nodeData, null);
        if (len > 0) {
            NamedNodeMap attrs = elementObj.getAttributes();
            for (int i = 0; i < len; ++i) {
                int[] range = (int[])attributes.getAugmentations(i).getItem(COMPUTE_ATTR_LOCATION_FEATURE);
                if (range == null) continue;
                NodeRange attrNodeData = new NodeRange(locator.getExpandedSystemId());
                attrNodeData.setSyntacticRange(new SyntacticRange(range[0], range[1], range[2], range[3]));
                BasicXmlUtil.setUserdata(attrs.getNamedItem(attributes.getQName(i)), "Ld", attrNodeData, null);
            }
        }
        this.createRangeForDTD();
        if (this.reader != null && !this.reader.isRootReached()) {
            this.reader.markRootReached();
            this.reader.disposeBuffer();
        }
        this.updateLastPosition();
    }

    private void updateLocationFromXInclude() {
        XIncludeHandler xIncludeHandler = (XIncludeHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/xinclude-handler");
        if (xIncludeHandler != null) {
            try {
                Field lineDeclaredField = XIncludeHandler.class.getDeclaredField("endXIncludeLineNumber");
                int endXIncludeLineNumber = (Integer)lineDeclaredField.get(xIncludeHandler);
                if (endXIncludeLineNumber != -1) {
                    Field colDeclaredField = XIncludeHandler.class.getDeclaredField("endXIncludeColNumber");
                    int endXIncludeColNumber = (Integer)colDeclaredField.get(xIncludeHandler);
                    this.lastLine = endXIncludeLineNumber;
                    this.lastColumn = endXIncludeColNumber;
                    lineDeclaredField.set(xIncludeHandler, -1);
                    colDeclaredField.set(xIncludeHandler, -1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static int[] getLocationOfSeqBeforeLineCol(StringBuffer docHeaderBuffer, int lineNumber, int columnNumber, String sequence) {
        int line = 1;
        int offset = 0;
        int startLineOffset = 0;
        int[] toReturn = new int[2];
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Header:\n " + docHeaderBuffer);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("lineNumber:\n " + lineNumber);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("columnNumber:\n " + columnNumber);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sequence:\n " + sequence);
            }
            while (line < lineNumber) {
                while (!LocationDomParser.isLineBreak(docHeaderBuffer, offset)) {
                    ++offset;
                }
                String lineContent = docHeaderBuffer.substring(startLineOffset, offset);
                int lastIndex = lineContent.lastIndexOf(sequence);
                if (lastIndex != -1) {
                    toReturn[0] = line;
                    toReturn[1] = lastIndex + 1;
                }
                startLineOffset = ++offset;
                ++line;
            }
            int endLineOffset = Math.min(startLineOffset + columnNumber - 1, docHeaderBuffer.length());
            String lastLineContent = docHeaderBuffer.substring(startLineOffset, endLineOffset);
            int lastIndex = lastLineContent.lastIndexOf(sequence);
            if (lastIndex != -1) {
                toReturn[0] = line;
                toReturn[1] = lastIndex + 1;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            toReturn[0] = lineNumber;
            toReturn[1] = columnNumber;
        }
        return toReturn;
    }

    private static final boolean isLineBreak(StringBuffer buf, int offset) {
        char ch = buf.charAt(offset);
        if (ch == '\n') {
            return true;
        }
        if (ch == '\r') {
            if (offset < buf.length() - 1) {
                ch = buf.charAt(offset + 1);
                return ch != '\n';
            }
            return true;
        }
        return false;
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("End CDATA:  line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber());
        }
        super.endCDATA(augs);
        Node cdata = this.fCurrentNode.getLastChild();
        if (cdata != null && cdata.getNodeType() == 4) {
            NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
            nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
            BasicXmlUtil.setUserdata(cdata, "Ld", nodeData, null);
            this.updateLastPosition();
        }
    }

    public void startDTD(XMLLocator locator, Augmentations augs) throws XNIException {
        this.inDoctype = true;
        super.startDTD(locator, augs);
    }

    public void endDTD(Augmentations augs) throws XNIException {
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("End DTD: line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber() + " systemID = " + URLUtil.filterPasswords(locator.getExpandedSystemId()) + " lastReportedLineInDTD: " + this.lastReportedLineInDTD + " lastReportedColumnInDTD: " + this.lastReportedColumnInDTD);
        }
        super.endDTD(augs);
        this.dtdNode = this.fCurrentNode.getLastChild();
        boolean bl = this.hasInternalSubsetOrInExternalDTD = this.fInternalSubset != null && this.fInternalSubset.length() > 0 || !Equaler.verifyEquals(this.mainSystemID, locator.getExpandedSystemId());
        if (!this.hasInternalSubsetOrInExternalDTD) {
            this.lastReportedLineInDTD = locator.getLineNumber();
            this.lastReportedColumnInDTD = locator.getColumnNumber();
        }
        this.inDoctype = false;
        this.createDTDNodeRange = true;
    }

    private void createRangeForDTD() {
        if (this.createDTDNodeRange) {
            int[] temp;
            this.createDTDNodeRange = false;
            int line = this.lastReportedLineInDTD;
            int column = this.lastReportedColumnInDTD;
            NodeRange nodeData = new NodeRange(this.mainSystemID);
            if (this.reader != null && !this.reader.isRootReached()) {
                temp = LocationDomParser.getLocationOfSeqBeforeLineCol(this.getDocHeader(), this.endDTDLineMarker, this.endDTDColumnMarker, ">");
                line = temp[0];
                column = temp[1] + 1;
            }
            if (this.reader != null && !this.reader.isRootReached()) {
                temp = LocationDomParser.getLocationOfSeqBeforeLineCol(this.getDocHeader(), this.lastReportedLineInDTD, this.lastReportedColumnInDTD, "<!DOCTYPE");
                this.lastLine = temp[0];
                this.lastColumn = temp[1];
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" +++ Create DTD :  start: " + this.lastLine + ":" + this.lastColumn + " End " + line + ":" + column);
            }
            nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, line, column));
            BasicXmlUtil.setUserdata(this.dtdNode, "Ld", nodeData, null);
            this.lastLine = line;
            this.lastColumn = column;
            this.lastSystemId = this.mainSystemID;
            this.dtdNode = null;
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        Node elementObj = this.fCurrentNode.getLastChild();
        NodeRange nodeData = (NodeRange)BasicXmlUtil.getUserdata(elementObj, "Ld");
        XMLLocator locator = this.getLocator();
        nodeData.setEndElementSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
        if (elementObj.getFirstChild() != null) {
            nodeData.setEmptyElementState(1);
        } else {
            nodeData.setEmptyElementState(2);
        }
        BasicXmlUtil.setUserdata(elementObj, "Ld", nodeData, null);
        this.updateLastPosition();
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        super.comment(text, augs);
        this.checkLastLocationInDTD(false);
        if (!this.inDoctype) {
            XMLLocator locator = this.getLocator();
            if (logger.isDebugEnabled()) {
                logger.debug("Comment : test =  " + text + " line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber());
            }
            Node comment = this.fCurrentNode.getLastChild();
            if (logger.isDebugEnabled()) {
                logger.debug(" +++ Create comment :  " + text + " start: " + this.lastLine + ":" + this.lastColumn + " End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
            }
            if (this.reader != null && !this.reader.isRootReached()) {
                int[] temp = LocationDomParser.getLocationOfSeqBeforeLineCol(this.getDocHeader(), locator.getLineNumber(), locator.getColumnNumber(), "<!--");
                this.lastLine = temp[0];
                this.lastColumn = temp[1];
            }
            NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
            nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
            if (this.createDTDNodeRange) {
                this.endDTDLineMarker = this.lastLine;
                this.endDTDColumnMarker = this.lastColumn;
            }
            BasicXmlUtil.setUserdata(comment, "Ld", nodeData, null);
            this.updateLastPosition();
        }
        this.createRangeForDTD();
    }

    private void checkLastLocationInDTD(boolean inAttrDeclaration) {
        if (this.executionStopper != null && this.executionStopper.mustStop()) {
            throw new StoppedByUserXNIException();
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("PI : target =  " + target + " line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber());
        }
        super.processingInstruction(target, data, augs);
        this.checkLastLocationInDTD(false);
        if (!this.inDoctype) {
            Node pi = this.fCurrentNode.getLastChild();
            if (this.reader != null && !this.reader.isRootReached()) {
                int[] temp = LocationDomParser.getLocationOfSeqBeforeLineCol(this.getDocHeader(), locator.getLineNumber(), locator.getColumnNumber(), "<?");
                this.lastLine = temp[0];
                this.lastColumn = temp[1];
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" +++ Create PI :  " + target + " start: " + this.lastLine + ":" + this.lastColumn + " End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
            }
            NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
            nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
            if (this.createDTDNodeRange) {
                this.endDTDLineMarker = this.lastLine;
                this.endDTDColumnMarker = this.lastColumn;
            }
            BasicXmlUtil.setUserdata(pi, "Ld", nodeData, null);
            this.updateLastPosition();
        }
        this.createRangeForDTD();
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("IW : text =  " + text + " line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber());
        }
        super.ignorableWhitespace(text, augs);
        Node chars = this.fCurrentNode.getLastChild();
        if (chars.getNodeType() == 3) {
            Object userData = BasicXmlUtil.getUserdata(chars, "Ld");
            if (userData != null && userData instanceof NodeRange) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" +++ Buffer IW Set new end :   End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
                }
                SyntacticRange diffRange = ((NodeRange)userData).getSyntacticRange();
                diffRange.setEndLine(locator.getLineNumber());
                diffRange.setEndColumn(locator.getColumnNumber());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(" +++ Create IW first time :  " + text + " start: " + this.lastLine + ":" + this.lastColumn + " End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
                }
                NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
                nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
                BasicXmlUtil.setUserdata(chars, "Ld", nodeData, null);
            }
        }
        this.updateLastPosition();
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        super.characters(text, augs);
        XMLLocator locator = this.getLocator();
        if (!this.fInCDATASection) {
            Node chars = this.fCurrentNode.getLastChild();
            if (chars.getNodeType() == 3) {
                Object userData = BasicXmlUtil.getUserdata(chars, "Ld");
                if (userData != null && userData instanceof NodeRange) {
                    SyntacticRange diffRange = ((NodeRange)userData).getSyntacticRange();
                    if (Equaler.verifyEquals(((NodeRange)userData).getSystemID(), locator.getExpandedSystemId())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(" +++ Buffer text, same file , set new end : End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
                        }
                        diffRange.setEndLine(locator.getLineNumber());
                        diffRange.setEndColumn(locator.getColumnNumber());
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug(" +++ Buffer text, other file , set new end : End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
                        }
                        diffRange.setEndLine(diffRange.getStartLine());
                        diffRange.setEndColumn(diffRange.getStartColumn());
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug(" +++ Create text first time :  " + text + " start: " + this.lastLine + ":" + this.lastColumn + " End " + locator.getLineNumber() + ":" + locator.getColumnNumber());
                    }
                    NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
                    nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, locator.getLineNumber(), locator.getColumnNumber()));
                    BasicXmlUtil.setUserdata(chars, "Ld", nodeData, null);
                }
            }
            this.updateLastPosition();
        }
    }

    private void updateLastPosition() {
        XMLLocator locator = this.getLocator();
        if (locator.getLineNumber() != -1 && locator.getColumnNumber() != -1) {
            this.lastLine = locator.getLineNumber();
            this.lastColumn = locator.getColumnNumber();
        }
        this.lastSystemId = locator.getExpandedSystemId();
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("XML Decl :  line = " + locator.getLineNumber() + " column = " + locator.getColumnNumber());
        }
        super.xmlDecl(version, encoding, standalone, augs);
        this.updateLastPosition();
    }

    @Deprecated
    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.setInputSource(inputSource);
        super.parse(inputSource);
    }

    public void parse(Reader reader, String systemID) throws SAXException, IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        source.setSystemId(systemID);
        this.parse(source);
    }

    public void parse(String systemId) throws SAXException, IOException {
        super.parse(systemId);
    }

    private StringBuffer getDocHeader() {
        return this.reader != null ? this.reader.getDocHeaderBuffer() : new StringBuffer();
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.xmlBaseElements == null) {
            this.xmlBaseElements = new HashMap(1);
        } else {
            this.xmlBaseElements.clear();
        }
        if (this.allElemsOfExtEntity == null) {
            this.allElemsOfExtEntity = new Vector(1);
        } else {
            this.allElemsOfExtEntity.clear();
        }
        for (Node item = this.fCurrentNode.getFirstChild(); item != null; item = item.getNextSibling()) {
            if (item.getNodeType() != 1) continue;
            Element elem = (Element)item;
            this.allElemsOfExtEntity.add(elem);
            if (!elem.hasAttributeNS(HTTP_WWW_W3_ORG_XML_1998_NAMESPACE, BASE)) continue;
            this.xmlBaseElements.put(elem, Boolean.TRUE);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("=== End entity " + name);
        }
        super.endGeneralEntity(name, augs);
        for (Element elem : this.allElemsOfExtEntity) {
            if (!elem.hasAttributeNS(HTTP_WWW_W3_ORG_XML_1998_NAMESPACE, BASE) || this.xmlBaseElements.containsKey(elem)) continue;
            elem.getAttributes().removeNamedItemNS(HTTP_WWW_W3_ORG_XML_1998_NAMESPACE, BASE);
        }
        if (this.locationBeforeEntStack.isEmpty()) {
            throw new XNIException("oXygen internal error. start and end of general entity do not match.");
        }
        Object[] location = (Object[])this.locationBeforeEntStack.pop();
        this.lastLine = (Integer)location[0];
        this.lastColumn = (Integer)location[1];
        this.lastSystemId = (String)location[2];
        if (logger.isDebugEnabled()) {
            logger.debug("Restored " + URLUtil.filterPasswords(this.lastSystemId));
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        int endEntityColumn = this.lastColumn + name.length() + 2;
        super.startGeneralEntity(name, identifier, encoding, augs);
        Node entityNode = this.fCurrentNode;
        if (logger.isDebugEnabled()) {
            logger.debug(" +++ Create ENTITY node :" + name + "  start: " + this.lastLine + ":" + this.lastColumn + " End " + this.lastLine + ":" + endEntityColumn);
        }
        XMLLocator locator = this.getLocator();
        NodeRange nodeData = new NodeRange(locator.getExpandedSystemId());
        nodeData.setSyntacticRange(new SyntacticRange(this.lastLine, this.lastColumn, this.lastLine, endEntityColumn));
        BasicXmlUtil.setUserdata(entityNode, "Ld", nodeData, null);
        this.locationBeforeEntStack.push(new Object[]{NumberParserUtil.valueOfInteger(this.lastLine), NumberParserUtil.valueOfInteger(endEntityColumn), this.lastSystemId});
        if (!this.expandsExternalEntities) {
            this.lastColumn = 1;
            this.lastLine = 1;
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        super.emptyElement(element, attributes, augs);
        Node elementObj = this.fCurrentNode.getLastChild();
        NodeRange nodeData = (NodeRange)BasicXmlUtil.getUserdata(elementObj, "Ld");
        nodeData.setEmptyElementState(0);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        super.doctypeDecl(rootElement, publicId, systemId, augs);
        XMLLocator locator = this.getLocator();
        if (logger.isDebugEnabled()) {
            logger.debug("doctypeDecl Locator line: " + this.getLocator().getLineNumber() + " col: " + this.getLocator().getColumnNumber());
        }
        this.lastReportedLineInDTD = locator.getLineNumber();
        this.lastReportedColumnInDTD = locator.getColumnNumber();
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augs) throws XNIException {
        super.internalEntityDecl(name, text, nonNormalizedText, augs);
        this.checkLastLocationInDTD(false);
    }

    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        if (!this.containsRelativeExternalEntityDeclarations && this.inDoctype && !name.startsWith("%")) {
            try {
                new URL(identifier.getLiteralSystemId());
            }
            catch (MalformedURLException ex) {
                this.containsRelativeExternalEntityDeclarations = true;
            }
        }
        super.externalEntityDecl(name, identifier, augs);
        this.checkLastLocationInDTD(false);
    }

    public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        super.startParameterEntity(name, identifier, encoding, augs);
        this.checkLastLocationInDTD(false);
    }

    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augs) throws XNIException {
        super.unparsedEntityDecl(name, identifier, notation, augs);
        this.checkLastLocationInDTD(false);
    }

    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        super.notationDecl(name, identifier, augs);
        this.checkLastLocationInDTD(false);
    }

    public void elementDecl(String name, String contentModel, Augmentations augs) throws XNIException {
        super.elementDecl(name, contentModel, augs);
        this.checkLastLocationInDTD(false);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augs) throws XNIException {
        super.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue, nonNormalizedDefaultValue, augs);
        this.checkLastLocationInDTD(true);
    }

    public void reset() throws XNIException {
        this.allElemsOfExtEntity = null;
        this.hasInternalSubsetOrInExternalDTD = false;
        this.createDTDNodeRange = false;
        this.dtdNode = null;
        super.reset();
    }

    public boolean isContainsRelativeExternalEntityDeclarations() {
        return this.containsRelativeExternalEntityDeclarations;
    }
}

