/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class TypedMaps {
    private static final Logger logger = LoggerFactory.getLogger((String)TypedMaps.class.getName());

    public static <K> int getInt(Map<K, ?> map, K key, int defaultValue) {
        int value = defaultValue;
        try {
            value = (Integer)map.get(key);
        }
        catch (ClassCastException e) {
            TypedMaps.valueWarn(key, e);
        }
        catch (NullPointerException e) {
            TypedMaps.valueWarn(key, e);
        }
        return value;
    }

    private static <K> void valueWarn(K key, Exception e) {
        logger.warn("Error retrieving key: " + key, (Throwable)e);
    }

    public static <K> String getString(Map<K, ?> map, K key, String defaultValue) {
        String value = defaultValue;
        try {
            value = (String)map.get(key);
        }
        catch (ClassCastException e) {
            TypedMaps.valueWarn(key, e);
        }
        catch (NullPointerException e) {
            TypedMaps.valueWarn(key, e);
        }
        return value;
    }

    public static <K> boolean getBoolean(Map<K, ?> map, K key, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = (Boolean)map.get(key);
        }
        catch (ClassCastException e) {
            TypedMaps.valueWarn(key, e);
        }
        catch (NullPointerException e) {
            TypedMaps.valueWarn(key, e);
        }
        return value;
    }
}

