/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.zip.ArchiveSecurityUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public final class ZipUtil {
    private static final int BUFFER_SIZE = 2000;
    private static final Comparator<File> FILE_COMPARATOR = (o1, o2) -> {
        if (o1.isDirectory() == o2.isDirectory()) {
            return o1.compareTo((File)o2);
        }
        if (o1.isDirectory()) {
            return -1;
        }
        return 0;
    };

    private ZipUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File zipFile, File dir2Zip, FileFilter fileFilter, boolean recursive, boolean useDirNameAsArchiveRoot) throws Exception {
        long timestamp;
        block12: {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream out = new ZipOutputStream((OutputStream)fos, StandardCharsets.UTF_8);
            timestamp = -1L;
            IOException error = null;
            try {
                timestamp = ZipUtil.addDir(dir2Zip, out, fileFilter, useDirNameAsArchiveRoot ? dir2Zip.getName() : "", recursive);
            }
            catch (IOException e) {
                error = e;
            }
            finally {
                block13: {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        if (error != null) break block13;
                        error = ex;
                    }
                }
                if (error == null) break block12;
                throw error;
            }
        }
        if (timestamp > 0L) {
            zipFile.setLastModified(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unzip(File zippedFile, File destinationDirectory, FileFilter fileFilter) throws IOException {
        ArrayList<File> arrayList;
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)new FileInputStream(zippedFile), StandardCharsets.UTF_8);
        try {
            TreeSet<File> topLevel = new TreeSet<File>(FILE_COMPARATOR);
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File newDir = new File(destinationDirectory, entry.getName());
                    ArchiveSecurityUtil.checkSafe(entry.getName(), newDir, destinationDirectory);
                    if (fileFilter != null && !fileFilter.accept(newDir)) continue;
                    newDir.mkdirs();
                    File root = ZipUtil.getRoot(destinationDirectory, newDir);
                    if (root == null) continue;
                    topLevel.add(root);
                    continue;
                }
                File destFile = new File(destinationDirectory, entry.getName());
                ArchiveSecurityUtil.checkSafe(entry.getName(), destFile, destinationDirectory);
                if (fileFilter != null && !fileFilter.accept(destFile)) continue;
                destFile.getParentFile().mkdirs();
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile), 2000);){
                    int count;
                    byte[] buff = new byte[2000];
                    while ((count = zipInputStream.read(buff)) != -1) {
                        bos.write(buff, 0, count);
                    }
                }
                File root = ZipUtil.getRoot(destinationDirectory, destFile);
                if (root == null) continue;
                topLevel.add(root);
            }
            arrayList = new ArrayList<File>(topLevel);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new IOException("Problem unzipping " + zippedFile, ex);
            }
        }
        zipInputStream.close();
        return arrayList;
    }

    private static File getRoot(File destinationDir, File archiveEntryFile) {
        File candidate;
        File rootDir = null;
        for (candidate = archiveEntryFile; candidate != null && !destinationDir.equals(candidate.getParentFile()); candidate = candidate.getParentFile()) {
        }
        if (candidate != null && destinationDir.equals(candidate.getParentFile())) {
            rootDir = candidate;
        }
        return rootDir;
    }

    private static long addDir(File dir, ZipOutputStream out, FileFilter fileFilter, String prefix, boolean recursive) throws IOException {
        long timestamp = dir.lastModified();
        byte[] tmpBuf = new byte[1024];
        if (prefix.length() > 0) {
            out.putNextEntry(new ZipEntry(prefix + "/"));
        }
        File[] files = dir.listFiles(fileFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                if (!recursive) continue;
                Object localPrefix = null;
                localPrefix = prefix.length() == 0 ? files[i].getName() : prefix + "/" + files[i].getName();
                timestamp = Math.max(timestamp, ZipUtil.addDir(files[i], out, fileFilter, (String)localPrefix, recursive));
                continue;
            }
            try (FileInputStream in = new FileInputStream(files[i].getAbsolutePath());){
                int len;
                String entryName = files[i].getName();
                if (prefix.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(prefix).append('/').append(entryName);
                    entryName = sb.toString();
                }
                out.putNextEntry(new ZipEntry(entryName));
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
            }
            timestamp = Math.max(timestamp, files[i].lastModified());
        }
        return timestamp;
    }
}

