/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.html;

import java.util.Map;
import org.zwobble.mammoth.internal.html.HtmlCommentElement;
import org.zwobble.mammoth.internal.html.HtmlElement;
import org.zwobble.mammoth.internal.html.HtmlForceWrite;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.html.HtmlTextNode;
import org.zwobble.mammoth.internal.util.Lists;

public class HtmlWriter {
    public static void write(HtmlNode node, final StringBuilder builder) {
        node.accept(new HtmlNode.Visitor(){

            @Override
            public void visit(HtmlElement element) {
                builder.append("<").append(element.getTagName());
                HtmlWriter.generateAttributes(element.getAttributes(), builder);
                if (element.isVoid()) {
                    builder.append(" />");
                } else {
                    builder.append(">");
                    element.getChildren().forEach(child -> HtmlWriter.write(child, builder));
                    builder.append("</").append(element.getTagName()).append(">");
                }
            }

            @Override
            public void visit(HtmlTextNode node) {
                builder.append(HtmlWriter.escapeText(node.getValue()));
            }

            @Override
            public void visit(HtmlForceWrite forceWrite) {
            }

            @Override
            public void visit(HtmlCommentElement commentElement) {
                builder.append("<!--").append(commentElement.getCommentContent()).append("-->");
            }
        });
    }

    private static void generateAttributes(Map<String, String> attributes, StringBuilder builder) {
        for (Map.Entry attribute : Lists.orderedBy(attributes.entrySet(), Map.Entry::getKey)) {
            builder.append(" ").append((String)attribute.getKey()).append("=\"").append(HtmlWriter.escapeAttributeValue((String)attribute.getValue())).append("\"");
        }
    }

    private static String escapeText(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String escapeAttributeValue(String value) {
        return HtmlWriter.escapeText(value).replace("\"", "&quot;");
    }
}

