/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zwobble.mammoth.internal.html.HtmlCommentElement;
import org.zwobble.mammoth.internal.html.HtmlElement;
import org.zwobble.mammoth.internal.html.HtmlForceWrite;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.html.HtmlTextNode;
import org.zwobble.mammoth.internal.html.HtmlWriter;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.Optionals;

public class Html {
    public static final HtmlNode FORCE_WRITE = HtmlForceWrite.FORCE_WRITE;

    public static String write(List<HtmlNode> nodes) {
        StringBuilder builder = new StringBuilder();
        nodes.forEach(node -> HtmlWriter.write(node, builder));
        return builder.toString();
    }

    public static HtmlNode text(String value) {
        return new HtmlTextNode(value);
    }

    public static HtmlNode element(String tagName) {
        return Html.element(tagName, Lists.list());
    }

    public static HtmlNode element(String tagName, Map<String, String> attributes) {
        return Html.element(tagName, attributes, Lists.list());
    }

    public static HtmlNode element(String tagName, List<HtmlNode> children) {
        return Html.element(tagName, Maps.map(), children);
    }

    public static HtmlNode element(String tagName, Map<String, String> attributes, List<HtmlNode> children) {
        return new HtmlElement(new HtmlTag(Lists.list(tagName), attributes, false, ""), children);
    }

    public static HtmlNode collapsibleElement(String tagName) {
        return Html.collapsibleElement(Lists.list(tagName));
    }

    public static HtmlNode collapsibleElement(List<String> tagNames) {
        return Html.collapsibleElement(tagNames, Maps.map(), Lists.list());
    }

    public static HtmlNode collapsibleElement(String tagName, List<HtmlNode> children) {
        return Html.collapsibleElement(tagName, Maps.map(), children);
    }

    public static HtmlNode collapsibleElement(String tagName, Map<String, String> attributes, List<HtmlNode> children) {
        return Html.collapsibleElement(Lists.list(tagName), attributes, children);
    }

    public static HtmlNode collapsibleElement(List<String> tagNames, Map<String, String> attributes, List<HtmlNode> children) {
        return new HtmlElement(new HtmlTag(tagNames, attributes, true, ""), children);
    }

    public static List<HtmlNode> stripEmpty(List<HtmlNode> nodes) {
        return Lists.eagerFlatMap(nodes, node -> Html.stripEmpty(node));
    }

    private static List<HtmlNode> stripEmpty(HtmlNode node) {
        return node.accept(new HtmlNode.Mapper<List<HtmlNode>>(){

            @Override
            public List<HtmlNode> visit(HtmlElement element) {
                List<HtmlNode> children = Html.stripEmpty(element.getChildren());
                if (children.isEmpty() && !element.isVoid()) {
                    return Lists.list();
                }
                return Lists.list(new HtmlElement(element.getTag(), children));
            }

            @Override
            public List<HtmlNode> visit(HtmlTextNode node) {
                if (node.getValue().isEmpty()) {
                    return Lists.list();
                }
                return Lists.list(node);
            }

            @Override
            public List<HtmlNode> visit(HtmlForceWrite forceWrite) {
                return Lists.list(forceWrite);
            }

            @Override
            public List<HtmlNode> visit(HtmlCommentElement commentElement) {
                if (commentElement.getCommentContent().isEmpty()) {
                    return Lists.list();
                }
                return Lists.list(commentElement);
            }
        });
    }

    public static List<HtmlNode> collapse(List<HtmlNode> nodes) {
        ArrayList<HtmlNode> collapsed = new ArrayList<HtmlNode>();
        for (HtmlNode node : nodes) {
            Html.collapsingAdd(collapsed, node);
        }
        return collapsed;
    }

    private static void collapsingAdd(List<HtmlNode> collapsed, HtmlNode node) {
        HtmlNode collapsedNode = Html.collapse(node);
        if (!Html.tryCollapse(collapsed, collapsedNode)) {
            collapsed.add(collapsedNode);
        }
    }

    private static HtmlNode collapse(HtmlNode node) {
        return node.accept(new HtmlNode.Mapper<HtmlNode>(){

            @Override
            public HtmlNode visit(HtmlElement element) {
                return new HtmlElement(element.getTag(), Html.collapse(element.getChildren()));
            }

            @Override
            public HtmlNode visit(HtmlTextNode node) {
                return node;
            }

            @Override
            public HtmlNode visit(HtmlForceWrite forceWrite) {
                return forceWrite;
            }

            @Override
            public HtmlNode visit(HtmlCommentElement commentElement) {
                return commentElement;
            }
        });
    }

    private static boolean tryCollapse(List<HtmlNode> collapsed, HtmlNode node) {
        return Optionals.map(Lists.tryGetLast(collapsed).flatMap(last -> Casts.tryCast(HtmlElement.class, last)), Casts.tryCast(HtmlElement.class, node), (last, next) -> {
            if (next.isCollapsible() && Html.isMatch(last, next)) {
                String separator = next.getSeparator();
                if (!separator.isEmpty()) {
                    last.getChildren().add(Html.text(separator));
                }
                for (HtmlNode child : next.getChildren()) {
                    Html.collapsingAdd(last.getChildren(), child);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static boolean isMatch(HtmlElement first, HtmlElement second) {
        return second.getTagNames().contains(first.getTagName()) && first.getAttributes().equals(second.getAttributes());
    }
}

