/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zwobble.mammoth.internal.archives.Archive;
import org.zwobble.mammoth.internal.archives.Archives;
import org.zwobble.mammoth.internal.documents.Bookmark;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.CommentReference;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.Hyperlink;
import org.zwobble.mammoth.internal.documents.Image;
import org.zwobble.mammoth.internal.documents.IndexTerm;
import org.zwobble.mammoth.internal.documents.Math;
import org.zwobble.mammoth.internal.documents.NoteReference;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.ParagraphIndent;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.SEQCaption;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.documents.Tab;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.documents.TableCell;
import org.zwobble.mammoth.internal.documents.TableGrid;
import org.zwobble.mammoth.internal.documents.TableGridCol;
import org.zwobble.mammoth.internal.documents.TableRow;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.documents.VerticalAlignment;
import org.zwobble.mammoth.internal.docx.BookmarkUtil;
import org.zwobble.mammoth.internal.docx.ContentTypes;
import org.zwobble.mammoth.internal.docx.Dingbats;
import org.zwobble.mammoth.internal.docx.FileReader;
import org.zwobble.mammoth.internal.docx.Numbering;
import org.zwobble.mammoth.internal.docx.OfficeXml;
import org.zwobble.mammoth.internal.docx.ReadResult;
import org.zwobble.mammoth.internal.docx.Relationships;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.docx.TableContext;
import org.zwobble.mammoth.internal.docx.Uris;
import org.zwobble.mammoth.internal.docx.XmlElementUtil;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.InputStreamSupplier;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.Optionals;
import org.zwobble.mammoth.internal.util.Queues;
import org.zwobble.mammoth.internal.util.Sets;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementLike;
import org.zwobble.mammoth.internal.xml.XmlElementList;
import org.zwobble.mammoth.internal.xml.XmlNode;
import org.zwobble.mammoth.internal.xml.XmlWriter;

class StatefulBodyXmlReader {
    private static final Set<String> IMAGE_TYPES_SUPPORTED_BY_BROWSERS = Sets.set("image/png", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff");
    private final Styles styles;
    private final Numbering numbering;
    private final Relationships relationships;
    private final ContentTypes contentTypes;
    private final Archive file;
    private final FileReader fileReader;
    private final StringBuilder currentInstrText;
    private final Queue<ComplexField> complexFieldStack;
    private final StringBuilder currentParaInstrText;
    private Stack<TableContext> tableContexts = new Stack();
    private static final Pattern INDEX_TERM_PATTERN = Pattern.compile("\\s*XE \"((\\\\\"|[^\"])*)\"\\s*(\\\\[biy])*\\s*(\\\\t\\s*\"((\\\\\"|[^\"])*)\")?");
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\s*(INDEX)");
    private static final Pattern HYPERLINK_PATTERN = Pattern.compile("\\s*HYPERLINK([^\"]*)\"(.*)\"");
    private static final Pattern SEQ_TABLE = Pattern.compile("\\s*SEQ\\s*Table");
    private static final Pattern SEQ_FIGURE = Pattern.compile("\\s*SEQ\\s*Figure");
    private static final Pattern HYPERLINK_REF_PATTERN = Pattern.compile("\\s*REF ([^ ]*) [^h]*\\s*\\\\h\\s*[^h]*");

    StatefulBodyXmlReader(Styles styles, Numbering numbering, Relationships relationships, ContentTypes contentTypes, Archive file, FileReader fileReader) {
        this.styles = styles;
        this.numbering = numbering;
        this.relationships = relationships;
        this.contentTypes = contentTypes;
        this.file = file;
        this.fileReader = fileReader;
        this.currentInstrText = new StringBuilder();
        this.complexFieldStack = Queues.stack();
        this.currentParaInstrText = new StringBuilder();
    }

    ReadResult readElement(XmlElement element) {
        switch (element.getName()) {
            case "w:t": {
                return ReadResult.success(new Text(element.innerText()));
            }
            case "w:r": {
                return this.readRun(element);
            }
            case "w:p": {
                return this.readParagraph(element);
            }
            case "w:fldChar": {
                return this.readFieldChar(element);
            }
            case "w:instrText": {
                return this.readInstrText(element);
            }
            case "w:fldSimple": {
                return this.readFieldSimple(element);
            }
            case "w:tab": {
                return ReadResult.success(Tab.TAB);
            }
            case "w:noBreakHyphen": {
                return ReadResult.success(new Text("\u2011"));
            }
            case "w:softHyphen": {
                return ReadResult.success(new Text("\u00ad"));
            }
            case "w:sym": {
                return this.readSymbol(element);
            }
            case "w:br": {
                return this.readBreak(element);
            }
            case "w:tbl": {
                return this.readTable(element);
            }
            case "w:tblGrid": {
                return this.readTableGrid(element);
            }
            case "w:tr": {
                return this.readTableRow(element, Optional.empty());
            }
            case "w:tc": {
                return this.readTableCell(element);
            }
            case "w:hyperlink": {
                return this.readHyperlink(element);
            }
            case "w:bookmarkStart": {
                ReadResult toRetBookmark = ReadResult.EMPTY_SUCCESS;
                if (!this.tableContexts.isEmpty()) {
                    if (!this.tableContexts.peek().isProcessedBookmark(element)) {
                        if (!this.tableContexts.peek().isInTableCellContext()) {
                            this.tableContexts.peek().addUnhandledBookmark(element);
                        } else {
                            toRetBookmark = this.readBookmark(element);
                        }
                    }
                } else {
                    toRetBookmark = this.readBookmark(element);
                }
                return toRetBookmark;
            }
            case "w:footnoteReference": {
                return this.readNoteReference(NoteType.FOOTNOTE, element);
            }
            case "w:endnoteReference": {
                return this.readNoteReference(NoteType.ENDNOTE, element);
            }
            case "w:commentReference": {
                return this.readCommentReference(element);
            }
            case "w:pict": {
                return this.readPict(element);
            }
            case "v:imagedata": {
                return this.readImagedata(element);
            }
            case "wp:inline": 
            case "wp:anchor": {
                return this.readInline(element);
            }
            case "w:sdt": {
                return this.readSdt(element);
            }
            case "w:ins": 
            case "w:object": 
            case "w:smartTag": 
            case "w:drawing": 
            case "v:group": 
            case "v:rect": 
            case "v:roundrect": 
            case "v:shape": 
            case "v:textbox": 
            case "w:txbxContent": {
                return this.readElements(element.getChildren());
            }
            case "office-word:wrap": 
            case "v:shadow": 
            case "v:shapetype": 
            case "w:bookmarkEnd": 
            case "w:sectPr": 
            case "w:proofErr": 
            case "w:lastRenderedPageBreak": 
            case "w:commentRangeStart": 
            case "w:commentRangeEnd": 
            case "w:del": 
            case "w:footnoteRef": 
            case "w:endnoteRef": 
            case "w:annotationRef": 
            case "w:pPr": 
            case "w:rPr": 
            case "w:tblPr": 
            case "w:trPr": 
            case "w:tcPr": {
                return ReadResult.EMPTY_SUCCESS;
            }
            case "m:oMathPara": {
                return this.readElements(element.getChildren());
            }
            case "m:oMath": {
                return this.readMathPara(element);
            }
        }
        String warning = "An unrecognised element was ignored: " + element.getName();
        return ReadResult.emptyWithWarning(warning);
    }

    private ReadResult readRun(XmlElement element) {
        ReadResult readResult = ReadResult.EMPTY_SUCCESS;
        XmlElementLike properties = element.findChildOrEmpty("w:rPr");
        boolean shouldIgnore = ComplexField.INDEX.equals(this.complexFieldStack.peek());
        readResult = ReadResult.map(this.readRunStyle(properties), this.readElements(element.getChildren()), (style, children) -> {
            Optional<HyperlinkComplexField> hyperlinkComplexField = this.currentHyperlinkComplexField();
            if (hyperlinkComplexField.isPresent()) {
                children = Lists.list((DocumentElement)hyperlinkComplexField.get().childrenToHyperlink.apply((List<DocumentElement>)children));
            }
            return new Run(this.isBold(properties), this.isItalic(properties), this.isUnderline(properties), this.isStrikethrough(properties), this.isAllCaps(properties), this.isSmallCaps(properties), this.readVerticalAlignment(properties), (Optional<Style>)style, (List<DocumentElement>)children);
        });
        if (shouldIgnore) {
            readResult = ReadResult.EMPTY_SUCCESS;
        }
        return readResult;
    }

    private ReadResult readMathPara(XmlElement element) {
        ReadResult readResult = ReadResult.EMPTY_SUCCESS;
        try {
            String string = XmlWriter.toString(element, OfficeXml.XML_NAMESPACES, true);
            readResult = ReadResult.success(new Math(string));
        }
        catch (Throwable e) {
            String warning = "A math element cannot be read: " + element.getName();
            readResult = ReadResult.emptyWithWarning(warning);
        }
        return readResult;
    }

    private Optional<HyperlinkComplexField> currentHyperlinkComplexField() {
        return Iterables.tryGetLast(Iterables.lazyFilter(this.complexFieldStack, HyperlinkComplexField.class));
    }

    private boolean isBold(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:b");
    }

    private boolean isItalic(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:i");
    }

    private boolean isUnderline(XmlElementLike properties) {
        return properties.findChild("w:u").flatMap(child -> child.getAttributeOrNone("w:val")).map(value -> !value.equals("false") && !value.equals("0") && !value.equals("none")).orElse(false);
    }

    private boolean isStrikethrough(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:strike");
    }

    private boolean isAllCaps(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:caps");
    }

    private boolean isSmallCaps(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:smallCaps");
    }

    private boolean readBooleanElement(XmlElementLike properties, String tagName) {
        return properties.findChild(tagName).map(child -> child.getAttributeOrNone("w:val").map(value -> !value.equals("false") && !value.equals("0") && !value.equals("none")).orElse(true)).orElse(false);
    }

    private VerticalAlignment readVerticalAlignment(XmlElementLike properties) {
        String verticalAlignment;
        switch (verticalAlignment = this.readVal(properties, "w:vertAlign").orElse("")) {
            case "superscript": {
                return VerticalAlignment.SUPERSCRIPT;
            }
            case "subscript": {
                return VerticalAlignment.SUBSCRIPT;
            }
        }
        return VerticalAlignment.BASELINE;
    }

    private InternalResult<Optional<Style>> readRunStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:rStyle", "Run", this.styles::findCharacterStyleById);
    }

    ReadResult readElements(Iterable<XmlNode> nodes) {
        return ReadResult.flatMap(Iterables.lazyFilter(nodes, XmlElement.class), this::readElement);
    }

    private ReadResult readParagraph(XmlElement element) {
        ReadResult result;
        this.currentParaInstrText.setLength(0);
        XmlElementLike properties = element.findChildOrEmpty("w:pPr");
        boolean shouldIgnore = ComplexField.INDEX.equals(this.complexFieldStack.peek());
        ParagraphIndent indent = this.readParagraphIndent(properties);
        ReadResult childrenResult = this.readElements(element.getChildren());
        InternalResult<Optional<Style>> paraStyle = this.readParagraphStyle(properties);
        if (SEQ_TABLE.matcher(this.currentParaInstrText.toString()).lookingAt()) {
            Paragraph paragraph = new Paragraph(paraStyle.getValue(), this.readNumberingID(properties), this.readNumbering(paraStyle.getValue(), properties), indent, childrenResult.getElements());
            result = ReadResult.success(new SEQCaption(paragraph, true));
        } else if (SEQ_FIGURE.matcher(this.currentParaInstrText.toString()).lookingAt()) {
            Paragraph paragraph = new Paragraph(paraStyle.getValue(), this.readNumberingID(properties), this.readNumbering(paraStyle.getValue(), properties), indent, childrenResult.getElements());
            result = ReadResult.success(new SEQCaption(paragraph, false));
        } else {
            result = ReadResult.map(paraStyle, childrenResult, (style, children) -> new Paragraph((Optional<Style>)style, this.readNumberingID(properties), this.readNumbering((Optional<Style>)style, properties), indent, (List<DocumentElement>)children)).appendExtra();
        }
        if (shouldIgnore) {
            result = ReadResult.EMPTY_SUCCESS;
        }
        return result;
    }

    private ReadResult readFieldChar(XmlElement element) {
        ReadResult toRet = ReadResult.EMPTY_SUCCESS;
        String type = element.getAttributeOrNone("w:fldCharType").orElse("");
        if (type.equals("begin")) {
            this.complexFieldStack.add(ComplexField.UNKNOWN);
            this.currentInstrText.setLength(0);
        } else if (type.equals("end")) {
            this.complexFieldStack.remove();
            String instrText = this.currentInstrText.toString();
            Optional<IndexTerm> indexTerm = this.parseIndexTermFieldCode(instrText);
            if (indexTerm.isPresent()) {
                toRet = ReadResult.success(indexTerm.get());
            }
        } else if (type.equals("separate")) {
            String instrText = this.currentInstrText.toString();
            this.complexFieldStack.remove();
            if (this.isIndexFieldCode(instrText)) {
                this.complexFieldStack.add(ComplexField.INDEX);
            } else {
                ComplexField complexField = this.parseHyperlinkFieldCode(instrText).map(href -> ComplexField.hyperlink(href)).orElse(ComplexField.UNKNOWN);
                this.complexFieldStack.add(complexField);
            }
        }
        return toRet;
    }

    private ReadResult readInstrText(XmlElement element) {
        this.currentInstrText.append(element.innerText());
        this.currentParaInstrText.append(element.innerText());
        return ReadResult.EMPTY_SUCCESS;
    }

    private ReadResult readFieldSimple(XmlElement element) {
        Optional<String> instr = element.getAttributeOrNone("w:instr");
        if (instr.isPresent()) {
            this.currentParaInstrText.append(instr.get());
        }
        return ReadResult.EMPTY_SUCCESS;
    }

    private Optional<IndexTerm> parseIndexTermFieldCode(String instrText) {
        int nuOfGroups;
        Optional<IndexTerm> toRet = Optional.empty();
        Matcher matcherIndexTerm = INDEX_TERM_PATTERN.matcher(instrText);
        if (matcherIndexTerm.lookingAt() && (nuOfGroups = matcherIndexTerm.groupCount()) > 1) {
            String entries = matcherIndexTerm.group(1);
            Optional<String> crossRefEntry = Optional.empty();
            if (nuOfGroups > 4 && matcherIndexTerm.group(5) != null) {
                crossRefEntry = Optional.of(matcherIndexTerm.group(5));
            }
            toRet = Optional.of(new IndexTerm(entries, crossRefEntry));
        }
        return toRet;
    }

    private boolean isIndexFieldCode(String instrText) {
        return INDEX_PATTERN.matcher(instrText).lookingAt();
    }

    private Optional<Function<List<DocumentElement>, Hyperlink>> parseHyperlinkFieldCode(String instrText) {
        Optional<Function<List<DocumentElement>, Hyperlink>> toRet = Optional.empty();
        Matcher matcher = HYPERLINK_PATTERN.matcher(instrText);
        if (matcher.lookingAt()) {
            String href = matcher.group(2);
            toRet = matcher.group(1).contains("\\l") ? Optional.of(children -> Hyperlink.anchor(href, Optional.empty(), children)) : Optional.of(children -> Hyperlink.href(href, Optional.empty(), children));
        } else {
            Matcher matcherHyperlinkRef = HYPERLINK_REF_PATTERN.matcher(instrText);
            if (matcherHyperlinkRef.lookingAt()) {
                toRet = Optional.of(children -> Hyperlink.anchor(matcherHyperlinkRef.group(1), Optional.empty(), children));
            }
        }
        return toRet;
    }

    private InternalResult<Optional<Style>> readParagraphStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:pStyle", "Paragraph", this.styles::findParagraphStyleById);
    }

    private InternalResult<Optional<Style>> readStyle(XmlElementLike properties, String styleTagName, String styleType, Function<String, Optional<Style>> findStyleById) {
        return this.readVal(properties, styleTagName).map(styleId -> this.findStyleById(styleType, (String)styleId, findStyleById)).orElse(InternalResult.empty());
    }

    private InternalResult<Optional<Style>> findStyleById(String styleType, String styleId, Function<String, Optional<Style>> findStyleById) {
        Optional<Style> style = findStyleById.apply(styleId);
        if (style.isPresent()) {
            return InternalResult.success(style);
        }
        return new InternalResult<Optional<Style>>(Optional.of(new Style(styleId, Optional.empty(), Optional.empty(), false)), Lists.list(styleType + " style with ID " + styleId + " was referenced but not defined in the document"));
    }

    private Optional<String> readNumberingID(XmlElementLike properties) {
        XmlElementLike numberingProperties = properties.findChildOrEmpty("w:numPr");
        return this.readVal(numberingProperties, "w:numId");
    }

    private Optional<NumberingLevel> readNumbering(Optional<Style> style, XmlElementLike properties) {
        String styleId;
        Optional<NumberingLevel> level;
        if (style.isPresent() && (level = this.numbering.findLevelByParagraphStyleId(styleId = style.get().getStyleId())).isPresent()) {
            return level;
        }
        XmlElementLike numberingProperties = properties.findChildOrEmpty("w:numPr");
        return Optionals.flatMap(this.readVal(numberingProperties, "w:numId"), this.readVal(numberingProperties, "w:ilvl"), this.numbering::findLevel);
    }

    private ParagraphIndent readParagraphIndent(XmlElementLike properties) {
        XmlElementLike indent = properties.findChildOrEmpty("w:ind");
        return new ParagraphIndent(Optionals.first(indent.getAttributeOrNone("w:start"), indent.getAttributeOrNone("w:left")), Optionals.first(indent.getAttributeOrNone("w:end"), indent.getAttributeOrNone("w:right")), indent.getAttributeOrNone("w:firstLine"), indent.getAttributeOrNone("w:hanging"));
    }

    private ReadResult readSymbol(XmlElement element) {
        Optional<String> font = element.getAttributeOrNone("w:font");
        Optional<String> charValue = element.getAttributeOrNone("w:char");
        if (font.isPresent() && charValue.isPresent()) {
            Optional<Integer> dingbat = Dingbats.findDingbat(font.get(), Integer.parseInt(charValue.get(), 16));
            if (!dingbat.isPresent() && Pattern.matches("F0..", charValue.get())) {
                dingbat = Dingbats.findDingbat(font.get(), Integer.parseInt(charValue.get().substring(2), 16));
            }
            if (dingbat.isPresent()) {
                return ReadResult.success(new Text(this.codepointToString(dingbat.get())));
            }
        }
        return ReadResult.emptyWithWarning("A w:sym element with an unsupported character was ignored: char " + charValue.orElse("null") + " in font " + font.orElse("null"));
    }

    public String codepointToString(int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            return String.valueOf((char)codePoint);
        }
        return String.valueOf(Character.highSurrogate(codePoint)) + Character.lowSurrogate(codePoint);
    }

    private ReadResult readBreak(XmlElement element) {
        String breakType;
        switch (breakType = element.getAttributeOrNone("w:type").orElse("textWrapping")) {
            case "textWrapping": {
                return ReadResult.success(Break.LINE_BREAK);
            }
            case "page": {
                return ReadResult.success(Break.PAGE_BREAK);
            }
            case "column": {
                return ReadResult.success(Break.COLUMN_BREAK);
            }
        }
        return ReadResult.emptyWithWarning("Unsupported break type: " + breakType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadResult readTable(XmlElement element) {
        ReadResult result;
        this.tableContexts.add(new TableContext());
        try {
            List<XmlElement> tableBookmarks = BookmarkUtil.getTableBookmarks(element);
            String[] tableId = new String[]{null};
            if (!tableBookmarks.isEmpty()) {
                for (XmlElement tableBookmark : tableBookmarks) {
                    Optional<String> bookmarkName = tableBookmark.getAttributeOrNone("w:name");
                    if (!bookmarkName.isPresent()) continue;
                    tableId[0] = bookmarkName.get();
                    this.tableContexts.peek().addProcessedBookmark(tableBookmark);
                    break;
                }
            }
            XmlElementLike properties = element.findChildOrEmpty("w:tblPr");
            List<XmlNode> children = element.getChildren();
            result = ReadResult.map(this.readTableStyle(properties), this.readTableChildren(children).flatMap(this::calculateRowspans), (style, tChildren) -> {
                Table table = new Table((Optional<Style>)style, (List<DocumentElement>)tChildren);
                table.setId(Optional.ofNullable(tableId[0]));
                return table;
            });
        }
        finally {
            this.tableContexts.pop();
        }
        return result;
    }

    private ReadResult readTableChildren(List<XmlNode> tableChildren) {
        ArrayList<ReadResult> results = new ArrayList<ReadResult>();
        XmlElement lastRow = null;
        ArrayList<XmlElement> bookmarksStartBeforeRow = new ArrayList<XmlElement>();
        int nuOfChilds = tableChildren.size();
        for (int i = 0; i < nuOfChilds; ++i) {
            XmlNode node = tableChildren.get(i);
            if (!(node instanceof XmlElement)) continue;
            XmlElement element = (XmlElement)node;
            String elementName = element.getName();
            if ("w:bookmarkStart".equals(elementName)) {
                bookmarksStartBeforeRow.add(element);
                continue;
            }
            if ("w:tr".equals(elementName)) {
                results.add(this.readTableRow(lastRow, bookmarksStartBeforeRow, element, i + 1 < nuOfChilds ? tableChildren.subList(i + 1, nuOfChilds) : Collections.emptyList()));
                bookmarksStartBeforeRow.clear();
                continue;
            }
            results.add(this.readElement(element));
        }
        return ReadResult.flatList(results);
    }

    private ReadResult readTableRow(XmlElement previewsRow, List<XmlElement> bookmarksStartBeforeRow, XmlElement currentRow, List<XmlNode> nextSiblings) {
        List<XmlElement> tableRowBookmarks = BookmarkUtil.getTableRowBookmarks(previewsRow, bookmarksStartBeforeRow, currentRow, nextSiblings);
        XmlElement rowIdBookmark = null;
        TableContext tableContext = this.tableContexts.peek();
        if (!tableRowBookmarks.isEmpty()) {
            for (XmlElement currentRowBookmark : tableRowBookmarks) {
                Optional<String> bookmarkName = currentRowBookmark.getAttributeOrNone("w:name");
                if (!bookmarkName.isPresent() || tableContext.isProcessedBookmark(currentRowBookmark)) continue;
                rowIdBookmark = currentRowBookmark;
                tableContext.addProcessedBookmark(currentRowBookmark);
                break;
            }
        }
        tableContext.addUnhandledBookmarks(BookmarkUtil.getUnprocessedBookmarks(bookmarksStartBeforeRow, rowIdBookmark));
        return this.readTableRow(currentRow, rowIdBookmark != null ? rowIdBookmark.getAttributeOrNone("w:name") : Optional.empty());
    }

    private ReadResult readTableGrid(XmlElement element) {
        return ReadResult.success(new TableGrid(this.readGridCols(element)));
    }

    private List<DocumentElement> readGridCols(XmlElement tableGrid) {
        ArrayList<DocumentElement> toRet = new ArrayList<DocumentElement>();
        for (XmlNode xmlNode : tableGrid.getChildren()) {
            XmlElement element;
            if (!(xmlNode instanceof XmlElement) || !"w:gridCol".equals((element = (XmlElement)xmlNode).getName())) continue;
            toRet.add(new TableGridCol(element.getAttributeOrNone("w:w")));
        }
        return toRet;
    }

    private InternalResult<Optional<Style>> readTableStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:tblStyle", "Table", this.styles::findTableStyleById);
    }

    private ReadResult calculateRowspans(List<DocumentElement> rows) {
        Optional<String> error = this.checkTableRows(rows);
        if (error.isPresent()) {
            return ReadResult.withWarning(rows, error.get());
        }
        HashMap<Map.Entry<Integer, Integer>, Integer> rowspans = new HashMap<Map.Entry<Integer, Integer>, Integer>();
        HashSet<Map.Entry<Integer, Integer>> merged = new HashSet<Map.Entry<Integer, Integer>>();
        HashMap<Integer, Map.Entry<Integer, Integer>> lastCellForColumn = new HashMap<Integer, Map.Entry<Integer, Integer>>();
        for (int rowIndex2 = 0; rowIndex2 < rows.size(); ++rowIndex2) {
            DocumentElement documentElement = rows.get(rowIndex2);
            if (!(documentElement instanceof TableRow)) continue;
            TableRow row = (TableRow)documentElement;
            int columnIndex = 0;
            for (int cellIndex = 0; cellIndex < row.getChildren().size(); ++cellIndex) {
                UnmergedTableCell cell = (UnmergedTableCell)row.getChildren().get(cellIndex);
                Optional spanningCell = Maps.lookup(lastCellForColumn, columnIndex);
                Map.Entry<Integer, Integer> position = Maps.entry(rowIndex2, cellIndex);
                if (cell.vmerge && spanningCell.isPresent()) {
                    rowspans.put((Map.Entry)spanningCell.get(), (Integer)Maps.lookup(rowspans, (Map.Entry)spanningCell.get()).get() + 1);
                    merged.add(position);
                } else {
                    lastCellForColumn.put(columnIndex, position);
                    rowspans.put(position, 1);
                }
                columnIndex += cell.colspan;
            }
        }
        return ReadResult.success(Lists.eagerMapWithIndex(rows, (rowIndex, rowElement) -> {
            if (rowElement instanceof TableRow) {
                TableRow row = (TableRow)rowElement;
                ArrayList<DocumentElement> mergedCells = new ArrayList<DocumentElement>();
                for (int cellIndex = 0; cellIndex < row.getChildren().size(); ++cellIndex) {
                    UnmergedTableCell cell = (UnmergedTableCell)row.getChildren().get(cellIndex);
                    Map.Entry<Integer, Integer> position = Maps.entry(rowIndex, cellIndex);
                    if (merged.contains(position)) continue;
                    mergedCells.add(new TableCell((Integer)Maps.lookup(rowspans, position).get(), cell.colspan, cell.children));
                }
                return new TableRow(mergedCells, row.isHeader(), row.getId());
            }
            return rowElement;
        }));
    }

    private Optional<String> checkTableRows(List<DocumentElement> rows) {
        for (DocumentElement rowElement : rows) {
            Optional<TableRow> row = Casts.tryCast(TableRow.class, rowElement);
            if (!row.isPresent()) {
                if (rowElement instanceof SEQCaption || rowElement instanceof TableGrid) continue;
                return Optional.of("unexpected non-row element in table, cell merging may be incorrect");
            }
            for (DocumentElement cell : row.get().getChildren()) {
                if (cell instanceof UnmergedTableCell) continue;
                return Optional.of("unexpected non-cell element in table row, cell merging may be incorrect");
            }
        }
        return Optional.empty();
    }

    private ReadResult readTableRow(XmlElement element, Optional<String> id) {
        Optional<XmlElement> formatingStyle;
        XmlElementLike properties = element.findChildOrEmpty("w:trPr");
        Boolean[] isHeader = new Boolean[]{properties.hasChild("w:tblHeader")};
        if (!isHeader[0].booleanValue() && (formatingStyle = properties.findChild("w:cnfStyle")).isPresent()) {
            Optional<String> firstRow = formatingStyle.get().getAttributeOrNone("w:firstRow");
            isHeader[0] = firstRow.isPresent() && ("true".equals(firstRow.get()) || "1".equals(firstRow.get()));
        }
        return this.readElements(element.getChildren()).map(children -> new TableRow((List<DocumentElement>)children, isHeader[0], id));
    }

    private ReadResult readTableCell(XmlElement element) {
        List<XmlElement> bookmarksBetweenTableCells;
        if (!this.tableContexts.isEmpty()) {
            this.tableContexts.peek().setTableCellContext(true);
        }
        XmlElementLike properties = element.findChildOrEmpty("w:tcPr");
        Optional<String> gridSpan = properties.findChildOrEmpty("w:gridSpan").getAttributeOrNone("w:val");
        int colspan = gridSpan.map(Integer::parseInt).orElse(1);
        List<XmlNode> childrenNodes = element.getChildren();
        if (!this.tableContexts.isEmpty() && !(bookmarksBetweenTableCells = this.tableContexts.peek().getUnhandledBookmarks()).isEmpty()) {
            childrenNodes.addAll(0, bookmarksBetweenTableCells);
            this.tableContexts.peek().clearUnhandledBookmarks();
        }
        ReadResult result = this.readElements(childrenNodes).map(children -> new UnmergedTableCell(this.readVmerge(properties), colspan, (List<DocumentElement>)children));
        if (!this.tableContexts.isEmpty()) {
            this.tableContexts.peek().setTableCellContext(false);
        }
        return result;
    }

    private boolean readVmerge(XmlElementLike properties) {
        return properties.findChild("w:vMerge").map(element -> element.getAttributeOrNone("w:val").map(val -> val.equals("continue")).orElse(true)).orElse(false);
    }

    private ReadResult readHyperlink(XmlElement element) {
        Optional<String> relationshipId = element.getAttributeOrNone("r:id");
        Optional<String> anchor = element.getAttributeOrNone("w:anchor");
        Optional<String> targetFrame = element.getAttributeOrNone("w:tgtFrame").filter(value -> !value.isEmpty());
        ReadResult childrenResult = this.readElements(element.getChildren());
        if (relationshipId.isPresent()) {
            String targetHref = this.relationships.findTargetByRelationshipId(relationshipId.get());
            String href = anchor.map(fragment -> Uris.replaceFragment(targetHref, (String)anchor.get())).orElse(targetHref);
            return childrenResult.map(children -> Hyperlink.href(href, targetFrame, children));
        }
        if (anchor.isPresent()) {
            return childrenResult.map(children -> Hyperlink.anchor((String)anchor.get(), targetFrame, children));
        }
        return childrenResult;
    }

    private ReadResult readBookmark(XmlElement element) {
        String name = element.getAttribute("w:name");
        if (name.equals("_GoBack")) {
            return ReadResult.EMPTY_SUCCESS;
        }
        return ReadResult.success(new Bookmark(name));
    }

    private ReadResult readNoteReference(NoteType noteType, XmlElement element) {
        String noteId = element.getAttribute("w:id");
        return ReadResult.success(new NoteReference(noteType, noteId));
    }

    private ReadResult readCommentReference(XmlElement element) {
        String commentId = element.getAttribute("w:id");
        return ReadResult.success(new CommentReference(commentId));
    }

    private ReadResult readPict(XmlElement element) {
        return this.readElements(element.getChildren()).toExtra();
    }

    private ReadResult readImagedata(XmlElement element) {
        return element.getAttributeOrNone("r:id").map(relationshipId -> {
            Optional<String> title = element.getAttributeOrNone("o:title");
            String imagePath = this.relationshipIdToDocxPath((String)relationshipId);
            return this.readImage(imagePath, title, () -> Archives.getInputStream(this.file, imagePath));
        }).orElse(ReadResult.emptyWithWarning("A v:imagedata element without a relationship ID was ignored"));
    }

    private ReadResult readInline(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("wp:docPr");
        Optional<String> altText = Optionals.first(properties.getAttributeOrNone("descr").filter(description -> !description.trim().isEmpty()), properties.getAttributeOrNone("title"));
        XmlElementList blips = element.findChildren("a:graphic").findChildren("a:graphicData").findChildren("pic:pic").findChildren("pic:blipFill").findChildren("a:blip");
        return this.readBlips(blips, altText);
    }

    private ReadResult readBlips(XmlElementList blips, Optional<String> altText) {
        return ReadResult.flatMap(blips, blip -> this.readBlip((XmlElement)blip, altText));
    }

    private ReadResult readBlip(XmlElement blip, Optional<String> altText) {
        ReadResult toRet = null;
        XmlElement svgBlip = XmlElementUtil.findChildRecursively(blip, "asvg:svgBlip");
        if (svgBlip != null) {
            toRet = this.readBlipInternal(svgBlip, altText);
        }
        if (toRet == null || ReadResult.EMPTY_SUCCESS.equals(toRet)) {
            toRet = this.readBlipInternal(blip, altText);
        }
        return toRet;
    }

    private ReadResult readBlipInternal(XmlElement blip, Optional<String> altText) {
        Optional<String> embedRelationshipId = blip.getAttributeOrNone("r:embed");
        Optional<String> linkRelationshipId = blip.getAttributeOrNone("r:link");
        if (embedRelationshipId.isPresent()) {
            String imagePath = this.relationshipIdToDocxPath(embedRelationshipId.get());
            return this.readImage(imagePath, altText, () -> Archives.getInputStream(this.file, imagePath));
        }
        if (linkRelationshipId.isPresent()) {
            String imagePath = this.relationships.findTargetByRelationshipId(linkRelationshipId.get());
            return this.readImage(imagePath, altText, () -> this.fileReader.getInputStream(imagePath));
        }
        return ReadResult.emptyWithWarning("Could not find image file for a:blip element");
    }

    private ReadResult readImage(String imagePath, Optional<String> altText, InputStreamSupplier open) {
        Optional<String> contentType = this.contentTypes.findContentType(imagePath);
        Image image = new Image(altText, imagePath, contentType, open);
        String contentTypeString = contentType.orElse("(unknown)");
        if (IMAGE_TYPES_SUPPORTED_BY_BROWSERS.contains(contentTypeString)) {
            return ReadResult.success(image);
        }
        return ReadResult.withWarning(image, "Image of type " + contentTypeString + " is unlikely to display in web browsers");
    }

    private ReadResult readSdt(XmlElement element) {
        return this.readElements(element.findChildOrEmpty("w:sdtContent").getChildren());
    }

    private String relationshipIdToDocxPath(String relationshipId) {
        String target = this.relationships.findTargetByRelationshipId(relationshipId);
        return Uris.uriToZipEntryName("word", target);
    }

    private Optional<String> readVal(XmlElementLike element, String name) {
        return element.findChildOrEmpty(name).getAttributeOrNone("w:val");
    }

    private static interface ComplexField {
        public static final ComplexField UNKNOWN = new ComplexField(){};
        public static final ComplexField INDEX = new ComplexField(){};

        public static ComplexField hyperlink(Function<List<DocumentElement>, Hyperlink> childrenToHyperlink) {
            return new HyperlinkComplexField(childrenToHyperlink);
        }
    }

    private static class HyperlinkComplexField
    implements ComplexField {
        private final Function<List<DocumentElement>, Hyperlink> childrenToHyperlink;

        private HyperlinkComplexField(Function<List<DocumentElement>, Hyperlink> childrenToHyperlink) {
            this.childrenToHyperlink = childrenToHyperlink;
        }
    }

    private static class UnmergedTableCell
    implements DocumentElement {
        private final boolean vmerge;
        private final int colspan;
        private final List<DocumentElement> children;

        private UnmergedTableCell(boolean vmerge, int colspan, List<DocumentElement> children) {
            this.vmerge = vmerge;
            this.colspan = colspan;
            this.children = children;
        }

        @Override
        public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
            return visitor.visit(new TableCell(1, this.colspan, this.children), context);
        }
    }
}

