/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;

public class ReadResult {
    public static final ReadResult EMPTY_SUCCESS = ReadResult.success(Lists.list());
    private final List<DocumentElement> elements;
    private final List<DocumentElement> extra;
    private final Iterable<String> warnings;

    public static <T> ReadResult flatMap(Iterable<T> iterable, Function<T, ReadResult> function) {
        List<ReadResult> results = Lists.eagerMap(iterable, function);
        return ReadResult.flatList(results);
    }

    public static ReadResult flatList(List<ReadResult> results) {
        return new ReadResult(Lists.eagerFlatMap(results, result -> result.elements), Lists.eagerFlatMap(results, result -> result.extra), Iterables.lazyFlatMap(results, result -> result.warnings));
    }

    public static <T> ReadResult map(InternalResult<T> first, ReadResult second, BiFunction<T, List<DocumentElement>, DocumentElement> function) {
        return new ReadResult(Lists.list(function.apply(first.getValue(), second.elements)), second.extra, Iterables.lazyConcat(first.getWarnings(), second.warnings));
    }

    public static ReadResult success(DocumentElement element) {
        return ReadResult.success(Lists.list(element));
    }

    public static ReadResult success(List<DocumentElement> elements) {
        return new ReadResult(elements, Lists.list(), Lists.list());
    }

    public static ReadResult emptyWithWarning(String warning) {
        return ReadResult.withWarning(Lists.list(), warning);
    }

    public static ReadResult withWarning(DocumentElement element, String warning) {
        return ReadResult.withWarning(Lists.list(element), warning);
    }

    public static ReadResult withWarning(List<DocumentElement> elements, String warning) {
        return new ReadResult(elements, Lists.list(), Lists.list(warning));
    }

    public ReadResult(List<DocumentElement> elements, List<DocumentElement> extra, Iterable<String> warnings) {
        this.elements = elements;
        this.extra = extra;
        this.warnings = warnings;
    }

    public ReadResult map(Function<List<DocumentElement>, DocumentElement> function) {
        return new ReadResult(Lists.list(function.apply(this.elements)), this.extra, this.warnings);
    }

    public ReadResult flatMap(Function<List<DocumentElement>, ReadResult> function) {
        ReadResult result = function.apply(this.elements);
        return new ReadResult(result.elements, Lists.eagerConcat(this.extra, result.extra), Iterables.lazyConcat(this.warnings, result.warnings));
    }

    public ReadResult toExtra() {
        return new ReadResult(Lists.list(), Lists.eagerConcat(this.extra, this.elements), this.warnings);
    }

    public ReadResult appendExtra() {
        return new ReadResult(Lists.eagerConcat(this.elements, this.extra), Lists.list(), this.warnings);
    }

    public InternalResult<List<DocumentElement>> toResult() {
        return new InternalResult<List<DocumentElement>>(this.elements, this.warnings);
    }

    public List<DocumentElement> getElements() {
        return this.elements;
    }
}

