/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.io.InputStream;
import java.util.List;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.xml.NamespacePrefixes;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlNode;
import org.zwobble.mammoth.internal.xml.XmlNodeVisitor;
import org.zwobble.mammoth.internal.xml.XmlTextNode;
import org.zwobble.mammoth.internal.xml.parsing.XmlParser;

public class OfficeXml {
    static final NamespacePrefixes XML_NAMESPACES = NamespacePrefixes.builder().put("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main").put("wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing").put("a", "http://schemas.openxmlformats.org/drawingml/2006/main").put("pic", "http://schemas.openxmlformats.org/drawingml/2006/picture").put("content-types", "http://schemas.openxmlformats.org/package/2006/content-types").put("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships").put("relationships", "http://schemas.openxmlformats.org/package/2006/relationships").put("v", "urn:schemas-microsoft-com:vml").put("mc", "http://schemas.openxmlformats.org/markup-compatibility/2006").put("office-word", "urn:schemas-microsoft-com:office:word").put("m", "http://schemas.openxmlformats.org/officeDocument/2006/math").put("xml", "http://www.w3.org/XML/1998/namespace").put("asvg", "http://schemas.microsoft.com/office/drawing/2016/SVG/main").build();

    public static XmlElement parseXml(InputStream inputStream) {
        XmlParser parser = new XmlParser(XML_NAMESPACES);
        return (XmlElement)OfficeXml.collapseAlternateContent(parser.parseStream(inputStream)).get(0);
    }

    private static List<XmlNode> collapseAlternateContent(XmlNode node) {
        return node.accept(new XmlNodeVisitor<List<XmlNode>>(){

            @Override
            public List<XmlNode> visit(XmlElement element) {
                if (element.getName().equals("mc:AlternateContent")) {
                    return element.findChildOrEmpty("mc:Fallback").getChildren();
                }
                XmlElement collapsedElement = new XmlElement(element.getName(), element.getAttributes(), Lists.eagerFlatMap(element.getChildren(), x$0 -> OfficeXml.collapseAlternateContent(x$0)));
                return Lists.list(collapsedElement);
            }

            @Override
            public List<XmlNode> visit(XmlTextNode textNode) {
                return Lists.list(textNode);
            }
        });
    }
}

