/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.util.Maps;

public class Numbering {
    public static final Numbering EMPTY = new Numbering(Maps.map(), Maps.map(), Styles.EMPTY);
    private final Map<String, AbstractNum> abstractNums;
    private final Map<String, AbstractNumLevel> levelsByParagraphStyleId;
    private final Map<String, Num> nums;
    private final Styles styles;

    public Numbering(Map<String, AbstractNum> abstractNums, Map<String, Num> nums, Styles styles) {
        this.abstractNums = abstractNums;
        this.levelsByParagraphStyleId = abstractNums.values().stream().flatMap(abstractNum -> abstractNum.levels.values().stream()).filter(level -> level.paragraphStyleId.isPresent()).collect(Collectors.toMap(level -> level.paragraphStyleId.get(), level -> level, (x, y) -> x));
        this.nums = nums;
        this.styles = styles;
    }

    public Optional<NumberingLevel> findLevel(String numId, String level) {
        return Maps.lookup(this.nums, numId).flatMap(num -> num.abstractNumId).flatMap(abstractNumId -> Maps.lookup(this.abstractNums, abstractNumId)).flatMap(abstractNum -> {
            if (abstractNum.numStyleLink.isPresent()) {
                return abstractNum.numStyleLink.flatMap(numStyleLink -> this.styles.findNumberingStyleById((String)numStyleLink)).flatMap(style -> style.getNumId()).flatMap(linkedNumId -> this.findLevel((String)linkedNumId, level));
            }
            return Maps.lookup(abstractNum.levels, level).map(value -> value.toNumberingLevel());
        });
    }

    public Optional<NumberingLevel> findLevelByParagraphStyleId(String styleId) {
        return Maps.lookup(this.levelsByParagraphStyleId, styleId).map(value -> value.toNumberingLevel());
    }

    public static class AbstractNumLevel {
        private final String levelIndex;
        private final boolean isOrdered;
        private final Optional<String> paragraphStyleId;

        public static AbstractNumLevel ordered(String levelIndex) {
            return new AbstractNumLevel(levelIndex, true, Optional.empty());
        }

        public static AbstractNumLevel unordered(String levelIndex) {
            return new AbstractNumLevel(levelIndex, false, Optional.empty());
        }

        public AbstractNumLevel(String levelIndex, boolean isOrdered, Optional<String> paragraphStyleId) {
            this.levelIndex = levelIndex;
            this.isOrdered = isOrdered;
            this.paragraphStyleId = paragraphStyleId;
        }

        public NumberingLevel toNumberingLevel() {
            return new NumberingLevel(this.levelIndex, this.isOrdered);
        }
    }

    public static class AbstractNum {
        private final Map<String, AbstractNumLevel> levels;
        private final Optional<String> numStyleLink;

        public AbstractNum(Map<String, AbstractNumLevel> levels, Optional<String> numStyleLink) {
            this.levels = levels;
            this.numStyleLink = numStyleLink;
        }
    }

    public static class Num {
        private final Optional<String> abstractNumId;

        public Num(Optional<String> abstractNumId) {
            this.abstractNumId = abstractNumId;
        }
    }
}

