/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.TableGridCol;

public class TableGrid
implements DocumentElement,
HasChildren {
    private final List<DocumentElement> children;

    public TableGrid(List<DocumentElement> children) {
        this.children = this.computeColsWithAutoWidth(children);
    }

    private List<DocumentElement> computeColsWithAutoWidth(List<DocumentElement> cols) {
        int nuOfCols = cols.size();
        int totalWidth = 0;
        for (DocumentElement documentElement : cols) {
            Optional<String> colWidth = ((TableGridCol)documentElement).getWidth();
            if (!colWidth.isPresent()) continue;
            totalWidth += Integer.valueOf(colWidth.get()).intValue();
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(1);
        int avgSize = Math.round((float)totalWidth / (float)nuOfCols);
        for (DocumentElement documentElement : cols) {
            TableGridCol gridCol = (TableGridCol)documentElement;
            Optional<String> colWidth = gridCol.getWidth();
            Integer width = Integer.valueOf(colWidth.get());
            if (width > 0) {
                float ratio = (float)width.intValue() / (float)avgSize;
                gridCol.setComputedAutoWidthVal(decimalFormat.format(ratio) + "*");
                continue;
            }
            gridCol.setComputedAutoWidthVal("1*");
        }
        return cols;
    }

    @Override
    public List<DocumentElement> getChildren() {
        return this.children;
    }

    @Override
    public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
        return visitor.visit(this, context);
    }
}

