/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.conversion;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.zwobble.mammoth.internal.conversion.DocumentToHtmlOptions;
import org.zwobble.mammoth.internal.conversion.InternalImageConverter;
import org.zwobble.mammoth.internal.conversion.UnknownStylesReporter;
import org.zwobble.mammoth.internal.documents.Bookmark;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.CommentReference;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.Figure;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.Hyperlink;
import org.zwobble.mammoth.internal.documents.Image;
import org.zwobble.mammoth.internal.documents.IndexTerm;
import org.zwobble.mammoth.internal.documents.Math;
import org.zwobble.mammoth.internal.documents.Note;
import org.zwobble.mammoth.internal.documents.NoteReference;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.SEQCaption;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.documents.Tab;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.documents.TableCell;
import org.zwobble.mammoth.internal.documents.TableGrid;
import org.zwobble.mammoth.internal.documents.TableGridCol;
import org.zwobble.mammoth.internal.documents.TableRow;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.documents.VerticalAlignment;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.html.Html;
import org.zwobble.mammoth.internal.html.HtmlCommentElement;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.HtmlPathElement;
import org.zwobble.mammoth.internal.styles.HtmlPathElements;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;

public class DocumentToHtml {
    private final String idPrefix;
    private final boolean preserveEmptyParagraphs;
    private final boolean shouldConvertNotesIntoAList;
    private UnknownStylesReporter unknownStylesReporter = null;
    private Optional<Path> documentPath = Optional.empty();
    private Styles styles;
    private final StyleMap styleMap;
    private final InternalImageConverter imageConverter;
    private final Map<String, Comment> comments;
    private final List<NoteReference> noteReferences = new ArrayList<NoteReference>();
    private final List<ReferencedComment> referencedComments = new ArrayList<ReferencedComment>();
    private final Set<String> warnings = new HashSet<String>();
    private static final Context INITIAL_CONTEXT = new Context(false);
    ElementConverterVisitor converterVisitor = new ElementConverterVisitor();

    public static InternalResult<List<HtmlNode>> convertToHtml(Document document, DocumentToHtmlOptions options) {
        return DocumentToHtml.convertToHtml(document, options, Styles.EMPTY);
    }

    public static InternalResult<List<HtmlNode>> convertToHtml(Document document, DocumentToHtmlOptions options, Styles styles) {
        DocumentToHtml documentConverter = new DocumentToHtml(document.getDocumentPath(), styles, options, document.getComments());
        return new InternalResult<List<HtmlNode>>(documentConverter.convertToHtml(document, INITIAL_CONTEXT), documentConverter.warnings);
    }

    private static List<Note> findNotes(Document document, Iterable<NoteReference> noteReferences) {
        return Lists.eagerMap(noteReferences, reference -> document.getNotes().findNote(reference.getNoteType(), reference.getNoteId()).get());
    }

    public static InternalResult<List<HtmlNode>> convertToHtml(DocumentElement element, DocumentToHtmlOptions options) {
        return DocumentToHtml.convertToHtml(element, options, Styles.EMPTY);
    }

    public static InternalResult<List<HtmlNode>> convertToHtml(DocumentElement element, DocumentToHtmlOptions options, Styles styles) {
        DocumentToHtml documentConverter = new DocumentToHtml(Optional.empty(), styles, options, Lists.list());
        return new InternalResult<List<HtmlNode>>(documentConverter.convertToHtml(element, INITIAL_CONTEXT), documentConverter.warnings);
    }

    private DocumentToHtml(Optional<Path> documentPath, Styles styles, DocumentToHtmlOptions options, List<Comment> comments) {
        this.styles = styles;
        this.idPrefix = options.idPrefix();
        this.preserveEmptyParagraphs = options.shouldPreserveEmptyParagraphs();
        this.styleMap = options.styleMap();
        this.unknownStylesReporter = options.getUnknownStylesReporter();
        this.imageConverter = options.imageConverter();
        this.comments = Maps.toMapWithKey(comments, Comment::getCommentId);
        this.shouldConvertNotesIntoAList = options.shouldConvertNotesToList();
        this.documentPath = documentPath;
    }

    private List<HtmlNode> convertToHtml(Document document, Context context) {
        List<HtmlNode> mainBody = this.convertChildrenToHtml(document, context);
        List<Note> notes = DocumentToHtml.findNotes(document, this.noteReferences);
        List<Object> noteNodes = Lists.list();
        if (!notes.isEmpty()) {
            noteNodes = this.shouldConvertNotesIntoAList ? Lists.list(Html.element("ol", Lists.eagerMap(notes, note -> this.convertToHtml((Note)note, context)))) : Lists.eagerMap(notes, note -> {
                NoteType noteType = note.getNoteType();
                String id = this.generateNoteHtmlId(noteType, note.getId());
                String referenceId = this.generateNoteRefHtmlId(note.getNoteType(), note.getId());
                ArrayList<HtmlNode> children = new ArrayList<HtmlNode>();
                List<DocumentElement> noteBody = note.getBody();
                if (!noteBody.isEmpty() && noteBody.get(0) instanceof Paragraph) {
                    children.addAll(this.convertChildrenToHtml((Paragraph)noteBody.get(0), context));
                    children.addAll(this.convertToHtml(noteBody.subList(1, noteBody.size()), context));
                } else {
                    children.addAll(this.convertToHtml(noteBody, context));
                }
                children.add(Html.element("a", Maps.map("href", "#" + referenceId, "id", id), Lists.list(Html.text("\u2191"))));
                return Html.element("p", Maps.map("class", noteType == NoteType.ENDNOTE ? "MsoEndnoteText" : "MsoFootnoteText"), children);
            });
        }
        List commentNodes = this.referencedComments.isEmpty() ? Lists.list() : Lists.list(Html.element("dl", Lists.eagerFlatMap(this.referencedComments, comment -> this.convertToHtml((ReferencedComment)comment, context))));
        return Lists.eagerConcat(mainBody, noteNodes, commentNodes);
    }

    private HtmlNode convertToHtml(Note note, Context context) {
        String id = this.generateNoteHtmlId(note.getNoteType(), note.getId());
        String referenceId = this.generateNoteRefHtmlId(note.getNoteType(), note.getId());
        List<HtmlNode> noteBody = this.convertToHtml(note.getBody(), context);
        HtmlNode backLink = Html.collapsibleElement("p", Lists.list(Html.text(" "), Html.element("a", Maps.map("href", "#" + referenceId), Lists.list(Html.text("\u2191")))));
        return Html.element("li", Maps.map("id", id), Lists.eagerConcat(noteBody, Lists.list(backLink)));
    }

    private List<HtmlNode> convertToHtml(ReferencedComment referencedComment, Context context) {
        String commentId = referencedComment.comment.getCommentId();
        List<HtmlNode> body = this.convertToHtml(referencedComment.comment.getBody(), context);
        HtmlNode backLink = Html.collapsibleElement("p", Lists.list(Html.text(" "), Html.element("a", Maps.map("href", "#" + this.generateReferenceHtmlId("comment", commentId)), Lists.list(Html.text("\u2191")))));
        return Lists.list(Html.element("dt", Maps.map("id", this.generateReferentHtmlId("comment", commentId)), Lists.list(Html.text("Comment " + referencedComment.label))), Html.element("dd", Lists.eagerConcat(body, Lists.list(backLink))));
    }

    private List<HtmlNode> convertToHtml(List<DocumentElement> elements, Context context) {
        elements = this.correctOrderedListHierarchy(elements);
        elements = this.correctCaptionHierarchy(elements);
        return Lists.eagerFlatMap(elements, element -> this.convertToHtml((DocumentElement)element, context));
    }

    private List<DocumentElement> correctOrderedListHierarchy(List<DocumentElement> elements) {
        int nuOfElements = elements.size();
        ArrayList<DocumentElement> toRet = new ArrayList<DocumentElement>(nuOfElements);
        Paragraph lastNumberingElement = null;
        ArrayList<DocumentElement> elementsAfterLastNumbering = new ArrayList<DocumentElement>();
        for (int i = 0; i < nuOfElements; ++i) {
            Paragraph paragraph;
            DocumentElement currentElement = elements.get(i);
            String currentNumberingId = null;
            if (currentElement instanceof Paragraph && (paragraph = (Paragraph)currentElement).getNumbering().isPresent() && paragraph.getNumbering().get().isOrdered() && this.isListItemPara(paragraph)) {
                if (paragraph.getNumberingID().isPresent()) {
                    currentNumberingId = paragraph.getNumberingID().get();
                } else if (paragraph.getStyle().isPresent()) {
                    currentNumberingId = paragraph.getStyle().get().getStyleId();
                }
            }
            if (lastNumberingElement == null && currentNumberingId != null) {
                lastNumberingElement = (Paragraph)currentElement;
                continue;
            }
            if (lastNumberingElement != null) {
                if (currentNumberingId != null) {
                    if (lastNumberingElement.getNumberingID().isPresent() && currentNumberingId.equals(lastNumberingElement.getNumberingID().get()) || lastNumberingElement.getStyle().isPresent() && currentNumberingId.equals(lastNumberingElement.getStyle().get().getStyleId())) {
                        if (!elementsAfterLastNumbering.isEmpty()) {
                            lastNumberingElement.getChildren().addAll(elementsAfterLastNumbering);
                            elementsAfterLastNumbering.clear();
                        }
                        toRet.add(lastNumberingElement);
                    } else {
                        toRet.add(lastNumberingElement);
                        toRet.addAll(elementsAfterLastNumbering);
                        elementsAfterLastNumbering.clear();
                    }
                    lastNumberingElement = (Paragraph)currentElement;
                    continue;
                }
                elementsAfterLastNumbering.add(currentElement);
                continue;
            }
            toRet.add(currentElement);
        }
        if (lastNumberingElement != null) {
            toRet.add(lastNumberingElement);
        }
        if (!elementsAfterLastNumbering.isEmpty()) {
            toRet.addAll(elementsAfterLastNumbering);
        }
        return toRet;
    }

    private boolean isListItemPara(Paragraph para) {
        List<HtmlPathElement> elements;
        int nuOfElemets;
        boolean isListPara = false;
        Optional<HtmlPath> paragraphHtmlPath = this.styleMap.getParagraphHtmlPath(para);
        if (paragraphHtmlPath.isPresent() && paragraphHtmlPath.get() instanceof HtmlPathElements && (nuOfElemets = (elements = ((HtmlPathElements)paragraphHtmlPath.get()).getElements()).size()) > 0) {
            for (int i = nuOfElemets - 1; i >= 0; --i) {
                HtmlPathElement htmlPathElement = elements.get(i);
                if (!htmlPathElement.getTag().getTagNames().contains("li")) continue;
                isListPara = true;
                break;
            }
        }
        return isListPara;
    }

    private List<DocumentElement> correctCaptionHierarchy(List<DocumentElement> elements) {
        int nuOfElements = elements.size();
        ArrayList<DocumentElement> toRet = new ArrayList<DocumentElement>(nuOfElements);
        if (nuOfElements > 0) {
            Object lastElement = null;
            DocumentElement currentElement = elements.get(0);
            DocumentElement nextElement = null;
            DocumentElement lastMovedCaption = null;
            for (int i = 0; i < nuOfElements; ++i) {
                nextElement = i + 1 < nuOfElements ? elements.get(i + 1) : null;
                if (currentElement instanceof Table) {
                    if (lastElement instanceof SEQCaption && !lastElement.equals(lastMovedCaption) && ((SEQCaption)lastElement).isCaptionForTable()) {
                        toRet.remove(toRet.size() - 1);
                        ((SEQCaption)lastElement).setPlacedInsideTarget(true);
                        ((Table)currentElement).getChildren().add(0, (DocumentElement)lastElement);
                    } else if (nextElement instanceof SEQCaption && ((SEQCaption)nextElement).isCaptionForTable()) {
                        lastMovedCaption = nextElement;
                        ((SEQCaption)nextElement).setPlacedInsideTarget(true);
                        ((Table)currentElement).getChildren().add(0, nextElement);
                    }
                } else if (this.isFigureCaptionForReorder(currentElement)) {
                    Figure figure;
                    boolean imageWasFound = false;
                    if (lastElement instanceof Paragraph && (figure = this.convertToFigure((Paragraph)lastElement, currentElement)) != null) {
                        imageWasFound = true;
                        toRet.remove(toRet.size() - 1);
                        toRet.add(figure);
                        lastMovedCaption = currentElement;
                        ((SEQCaption)currentElement).setPlacedInsideTarget(true);
                    }
                    if (!imageWasFound && nextElement instanceof Paragraph && (figure = this.convertToFigure((Paragraph)nextElement, currentElement)) != null) {
                        nextElement = figure;
                        ((SEQCaption)currentElement).setPlacedInsideTarget(true);
                        lastMovedCaption = currentElement;
                    }
                }
                this.collectElementWhenProcessingCaptions(toRet, currentElement, lastMovedCaption);
                lastElement = currentElement;
                currentElement = nextElement;
            }
        }
        return toRet;
    }

    private Figure convertToFigure(Paragraph para, DocumentElement caption) {
        List<DocumentElement> children = para.getChildren();
        boolean isAnImagePara = false;
        int nuOfChildren = children.size();
        for (int i = 0; i < nuOfChildren; ++i) {
            DocumentElement currentChild = children.get(i);
            if (!(currentChild instanceof Run)) continue;
            Run run = (Run)currentChild;
            for (DocumentElement runChild : run.getChildren()) {
                if (!(runChild instanceof Image)) continue;
                isAnImagePara = true;
                break;
            }
            if (!isAnImagePara) continue;
            ((SEQCaption)caption).setPlacedInsideTarget(true);
            children.add(i + 1, caption);
            break;
        }
        return isAnImagePara ? new Figure(children) : null;
    }

    private boolean isFigureCaptionForReorder(DocumentElement element) {
        boolean toRet = false;
        if (element instanceof SEQCaption) {
            SEQCaption caption = (SEQCaption)element;
            toRet = caption.isCaptionForFigure() && !caption.wasPlacedInsideTarget();
        }
        return toRet;
    }

    private void collectElementWhenProcessingCaptions(List<DocumentElement> collector, DocumentElement element, DocumentElement lastMovedTableCaption) {
        if (element != null && !element.equals(lastMovedTableCaption)) {
            if (element instanceof SEQCaption && !((SEQCaption)element).wasPlacedInsideTarget()) {
                collector.add(((SEQCaption)element).getWrappedPara());
            } else {
                collector.add(element);
            }
        }
    }

    private List<HtmlNode> convertChildrenToHtml(HasChildren element, Context context) {
        return this.convertToHtml(element.getChildren(), context);
    }

    private List<HtmlNode> convertToHtml(DocumentElement element, Context context) {
        return element.accept(this.converterVisitor, context);
    }

    private String generateNoteHtmlId(NoteType noteType, String noteId) {
        return this.generateReferentHtmlId(this.noteTypeToIdFragment(noteType), noteId);
    }

    private String generateNoteRefHtmlId(NoteType noteType, String noteId) {
        return this.generateReferenceHtmlId(this.noteTypeToIdFragment(noteType), noteId);
    }

    private String generateReferentHtmlId(String referenceType, String referenceId) {
        return this.generateId(referenceType + "-" + referenceId);
    }

    private String generateReferenceHtmlId(String referenceType, String referenceId) {
        return this.generateId(referenceType + "-ref-" + referenceId);
    }

    private String noteTypeToIdFragment(NoteType noteType) {
        switch (noteType) {
            case FOOTNOTE: {
                return "footnote";
            }
            case ENDNOTE: {
                return "endnote";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String generateId(String bookmarkName) {
        return this.idPrefix + bookmarkName;
    }

    private static class Context {
        private final boolean isHeader;

        Context(boolean isHeader) {
            this.isHeader = isHeader;
        }

        Context isHeader(boolean isHeader) {
            return new Context(isHeader);
        }
    }

    private class ElementConverterVisitor
    implements DocumentElementVisitor<List<HtmlNode>, Context> {
        private Optional<Paragraph> previousParagraph = Optional.empty();

        private ElementConverterVisitor() {
        }

        @Override
        public List<HtmlNode> visit(Paragraph paragraph, Context context) {
            Supplier<List<HtmlNode>> children = () -> {
                List<HtmlNode> content = DocumentToHtml.this.convertChildrenToHtml(paragraph, context);
                return DocumentToHtml.this.preserveEmptyParagraphs ? Lists.cons(Html.FORCE_WRITE, content) : content;
            };
            if (this.previousParagraph.isPresent() && this.previousParagraph.get().getNumbering().isPresent() && paragraph.getNumbering().isPresent() && this.previousParagraph.get().getNumbering().isPresent() && paragraph.getNumbering().isPresent() && !this.previousParagraph.get().getNumberingID().equals(paragraph.getNumberingID())) {
                paragraph.getNumbering().get().setFirstItemNumbering();
            }
            HtmlPath mapping = DocumentToHtml.this.styleMap.getParagraphHtmlPath(paragraph).orElseGet(() -> {
                HtmlPath toRet = HtmlPath.element("p");
                if (paragraph.getStyle().isPresent()) {
                    Optional<Style> parentStyle;
                    Optional<String> parentStyleId;
                    Style style;
                    Style originalStyle = style = paragraph.getStyle().get();
                    Optional<Object> parentMapping = Optional.empty();
                    while (style.isCustom() && !parentMapping.isPresent() && (parentStyleId = style.getParentStyleId()).isPresent() && (parentStyle = DocumentToHtml.this.styles.findParagraphStyleById(parentStyleId.get())).isPresent()) {
                        style = parentStyle.get();
                        paragraph.changeStyle(parentStyle);
                        parentMapping = DocumentToHtml.this.styleMap.getParagraphHtmlPath(paragraph);
                    }
                    if (!parentMapping.isPresent()) {
                        if (DocumentToHtml.this.unknownStylesReporter != null) {
                            DocumentToHtml.this.unknownStylesReporter.reportUnknownStyle("p", originalStyle, DocumentToHtml.this.documentPath);
                        } else {
                            DocumentToHtml.this.warnings.add("Unrecognised paragraph style: " + originalStyle.describe());
                        }
                    } else {
                        toRet = (HtmlPath)parentMapping.get();
                    }
                }
                return toRet;
            });
            this.previousParagraph = Optional.of(paragraph);
            return mapping.wrap(children).get();
        }

        @Override
        public List<HtmlNode> visit(Run run, Context context) {
            Supplier<List<HtmlNode>> nodes = () -> DocumentToHtml.this.convertChildrenToHtml(run, context);
            if (run.isSmallCaps()) {
                nodes = DocumentToHtml.this.styleMap.getSmallCaps().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.isAllCaps()) {
                nodes = DocumentToHtml.this.styleMap.getAllCaps().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.isStrikethrough()) {
                nodes = DocumentToHtml.this.styleMap.getStrikethrough().orElse(HtmlPath.collapsibleElement("s")).wrap(nodes);
            }
            if (run.isUnderline()) {
                nodes = DocumentToHtml.this.styleMap.getUnderline().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.getVerticalAlignment() == VerticalAlignment.SUBSCRIPT) {
                nodes = HtmlPath.collapsibleElement("sub").wrap(nodes);
            }
            if (run.getVerticalAlignment() == VerticalAlignment.SUPERSCRIPT) {
                nodes = HtmlPath.collapsibleElement("sup").wrap(nodes);
            }
            if (run.isItalic()) {
                nodes = DocumentToHtml.this.styleMap.getItalic().orElse(HtmlPath.collapsibleElement("em")).wrap(nodes);
            }
            if (run.isBold()) {
                nodes = DocumentToHtml.this.styleMap.getBold().orElse(HtmlPath.collapsibleElement("strong")).wrap(nodes);
            }
            HtmlPath mapping = DocumentToHtml.this.styleMap.getRunHtmlPath(run).orElseGet(() -> {
                HtmlPath toRet = HtmlPath.EMPTY;
                if (run.getStyle().isPresent()) {
                    Optional<Style> parentStyle;
                    Optional<String> parentStyleId;
                    Style style;
                    Style originalStyle = style = run.getStyle().get();
                    Optional<Object> parentMapping = Optional.empty();
                    while (style.isCustom() && !parentMapping.isPresent() && (parentStyleId = style.getParentStyleId()).isPresent() && (parentStyle = DocumentToHtml.this.styles.findCharacterStyleById(parentStyleId.get())).isPresent()) {
                        style = parentStyle.get();
                        run.changeStyle(parentStyle);
                        parentMapping = DocumentToHtml.this.styleMap.getRunHtmlPath(run);
                    }
                    if (!parentMapping.isPresent()) {
                        if (DocumentToHtml.this.unknownStylesReporter != null) {
                            DocumentToHtml.this.unknownStylesReporter.reportUnknownStyle("r", originalStyle, DocumentToHtml.this.documentPath);
                        } else {
                            DocumentToHtml.this.warnings.add("Unrecognised run style: " + originalStyle.describe());
                        }
                    } else {
                        toRet = (HtmlPath)parentMapping.get();
                    }
                }
                return toRet;
            });
            return mapping.wrap(nodes).get();
        }

        @Override
        public List<HtmlNode> visit(Text text, Context context) {
            if (text.getValue().isEmpty()) {
                return Lists.list();
            }
            return Lists.list(Html.text(text.getValue()));
        }

        @Override
        public List<HtmlNode> visit(Tab tab, Context context) {
            return Lists.list(Html.text("\t"));
        }

        @Override
        public List<HtmlNode> visit(Break breakElement, Context context) {
            HtmlPath mapping = DocumentToHtml.this.styleMap.getBreakHtmlPath(breakElement).orElseGet(() -> {
                if (breakElement.getType() == Break.Type.LINE) {
                    return HtmlPath.element("br");
                }
                return HtmlPath.EMPTY;
            });
            return mapping.wrap(() -> Lists.list()).get();
        }

        @Override
        public List<HtmlNode> visit(Table table, Context context) {
            HtmlPath mapping = DocumentToHtml.this.styleMap.getTableHtmlPath(table).orElse(HtmlPath.element("table"));
            Optional<String> tableId = table.getId();
            if (tableId.isPresent() && mapping instanceof HtmlPathElements) {
                mapping = this.setIdOnTableElement((HtmlPathElements)mapping, tableId.get());
            }
            return mapping.wrap(() -> this.generateTableChildren(table, context)).get();
        }

        private HtmlPathElements setIdOnTableElement(HtmlPathElements tableElements, String id) {
            HtmlPathElements toRet = tableElements;
            ArrayList<HtmlPathElement> elements = new ArrayList<HtmlPathElement>(tableElements.getElements());
            if (!elements.isEmpty()) {
                HtmlPathElement firstElement = (HtmlPathElement)elements.get(0);
                HtmlTag tag = firstElement.getTag();
                HashMap<String, String> attributes = new HashMap<String, String>(tag.getAttributes());
                attributes.put("id", id);
                elements.set(0, new HtmlPathElement(new HtmlTag(tag.getTagNames(), attributes, tag.isCollapsible(), tag.getSeparator())));
                toRet = new HtmlPathElements(elements);
            }
            return toRet;
        }

        private List<HtmlNode> generateTableChildren(Table table, Context context) {
            int bodyIndex;
            int gridIndex;
            ArrayList<HtmlNode> toRet = new ArrayList<HtmlNode>();
            List<DocumentElement> children = table.getChildren();
            int captionIndex = Iterables.findIndex(children, child -> !(child instanceof SEQCaption)).orElse(-1);
            if (captionIndex > 0) {
                toRet.addAll(this.visit((SEQCaption)children.get(captionIndex - 1), context));
                children.remove(captionIndex - 1);
            }
            if ((gridIndex = Iterables.findIndex(children, child -> !(child instanceof TableGrid)).orElse(-1)) > 0) {
                List<HtmlNode> visit = this.visit((TableGrid)children.get(gridIndex - 1), context);
                toRet.addAll(visit);
                children.remove(gridIndex - 1);
            }
            if ((bodyIndex = Iterables.findIndex(children, child -> !this.isHeader((DocumentElement)child)).orElse(children.size())) == 0) {
                toRet.addAll(DocumentToHtml.this.convertToHtml(children, context.isHeader(false)));
            } else {
                List<HtmlNode> headRows = DocumentToHtml.this.convertToHtml(children.subList(0, bodyIndex), context.isHeader(true));
                List<HtmlNode> bodyRows = DocumentToHtml.this.convertToHtml(children.subList(bodyIndex, children.size()), context.isHeader(false));
                toRet.addAll(Lists.list(Html.element("thead", headRows), Html.element("tbody", bodyRows)));
            }
            return toRet;
        }

        private boolean isHeader(DocumentElement child) {
            return Casts.tryCast(TableRow.class, child).map(TableRow::isHeader).orElse(false);
        }

        @Override
        public List<HtmlNode> visit(TableGrid tableGrid, Context context) {
            return Lists.list(Html.element("colgroup", DocumentToHtml.this.convertChildrenToHtml(tableGrid, context)));
        }

        @Override
        public List<HtmlNode> visit(TableGridCol gridCol, Context context) {
            return Lists.list(Html.element("col", Maps.mutableMap("width", gridCol.getComputedAutoWidthVal())));
        }

        @Override
        public List<HtmlNode> visit(SEQCaption caption, Context context) {
            return Lists.list(Html.element(caption.isCaptionForTable() ? "caption" : "figcaption", DocumentToHtml.this.convertChildrenToHtml(caption, context)));
        }

        @Override
        public List<HtmlNode> visit(TableRow tableRow, Context context) {
            Optional<String> tableRowId = tableRow.getId();
            HtmlNode node = tableRowId.isPresent() ? Html.element("tr", Maps.map("id", DocumentToHtml.this.generateId(tableRowId.get())), Lists.cons(Html.FORCE_WRITE, DocumentToHtml.this.convertChildrenToHtml(tableRow, context))) : Html.element("tr", Lists.cons(Html.FORCE_WRITE, DocumentToHtml.this.convertChildrenToHtml(tableRow, context)));
            return Lists.list(node);
        }

        @Override
        public List<HtmlNode> visit(TableCell tableCell, Context context) {
            String tagName = context.isHeader ? "th" : "td";
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (tableCell.getColspan() != 1) {
                attributes.put("colspan", Integer.toString(tableCell.getColspan()));
            }
            if (tableCell.getRowspan() != 1) {
                attributes.put("rowspan", Integer.toString(tableCell.getRowspan()));
            }
            return Lists.list(Html.element(tagName, attributes, Lists.cons(Html.FORCE_WRITE, DocumentToHtml.this.convertChildrenToHtml(tableCell, context))));
        }

        @Override
        public List<HtmlNode> visit(Hyperlink hyperlink, Context context) {
            Map<String, String> attributes = Maps.mutableMap("href", this.generateHref(hyperlink));
            hyperlink.getTargetFrame().ifPresent(targetFrame -> attributes.put("target", (String)targetFrame));
            return Lists.list(Html.collapsibleElement("a", attributes, DocumentToHtml.this.convertChildrenToHtml(hyperlink, context)));
        }

        private String generateHref(Hyperlink hyperlink) {
            if (hyperlink.getHref().isPresent()) {
                return hyperlink.getHref().get();
            }
            if (hyperlink.getAnchor().isPresent()) {
                return "#" + DocumentToHtml.this.generateId(hyperlink.getAnchor().get());
            }
            return "";
        }

        @Override
        public List<HtmlNode> visit(Bookmark bookmark, Context context) {
            return Lists.list(Html.element("a", Maps.map("id", DocumentToHtml.this.generateId(bookmark.getName())), Lists.list(Html.FORCE_WRITE)));
        }

        @Override
        public List<HtmlNode> visit(NoteReference noteReference, Context context) {
            DocumentToHtml.this.noteReferences.add(noteReference);
            String noteAnchor = DocumentToHtml.this.generateNoteHtmlId(noteReference.getNoteType(), noteReference.getNoteId());
            String noteReferenceAnchor = DocumentToHtml.this.generateNoteRefHtmlId(noteReference.getNoteType(), noteReference.getNoteId());
            List<HtmlNode> toRet = Lists.list(Html.element("a", Maps.map("href", "#" + noteAnchor, "id", noteReferenceAnchor), Lists.list(Html.text("[" + DocumentToHtml.this.noteReferences.size() + "]"))));
            if (DocumentToHtml.this.shouldConvertNotesIntoAList) {
                toRet = Lists.list(Html.element("sup", toRet));
            }
            return toRet;
        }

        @Override
        public List<HtmlNode> visit(CommentReference commentReference, Context context) {
            return DocumentToHtml.this.styleMap.getCommentReference().orElse(HtmlPath.IGNORE).wrap(() -> {
                String commentId = commentReference.getCommentId();
                Comment comment = Maps.lookup(DocumentToHtml.this.comments, commentId).orElseThrow(() -> new RuntimeException("Referenced comment could not be found, id: " + commentId));
                String label = "[" + comment.getAuthorInitials().orElse("") + (DocumentToHtml.this.referencedComments.size() + 1) + "]";
                DocumentToHtml.this.referencedComments.add(new ReferencedComment(label, comment));
                return Lists.list(Html.element("a", Maps.map("href", "#" + DocumentToHtml.this.generateReferentHtmlId("comment", commentId), "id", DocumentToHtml.this.generateReferenceHtmlId("comment", commentId)), Lists.list(Html.text(label))));
            }).get();
        }

        @Override
        public List<HtmlNode> visit(Image image, Context context) {
            try {
                return DocumentToHtml.this.imageConverter.convert(image);
            }
            catch (IOException exception) {
                DocumentToHtml.this.warnings.add(exception.getMessage());
                return Lists.list();
            }
        }

        @Override
        public List<HtmlNode> visit(Figure figure, Context context) {
            return Lists.list(Html.element("figure", DocumentToHtml.this.convertChildrenToHtml(figure, context)));
        }

        @Override
        public List<HtmlNode> visit(Math math, Context context) {
            String mathXmlFragment = math.getMathXMLFragment();
            if (mathXmlFragment.isEmpty()) {
                return Lists.list();
            }
            return Lists.list(new HtmlCommentElement(mathXmlFragment));
        }

        @Override
        public List<HtmlNode> visit(IndexTerm indexTerm, Context context) {
            String mainEntry = indexTerm.getMainEntry();
            if (mainEntry.isEmpty()) {
                return Lists.list();
            }
            ArrayList<HtmlNode> childrens = new ArrayList<HtmlNode>();
            childrens.add(Html.text(mainEntry));
            List<String> subentries = indexTerm.getSubentries();
            for (String subentry : subentries) {
                childrens.add(Html.element("span", Maps.map("class", "indexTerm"), Lists.list(Html.text(subentry))));
            }
            Optional<String> crossRefEntry = indexTerm.getCrossRefEntry();
            if (crossRefEntry.isPresent()) {
                childrens.add(Html.element("span", Maps.map("class", "indexSee"), Lists.list(Html.text(crossRefEntry.get()))));
            }
            return Lists.list(Html.element("span", Maps.map("class", "indexTerm", "style", "display: none;"), childrens));
        }
    }

    private static class ReferencedComment {
        private final String label;
        private final Comment comment;

        private ReferencedComment(String label, Comment comment) {
            this.label = label;
            this.comment = comment;
        }
    }
}

