/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class SVNException
extends Exception {
    private static final long serialVersionUID = 4845L;
    private SVNErrorMessage myErrorMessage;

    public SVNException(SVNErrorMessage errorMessage) {
        this(errorMessage, errorMessage.getCause());
    }

    public SVNException(SVNErrorMessage errorMessage, Throwable cause) {
        super(cause != null ? cause : errorMessage.getCause());
        if (cause == null) {
            cause = errorMessage.getCause();
        }
        if (cause instanceof SVNException) {
            SVNErrorMessage childMessages = ((SVNException)cause).getErrorMessage();
            SVNErrorMessage parent = errorMessage;
            while (parent.hasChildErrorMessage()) {
                parent = parent.getChildErrorMessage();
            }
            if (parent != childMessages) {
                parent.setChildErrorMessage(childMessages);
            }
        }
        this.myErrorMessage = errorMessage;
        if (this.getCause() == null && errorMessage != null) {
            errorMessage.initCause(this);
        }
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    @Override
    public String getMessage() {
        SVNErrorMessage error = this.getErrorMessage();
        if (error != null) {
            return error.getFullMessage();
        }
        return super.getMessage();
    }

    public boolean isEnoent() {
        SVNErrorCode errorCode = this.getErrorMessage().getErrorCode();
        return errorCode == SVNErrorCode.ENTRY_NOT_FOUND || errorCode == SVNErrorCode.FS_NOT_FOUND || errorCode == SVNErrorCode.FS_NOT_OPEN || errorCode == SVNErrorCode.FS_NOT_FILE;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        SVNErrorMessage err = this.getErrorMessage();
        while (err != null) {
            if ((err = err.getChildErrorMessage()) == null) continue;
            s.println("Caused by: ");
            err.getCause().printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        SVNErrorMessage err = this.getErrorMessage();
        while (err != null) {
            if ((err = err.getChildErrorMessage()) == null || err.getCause() == null) continue;
            s.println("Caused by: ");
            err.getCause().printStackTrace(s);
        }
    }
}

