/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.validate.schematron.SchematronSchemaReaderFactory;
import com.thaiopensource.validate.schematron.extfn.ColumnNumberFunctionDefinition;
import com.thaiopensource.validate.schematron.extfn.LineNumberFunctionDefinition;
import com.thaiopensource.validate.schematron.extfn.SystemIdFunctionDefinition;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.oxygen.SaxonEEUtilFacade;

public class NewSaxonSchemaReaderFactory
extends SchematronSchemaReaderFactory {
    @Override
    public SAXTransformerFactory newTransformerFactory() {
        SAXTransformerFactory factory = SaxonEEUtilFacade.getSaxonEEUtil().newEnterpriseTransformerFactory();
        if (factory != null) {
            try {
                factory.setFeature("http://saxon.sf.net/feature/generateByteCode", false);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            factory = this._newTransformerFactory();
        }
        return factory;
    }

    @Override
    public void initTransformerFactory(TransformerFactory factory) {
        SaxonEEUtilFacade.getSaxonEEUtil().setEnterpriseTransformerConfiguration(factory);
        this._initTransformerFactory(factory);
        try {
            factory.setAttribute("http://saxon.sf.net/feature/xsltVersion", "3.0");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public SAXTransformerFactory _newTransformerFactory() {
        return new TransformerFactoryImpl();
    }

    public void _initTransformerFactory(TransformerFactory factory) {
        if (factory instanceof TransformerFactoryImpl && this.hasSaxonHEConfiguration((TransformerFactoryImpl)factory)) {
            Configuration conf = ((TransformerFactoryImpl)factory).getConfiguration();
            conf.registerExtensionFunction((ExtensionFunctionDefinition)new LineNumberFunctionDefinition());
            conf.registerExtensionFunction((ExtensionFunctionDefinition)new ColumnNumberFunctionDefinition());
            conf.registerExtensionFunction((ExtensionFunctionDefinition)new SystemIdFunctionDefinition());
        }
    }

    private boolean hasSaxonHEConfiguration(TransformerFactoryImpl factory) {
        return Configuration.class.getName().equals(factory.getConfiguration().getClass().getName());
    }
}

