/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.sax;

import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.relaxng.sax.JingSaxParseException;
import com.thaiopensource.relaxng.sax.OptionsProvider;
import com.thaiopensource.xml.util.Name;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends Context
implements ContentHandler,
DTDHandler {
    private Matcher matcher;
    private final ErrorHandler eh;
    private boolean bufferingCharacters = false;
    private final StringBuilder charBuf = new StringBuilder();
    private Locator locator = null;
    private String rootLocalName = null;

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.rootLocalName == null) {
            this.rootLocalName = localName;
        }
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this));
        }
        Name name = new Name(namespaceURI, localName);
        this.check(this.matcher.matchStartTagOpen(name, qName, this));
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            OptionsProvider optsProvider;
            Name attName = new Name(atts.getURI(i), atts.getLocalName(i));
            String attQName = atts.getQName(i);
            boolean specialDataAttribute = false;
            if (attQName != null && attQName.startsWith("data-") && ("http://www.w3.org/1999/xhtml".equals(namespaceURI) || "html".equalsIgnoreCase(this.rootLocalName) && "".equals(namespaceURI)) && (optsProvider = OptionsProvider.getInstance()) != null && optsProvider.shouldSkipXHTMLDataAttributesValidation()) {
                specialDataAttribute = true;
            }
            boolean attrNameMatch = this.matcher.matchAttributeName(attName, attQName, this);
            if (specialDataAttribute && !attrNameMatch) {
                this.matcher.matchAttributeValue(atts.getValue(i), attName, attQName, this);
                continue;
            }
            this.check(attrNameMatch);
            this.check(this.matcher.matchAttributeValue(atts.getValue(i), attName, attQName, this));
        }
        this.check(this.matcher.matchStartTagClose(name, qName, this));
        if (this.matcher.isTextTyped()) {
            this.bufferingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            if (this.charBuf.length() > 0) {
                this.check(this.matcher.matchTextBeforeEndTag(this.charBuf.toString(), new Name(namespaceURI, localName), qName, this));
            }
        }
        this.check(this.matcher.matchEndTag(new Name(namespaceURI, localName), qName, this));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.bufferingCharacters) {
            this.charBuf.append(ch, start, length);
            return;
        }
        block3: for (int i = 0; i < length; ++i) {
            switch (ch[start + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.check(this.matcher.matchUntypedText(this));
                    return;
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.check(this.matcher.matchEndDocument());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.check(this.matcher.matchStartDocument());
    }

    @Override
    public void processingInstruction(String target, String date) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this));
        }
        super.startPrefixMapping(prefix, uri);
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder builder, ErrorHandler eh) {
        this.matcher = new PatternMatcher(pattern, builder);
        this.eh = eh;
    }

    @Override
    public void reset() {
        super.reset();
        this.bufferingCharacters = false;
        this.locator = null;
        this.matcher = this.matcher.start();
    }

    private void check(boolean ok) throws SAXException {
        if (!ok) {
            SAXParseException ex = new SAXParseException(this.matcher.getErrorMessage(), this.locator);
            if (this.matcher instanceof PatternMatcher) {
                PatternMatcher pm = (PatternMatcher)this.matcher;
                ex = new JingSaxParseException(ex, pm.getErrorKey(), pm.getErrorArgs());
            }
            this.eh.error(ex);
        }
    }
}

