/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.StringPattern;
import com.thaiopensource.xml.util.Name;
import org.relaxng.datatype.Datatype;

public class ValuePattern
extends StringPattern {
    private final Object obj;
    private final Datatype dt;
    private final Name dtName;
    private final String stringValue;

    ValuePattern(Datatype dt, Name dtName, Object obj, String stringValue) {
        super(ValuePattern.combineHashCode(27, dt.valueHashCode(obj)));
        this.dt = dt;
        this.dtName = dtName;
        this.obj = obj;
        this.stringValue = stringValue;
    }

    @Override
    boolean samePattern(Pattern other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!(other instanceof ValuePattern)) {
            return false;
        }
        return this.dt.equals(((ValuePattern)other).dt) && this.dt.sameValue(this.obj, ((ValuePattern)other).obj);
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseValue(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_value");
            }
        }
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Name getDatatypeName() {
        return this.dtName;
    }

    public Object getValue() {
        return this.obj;
    }

    String getStringValue() {
        return this.stringValue;
    }
}

