/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataDerivTypeFunction;
import com.thaiopensource.relaxng.pattern.EndAttributesFunction;
import com.thaiopensource.relaxng.pattern.EndTagDerivFunction;
import com.thaiopensource.relaxng.pattern.IgnoreMissingAttributesFunction;
import com.thaiopensource.relaxng.pattern.MixedTextDerivFunction;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.PossibleAttributeNamesFunction;
import com.thaiopensource.relaxng.pattern.PossibleNamesFunction;
import com.thaiopensource.relaxng.pattern.PossibleStartTagNamesFunction;
import com.thaiopensource.relaxng.pattern.RecoverAfterFunction;
import com.thaiopensource.relaxng.pattern.RequiredAttributesFunction;
import com.thaiopensource.relaxng.pattern.RequiredElementsFunction;
import com.thaiopensource.relaxng.pattern.TextOnlyFunction;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ValidatorPatternBuilder
extends PatternBuilder {
    private final Map<Pattern, PatternMemo> patternMemoMap = new HashMap<Pattern, PatternMemo>();
    private final PatternFunction<Pattern> endAttributesFunction;
    private final PatternFunction<Pattern> ignoreMissingAttributesFunction;
    private final PatternFunction<Pattern> endTagDerivFunction;
    private final PatternFunction<Pattern> mixedTextDerivFunction;
    private final PatternFunction<Pattern> textOnlyFunction;
    private final PatternFunction<Pattern> recoverAfterFunction;
    private final PatternFunction<DataDerivType> dataDerivTypeFunction;
    private final Map<Pattern, Pattern> choiceMap = new HashMap<Pattern, Pattern>();
    private final PatternFunction<Pattern> removeChoicesFunction = new RemoveChoicesFunction();
    private final PatternFunction<VoidValue> noteChoicesFunction = new NoteChoicesFunction();
    private final PatternFunction<Set<Name>> requiredElementsFunction = new RequiredElementsFunction();
    private final PatternFunction<Set<Name>> requiredAttributesFunction = new RequiredAttributesFunction();
    private final PossibleNamesFunction possibleStartTagNamesFunction = new PossibleStartTagNamesFunction();
    private final PossibleNamesFunction possibleAttributeNamesFunction = new PossibleAttributeNamesFunction();

    public ValidatorPatternBuilder(PatternBuilder builder) {
        super(builder);
        this.endAttributesFunction = new EndAttributesFunction(this);
        this.ignoreMissingAttributesFunction = new IgnoreMissingAttributesFunction(this);
        this.endTagDerivFunction = new EndTagDerivFunction(this);
        this.mixedTextDerivFunction = new MixedTextDerivFunction(this);
        this.textOnlyFunction = new TextOnlyFunction(this);
        this.recoverAfterFunction = new RecoverAfterFunction(this);
        this.dataDerivTypeFunction = new DataDerivTypeFunction(this);
    }

    public PatternMemo getPatternMemo(Pattern p) {
        PatternMemo memo = this.patternMemoMap.get(p);
        if (memo == null) {
            memo = new PatternMemo(p, this);
            this.patternMemoMap.put(p, memo);
        }
        return memo;
    }

    PatternFunction<Pattern> getEndAttributesFunction() {
        return this.endAttributesFunction;
    }

    PatternFunction<Pattern> getIgnoreMissingAttributesFunction() {
        return this.ignoreMissingAttributesFunction;
    }

    PatternFunction<Set<Name>> getRequiredElementsFunction() {
        return this.requiredElementsFunction;
    }

    PatternFunction<Set<Name>> getRequiredAttributesFunction() {
        return this.requiredAttributesFunction;
    }

    PossibleNamesFunction getPossibleStartTagNamesFunction() {
        return this.possibleStartTagNamesFunction;
    }

    PossibleNamesFunction getPossibleAttributeNamesFunction() {
        return this.possibleAttributeNamesFunction;
    }

    PatternFunction<Pattern> getEndTagDerivFunction() {
        return this.endTagDerivFunction;
    }

    PatternFunction<Pattern> getMixedTextDerivFunction() {
        return this.mixedTextDerivFunction;
    }

    PatternFunction<Pattern> getTextOnlyFunction() {
        return this.textOnlyFunction;
    }

    PatternFunction<Pattern> getRecoverAfterFunction() {
        return this.recoverAfterFunction;
    }

    PatternFunction<DataDerivType> getDataDerivTypeFunction() {
        return this.dataDerivTypeFunction;
    }

    public Pattern makeAfter(Pattern p1, Pattern p2) {
        AfterPattern p = new AfterPattern(p1, p2);
        return this.interner.intern(p);
    }

    @Override
    public Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == p2) {
            return p1;
        }
        if (p1 == this.notAllowed) {
            return p2;
        }
        if (p2 == this.notAllowed) {
            return p1;
        }
        if (!(p1 instanceof ChoicePattern)) {
            if (p2.containsChoice(p1)) {
                return p2;
            }
        } else if (!(p2 instanceof ChoicePattern)) {
            if (p1.containsChoice(p2)) {
                return p1;
            }
        } else {
            p1.apply(this.noteChoicesFunction);
            p2 = p2.apply(this.removeChoicesFunction);
            if (this.choiceMap.size() > 0) {
                this.choiceMap.clear();
            }
            if (p2 == this.notAllowed) {
                return p1;
            }
        }
        if (p1 instanceof AfterPattern && p2 instanceof AfterPattern) {
            AfterPattern ap1 = (AfterPattern)p1;
            AfterPattern ap2 = (AfterPattern)p2;
            if (ap1.getOperand1() == ap2.getOperand1()) {
                return this.makeAfter(ap1.getOperand1(), this.makeChoice(ap1.getOperand2(), ap2.getOperand2()));
            }
            if (ap1.getOperand1() == this.notAllowed) {
                return ap2;
            }
            if (ap2.getOperand1() == this.notAllowed) {
                return ap1;
            }
            if (ap1.getOperand2() == ap2.getOperand2()) {
                return this.makeAfter(this.makeChoice(ap1.getOperand1(), ap2.getOperand1()), ap1.getOperand2());
            }
        }
        return super.makeChoice(p1, p2);
    }

    private class RemoveChoicesFunction
    extends AbstractPatternFunction<Pattern> {
        private RemoveChoicesFunction() {
        }

        @Override
        public Pattern caseOther(Pattern p) {
            if (ValidatorPatternBuilder.this.choiceMap.get(p) != null) {
                return ValidatorPatternBuilder.this.notAllowed;
            }
            return p;
        }

        @Override
        public Pattern caseChoice(ChoicePattern p) {
            Pattern p1 = p.getOperand1().apply(this);
            Pattern p2 = p.getOperand2().apply(this);
            if (p1 == p.getOperand1() && p2 == p.getOperand2()) {
                return p;
            }
            if (p1 == ValidatorPatternBuilder.this.notAllowed) {
                return p2;
            }
            if (p2 == ValidatorPatternBuilder.this.notAllowed) {
                return p1;
            }
            ChoicePattern p3 = new ChoicePattern(p1, p2);
            return ValidatorPatternBuilder.this.interner.intern(p3);
        }
    }

    private class NoteChoicesFunction
    extends AbstractPatternFunction<VoidValue> {
        private NoteChoicesFunction() {
        }

        @Override
        public VoidValue caseOther(Pattern p) {
            ValidatorPatternBuilder.this.choiceMap.put(p, p);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseChoice(ChoicePattern p) {
            p.getOperand1().apply(this);
            p.getOperand2().apply(this);
            return VoidValue.VOID;
        }
    }
}

