/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SimpleIDAnnotationsExtractor;
import com.thaiopensource.relaxng.sax.JingSaxParseException;
import com.thaiopensource.validate.rng.impl.IdCollector;
import com.thaiopensource.validate.rng.impl.JingIdValue;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.xerces.impl.locator.AttributeLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private final LinkedHashMap<String, Entry> map = new LinkedHashMap();
    private IdCollector idValues;
    private SimpleIDAnnotationsExtractor annotationsExtractor = new SimpleIDAnnotationsExtractor();
    private List<JingIdValue> currentElementIDValues = null;

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler eh, IdCollector idValues) {
        this.idTypeMap = idTypeMap;
        this.eh = eh;
        this.idValues = idValues;
    }

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler eh) {
        this.idTypeMap = idTypeMap;
        this.eh = eh;
    }

    public void reset() {
        this.map.clear();
        this.currentElementIDValues = null;
    }

    public void endDocument() throws SAXException {
        for (String token : this.map.keySet()) {
            Entry entry = this.map.get(token);
            if (entry.hadId) continue;
            for (AttributeLocator idrefLoc : entry.idrefLocs) {
                this.error("missing_id", token, (Locator)idrefLoc, idrefLoc.getQName(), idrefLoc.getValue());
            }
        }
    }

    public void attribute(Name elementName, Name attributeName, String attributeQName, String value, Locator locator) throws SAXException {
        int idType = this.idTypeMap.getIdType(elementName, attributeName);
        if (idType != 0) {
            String[] tokens = StringSplitter.split(value);
            switch (idType) {
                case 1: {
                    if (tokens.length == 1) {
                        this.id(tokens[0], locator, attributeQName);
                        break;
                    }
                    if (tokens.length == 0) {
                        this.error("id_no_tokens", locator, attributeQName);
                        break;
                    }
                    this.error("id_multiple_tokens", locator, attributeQName);
                    break;
                }
                case 2: {
                    if (tokens.length == 1) {
                        this.idref(tokens[0], locator, attributeQName, value);
                        break;
                    }
                    if (tokens.length == 0) {
                        this.error("idref_no_tokens", locator, attributeQName);
                        break;
                    }
                    this.error("idref_multiple_tokens", locator, attributeQName);
                    break;
                }
                case 3: {
                    if (tokens.length > 0) {
                        for (int j = 0; j < tokens.length; ++j) {
                            this.idref(tokens[j], locator, attributeQName, value);
                        }
                        break;
                    }
                    this.error("idrefs_no_tokens", locator, attributeQName);
                }
            }
        }
    }

    private void id(String token, Locator locator, String attributeQName) throws SAXException {
        Entry entry;
        if (this.idValues != null) {
            if (this.currentElementIDValues == null) {
                this.currentElementIDValues = new ArrayList<JingIdValue>(1);
            }
            this.currentElementIDValues.add(new JingIdValue(token, locator != null ? locator.getSystemId() : null));
        }
        if ((entry = this.map.get(token)) == null) {
            entry = new Entry();
            this.map.put(token, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", token, locator, attributeQName, null);
            this.error("first_id", token, entry.idLoc, attributeQName, null);
            return;
        }
        entry.idLoc = new LocatorImpl(locator);
        entry.hadId = true;
    }

    private void idref(String token, Locator locator, String attributeQname, String value) {
        Entry entry = this.map.get(token);
        if (entry == null) {
            entry = new Entry();
            this.map.put(token, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new ArrayList<AttributeLocator>();
        }
        String localName = attributeQname;
        String prefix = null;
        int indexOf = attributeQname.indexOf(58);
        if (indexOf != -1) {
            prefix = attributeQname.substring(0, indexOf);
            localName.substring(indexOf);
        }
        entry.idrefLocs.add(new AttributeLocator(prefix, null, localName, value, locator.getLineNumber(), locator.getColumnNumber() - 1, -1, -1, -1, -1, -1, -1, locator.getPublicId(), locator.getSystemId()));
    }

    private void error(String key, Locator locator, String attrName) throws SAXException {
        this.eh.error(new JingSaxParseException(new SAXParseException(SchemaBuilderImpl.localizer.message(key), locator), key, new String[]{attrName}));
    }

    private void error(String key, String arg, Locator locator, String attrName, String value) throws SAXException {
        this.eh.error(new JingSaxParseException(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), locator), key, new String[]{attrName, arg, value}));
    }

    public void characters(char[] chars, int offset, int len) {
        this.annotationsExtractor.characters(chars, offset, len);
    }

    public void endElement() {
        this.annotationsExtractor.endElement();
    }

    public void startElement() {
        this.currentElementIDValues = null;
    }

    public void startElementFinished() {
        this.annotationsExtractor.startElement(this.currentElementIDValues);
        if (this.currentElementIDValues != null && this.idValues != null) {
            this.idValues.addAll(this.currentElementIDValues);
        }
    }

    private static class Entry {
        LocatorImpl idLoc;
        List<AttributeLocator> idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

