/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.properties.CALSAndHTMLShowTablePropertiesBase;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelper;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class CALSShowTableProperties
extends CALSAndHTMLShowTablePropertiesBase {
    public CALSShowTableProperties(TablePropertiesHelper helper) {
        super(helper);
    }

    @Override
    protected List<TabInfo> getElementsWithModifiedAttributes(EditedTablePropertiesInfo tableInfo) {
        ArrayList<TabInfo> toModify = new ArrayList<TabInfo>();
        List<TabInfo> categories = tableInfo.getCategories();
        for (int i = 0; i < categories.size(); ++i) {
            ArrayList<TableProperty> attrs = new ArrayList<TableProperty>();
            TabInfo tabInfo = categories.get(i);
            List<AuthorElement> nodes = tabInfo.getNodes();
            List<TableProperty> props = tabInfo.getProperties();
            if (!nodes.isEmpty() && this.tableHelper.isNodeOfType(nodes.get(0), 5)) {
                int j;
                ArrayList<TableProperty> tableAttributes = new ArrayList<TableProperty>();
                ArrayList<TableProperty> tgroupAttributes = new ArrayList<TableProperty>();
                ArrayList<AuthorElement> tableElements = new ArrayList<AuthorElement>();
                ArrayList<AuthorElement> tgroupElements = new ArrayList<AuthorElement>();
                for (j = 0; j < nodes.size(); ++j) {
                    if (this.tableHelper.isNodeOfType(nodes.get(j), 4)) {
                        tgroupElements.add(nodes.get(j));
                        continue;
                    }
                    tableElements.add(nodes.get(j));
                }
                for (j = 0; j < props.size(); ++j) {
                    TableProperty prop = props.get(j);
                    if (!prop.isAttribute() || "<preserve>".equals(prop.getCurrentValue())) continue;
                    if ("<not set>".equals(prop.getCurrentValue())) {
                        prop.setCurrentValue(null);
                    }
                    if ("align".equals(prop.getAttributeName())) {
                        tgroupAttributes.add(prop);
                        continue;
                    }
                    tableAttributes.add(prop);
                }
                if (!tgroupAttributes.isEmpty() && !tgroupElements.isEmpty()) {
                    toModify.add(new TabInfo(tabInfo.getTabKey(), tgroupAttributes, tgroupElements));
                }
                if (tableAttributes.isEmpty() || tableElements.isEmpty()) continue;
                toModify.add(new TabInfo(tabInfo.getTabKey(), tableAttributes, tableElements));
                continue;
            }
            for (int j = 0; j < props.size(); ++j) {
                TableProperty prop = props.get(j);
                if (!prop.isAttribute() || "<preserve>".equals(prop.getCurrentValue())) continue;
                if ("<not set>".equals(prop.getCurrentValue())) {
                    prop.setCurrentValue(null);
                }
                attrs.add(prop);
            }
            toModify.add(new TabInfo(tabInfo.getTabKey(), attrs, tabInfo.getNodes()));
        }
        return toModify;
    }

    @Override
    protected List<AuthorElement> getColSpecs(Map<AuthorElement, Set<Integer>> map) {
        CALSTableCellInfoProvider calsTableCellInfoProvider = new CALSTableCellInfoProvider();
        ArrayList<AuthorElement> colspecs = new ArrayList<AuthorElement>();
        Set<AuthorElement> keySet = map.keySet();
        for (AuthorElement tgroupElement : keySet) {
            calsTableCellInfoProvider.init(tgroupElement);
            Set<Integer> set = map.get(tgroupElement);
            for (Integer index : set) {
                AuthorElement colSpecElement;
                CALSColSpec colSpec = calsTableCellInfoProvider.getColSpec(index);
                if (colSpec == null || (colSpecElement = calsTableCellInfoProvider.getColSpecElement(colSpec)) == null) continue;
                colspecs.add(colSpecElement);
            }
        }
        return colspecs;
    }

    @Override
    protected Map<AuthorElement, Set<Integer>> getCellIndexes(List<AuthorElement> cells) {
        return TableOperationsUtil.getCellIndexes(cells, this.authorAccess, this.tableHelper, true);
    }
}

