/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.JoinOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class JoinOperation
extends JoinOperationBase {
    public JoinOperation(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    public JoinOperation() {
        super(new CALSDocumentTypeHelper());
    }

    @Override
    protected void generateColumnSpecifications(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSpanSupport, AuthorElement tableElement) throws AuthorOperationException {
        int cols = authorAccess.getTableAccess().getTableNumberOfColumns(tableElement);
        StringBuilder colSpecs = new StringBuilder();
        for (int i = 1; i <= cols; ++i) {
            colSpecs.append("<colspec colname=\"c").append(i).append("\" colnum=\"").append(i).append("\"");
            String namespace = tableElement.getNamespace();
            if (namespace != null && namespace.length() > 0) {
                colSpecs.append(" xmlns=\"").append(namespace).append("\"");
            }
            colSpecs.append("/>");
        }
        authorAccess.getDocumentController().insertXMLFragment(colSpecs.toString(), tableElement.getStartOffset() + 1);
        tableSpanSupport.init(tableElement);
    }
}

