/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECTableSplitCustomizerDialog
extends TrayDialog {
    private AuthorResourceBundle authorResourceBundle;
    private Spinner rowsSpinner;
    private Spinner columnsSpinner;
    private int chosenColumns = 0;
    private int chosenRows = 0;
    private int maxColumns;
    private int maxRows;
    private String helpPageID;

    public ECTableSplitCustomizerDialog(Object parentFrame, AuthorResourceBundle authorResourceBundle, int maxColumns, int maxRows, String helpPageID) {
        super((Shell)parentFrame);
        this.authorResourceBundle = authorResourceBundle;
        this.maxColumns = maxColumns;
        this.maxRows = maxRows;
        this.helpPageID = helpPageID;
        int style = 2144;
        style |= 0x10;
        this.setShellStyle(style |= 0x10000);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        EclipseHelpUtils.installHelp(newShell, this.helpPageID);
        newShell.setText(this.authorResourceBundle.getMessage("Split_cells"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        Label label = new Label(mainComposite, 16384);
        label.setText(this.authorResourceBundle.getMessage("Number_of_columns") + ":");
        this.columnsSpinner = new Spinner(mainComposite, 2048);
        this.columnsSpinner.setMinimum(1);
        this.columnsSpinner.setMaximum(this.maxColumns);
        this.chosenColumns = this.maxColumns > 1 ? 2 : 1;
        this.columnsSpinner.setSelection(this.chosenColumns);
        this.columnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECTableSplitCustomizerDialog.this.chosenColumns = ECTableSplitCustomizerDialog.this.columnsSpinner.getSelection();
            }
        });
        GridData data = new GridData(4, 0, true, false);
        this.columnsSpinner.setLayoutData((Object)data);
        Label label2 = new Label(mainComposite, 16384);
        label2.setText(this.authorResourceBundle.getMessage("Number_of_rows") + ":");
        this.rowsSpinner = new Spinner(mainComposite, 2048);
        this.rowsSpinner.setMinimum(1);
        this.rowsSpinner.setMaximum(this.maxRows);
        this.chosenRows = 1;
        this.rowsSpinner.setSelection(this.chosenRows);
        this.rowsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECTableSplitCustomizerDialog.this.chosenRows = ECTableSplitCustomizerDialog.this.rowsSpinner.getSelection();
            }
        });
        data = new GridData(4, 0, true, false);
        this.rowsSpinner.setLayoutData((Object)data);
        return mainComposite;
    }

    public int[] getSplitInformation() {
        int[] result = null;
        if (this.open() == 0) {
            result = new int[]{this.chosenColumns, this.chosenRows};
        }
        return result;
    }
}

