/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class TableSortUtil {
    private TableSortUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean isEntirelySelected(AuthorAccess authorAccess, AuthorElement element) {
        boolean isSelected = false;
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        if (editorAccess.getAuthorSelectionModel().hasSelection()) {
            SelectionInterpretationMode selectionInterpretationMode = editorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
            if (selectionInterpretationMode == SelectionInterpretationMode.TABLE) {
                isSelected = true;
            } else if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN) {
                isSelected = TableSortUtil.isIncludedInSelectionInterval(authorAccess, element);
            }
        }
        return isSelected;
    }

    public static boolean isIncludedInSelectionInterval(AuthorAccess authorAccess, AuthorElement element) {
        List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
        for (int i = 0; i < selectionIntervals.size(); ++i) {
            ContentInterval contentInterval = (ContentInterval)selectionIntervals.get(i);
            if (contentInterval.getStartOffset() > element.getStartOffset() || contentInterval.getEndOffset() < element.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    public static boolean isColumnOrTableSelection(AuthorAccess authorAccess) {
        SelectionInterpretationMode selectionInterpretationMode = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionInterpretationMode();
        return selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN || selectionInterpretationMode == SelectionInterpretationMode.TABLE;
    }
}

