/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class PseudoClassOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)PseudoClassOperation.class.getName());
    private static final String ARGUMENT_PSEUDOCLASS_NAME = "name";
    private static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    private static final String ARGUMENT_INCLUDE_ALL_NODES = "includeAllNodes";
    private static final String YES = "yes";
    private static final String NO = "no";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];

    public PseudoClassOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element or elements whose pseudo-class will be changed.\nNote: If this is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_PSEUDOCLASS_NAME, 0, "The pseudo-class name.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_INCLUDE_ALL_NODES, 3, "The value should be \"yes\" in order to include comments, text and CDATA nodes in the XPath execution, \"no\" to ignore them.", new String[]{YES, NO}, NO);
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        Object name = args.getArgumentValue(ARGUMENT_PSEUDOCLASS_NAME);
        Object includeAllNodes = args.getArgumentValue(ARGUMENT_INCLUDE_ALL_NODES);
        if (name instanceof String) {
            String pseudoClassName = ((String)name).trim();
            if (xpathLocation instanceof String) {
                if (includeAllNodes instanceof String) {
                    boolean includeAll = includeAllNodes.equals(YES);
                    AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathLocation, null, !includeAll, !includeAll, !includeAll, false, XPathVersion.XPATH_2_0, true);
                    if (results.length > 0) {
                        for (int i = 0; i < results.length; ++i) {
                            AuthorNode node = results[i];
                            if (node instanceof AuthorElement) {
                                AuthorElement targetElement = (AuthorElement)node;
                                this.execute(authorAccess, pseudoClassName, targetElement);
                                continue;
                            }
                            logger.warn("The XPath location selected a node different from element - " + node.getDisplayName() + ": " + xpathLocation);
                        }
                    } else {
                        logger.warn("The XPath location returned no results: " + xpathLocation);
                    }
                }
            } else {
                AuthorNode node = null;
                try {
                }
                catch (BadLocationException e) {
                    throw new AuthorOperationException("Cannot identify the current element", (Throwable)e);
                }
                for (node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
                }
                if (!(node instanceof AuthorElement)) {
                    throw new AuthorOperationException("You need to have the carret inside an element.");
                }
                AuthorElement targetElement = (AuthorElement)node;
                this.execute(authorAccess, pseudoClassName, targetElement);
            }
        } else {
            throw new IllegalArgumentException("The argument \"name\" was not defined!");
        }
    }

    protected abstract void execute(AuthorAccess var1, String var2, AuthorElement var3);

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

