/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.net.MalformedURLException;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.xml.bind.JAXBException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.commons.imagemap.EditImageMapCore;
import ro.sync.ecss.imagemap.ImageMapAccess;
import ro.sync.ecss.imagemap.ImageMapNotSuportedException;
import ro.sync.ecss.imagemap.ImageMapUtil;
import ro.sync.ecss.imagemap.SupportedFrameworks;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public abstract class EditImageMapOperation
implements AuthorOperation {
    private EditImageMapCore imageMapCore;

    public EditImageMapOperation(EditImageMapCore imageMapCore) {
        this.imageMapCore = imageMapCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        block23: {
            this.processArgumentsMap(args);
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            try {
                AuthorNode[] nodes = this.imageMapCore.getNodesOfInterest(authorAccess, null, true);
                if (nodes == null) break block23;
                AuthorDocumentFragment[] fragments = new AuthorDocumentFragment[nodes.length];
                boolean doRenderMap = true;
                String[] asXML = new String[nodes.length];
                for (int i = 0; i < asXML.length; ++i) {
                    AuthorPersistentHighlight[] changeHighlights = authorAccess.getReviewController().getChangeHighlights(nodes[i].getStartOffset(), nodes[i].getEndOffset());
                    if (changeHighlights != null) {
                        for (AuthorPersistentHighlight highlight : changeHighlights) {
                            if (AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE != highlight.getType()) continue;
                            doRenderMap = false;
                            break;
                        }
                    }
                    if (!doRenderMap) break;
                    fragments[i] = documentController.createDocumentFragment(nodes[i], true);
                    asXML[i] = documentController.serializeFragmentToXML(fragments[i]);
                }
                if (doRenderMap) {
                    String[] result;
                    String emptyNS4EmptyPrefix;
                    SupportedFrameworks framework = this.imageMapCore.getSupportedFramework(nodes[0].getNamespace());
                    HashMap<String, String> uri2ProxyMappings = new HashMap<String, String>();
                    NamespaceContext nsContext = nodes[0].getNamespaceContext();
                    if (nsContext != null) {
                        String[] nss = nsContext.getNamespaces();
                        for (int i = 0; i < nss.length; ++i) {
                            uri2ProxyMappings.put(nss[i], nsContext.getPrefixForNamespace(nss[i]));
                        }
                    }
                    if ((emptyNS4EmptyPrefix = (String)uri2ProxyMappings.get("")) != null && emptyNS4EmptyPrefix.trim().length() == 0) {
                        uri2ProxyMappings.remove(emptyNS4EmptyPrefix);
                    }
                    if ((result = ImageMapAccess.getInstance().editMap(authorAccess, framework, authorAccess.getEditorAccess().getEditorLocation(), uri2ProxyMappings, ImageMapUtil.getFontOfNodeSize((AuthorAccess)authorAccess, (AuthorNode)nodes[0]), asXML)) != null) {
                        documentController.beginCompoundEdit();
                        try {
                            for (int i = 0; i < nodes.length; ++i) {
                                int startOffset = nodes[i].getStartOffset();
                                documentController.delete(startOffset, nodes[i].getEndOffset());
                                AuthorDocumentFragment toInsertFrag = documentController.createNewDocumentFragmentInContext(result[i], startOffset);
                                documentController.insertFragment(startOffset, toInsertFrag);
                            }
                            break block23;
                        }
                        finally {
                            documentController.endCompoundEdit();
                        }
                    }
                    documentController.cancelCompoundEdit();
                    break block23;
                }
                authorAccess.getWorkspaceAccess().showInformationMessage(authorAccess.getAuthorResourceBundle().getMessage("Cannot_edit_image_map_delete_change"));
            }
            catch (MalformedURLException | BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
            catch (JAXBException e) {
                StringBuilder message = new StringBuilder();
                String originalMessage = e.getMessage();
                if (originalMessage != null) {
                    if (originalMessage.startsWith("unexpected element")) {
                        message.append("The image map source contains unsupported elements that would be removed by this operation. Details: ");
                    }
                    if (originalMessage.length() > 1) {
                        message.append(Character.toUpperCase(originalMessage.charAt(0))).append(originalMessage, 1, originalMessage.length());
                    }
                } else {
                    Throwable linkedException = e.getLinkedException();
                    if (linkedException != null) {
                        message.append(linkedException.getMessage());
                    } else {
                        Throwable cause = e.getCause();
                        if (cause != null) {
                            message.append(cause.getMessage());
                        }
                    }
                }
                throw new AuthorOperationException(message.toString(), (Throwable)e);
            }
            catch (ImageMapNotSuportedException e) {
                documentController.cancelCompoundEdit();
                authorAccess.getWorkspaceAccess().showErrorMessage(e.getMessage());
            }
        }
    }

    protected void processArgumentsMap(ArgumentsMap args) {
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }
}

