/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECIDElementsCustomizerDialog
extends TrayDialog {
    private List listOfElements;
    private Button autoAssignElementIDs;
    private Button filterIDsOnCopy;
    private Text idGenerationPatternField;
    private Button editButton;
    private Button removeButton;
    private final String listMessage;
    private GenerateIDElementsInfo autoIDElementsInfo;
    private final AuthorResourceBundle authorResourceBundle;
    private boolean isDocBook;

    public ECIDElementsCustomizerDialog(Shell parentShell, String listMessage, AuthorResourceBundle authorResourceBundle, boolean isDocBook) {
        super(parentShell);
        this.listMessage = listMessage;
        this.authorResourceBundle = authorResourceBundle;
        this.isDocBook = isDocBook;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.authorResourceBundle.getMessage("ID_options"));
        EclipseHelpUtils.installHelp(newShell, this.getHelpPageID());
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 16384);
        GridData data = new GridData(0, 0, false, false);
        data.horizontalSpan = 1;
        data.horizontalIndent = 5;
        data.verticalIndent = 10;
        label.setLayoutData((Object)data);
        label.setText(this.authorResourceBundle.getMessage("ID_pattern"));
        this.idGenerationPatternField = new Text(composite, 2052);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 1;
        data.verticalIndent = 10;
        data.horizontalIndent = 5;
        this.idGenerationPatternField.setLayoutData((Object)data);
        Composite listGroup = new Composite(composite, 4);
        listGroup.setLayout((Layout)new GridLayout(3, true));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        listGroup.setLayoutData((Object)data);
        Label label2 = new Label(listGroup, 16384);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        label2.setLayoutData((Object)data);
        label2.setText(this.listMessage + ":");
        this.listOfElements = new List(listGroup, 2820);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        data.heightHint = 200;
        this.listOfElements.setLayoutData((Object)data);
        Button addButton = new Button(listGroup, 8);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ECIDElementsCustomizerDialog.this.addNewElement();
            }
        });
        addButton.setText(this.authorResourceBundle.getMessage("Add"));
        data = new GridData(256);
        data.horizontalSpan = 1;
        addButton.setLayoutData((Object)data);
        this.editButton = new Button(listGroup, 8);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ECIDElementsCustomizerDialog.this.editElement();
            }
        });
        this.editButton.setText(this.authorResourceBundle.getMessage("Edit"));
        data = new GridData(256);
        data.horizontalSpan = 1;
        this.editButton.setLayoutData((Object)data);
        this.removeButton = new Button(listGroup, 8);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ECIDElementsCustomizerDialog.this.removeElement();
            }
        });
        this.removeButton.setText(this.authorResourceBundle.getMessage("Remove"));
        data = new GridData(256);
        data.horizontalSpan = 1;
        this.removeButton.setLayoutData((Object)data);
        this.listOfElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ECIDElementsCustomizerDialog.this.updateButtonState();
            }
        });
        this.autoAssignElementIDs = new Button(composite, 32);
        this.autoAssignElementIDs.setText(this.authorResourceBundle.getMessage("Autogenerate_ids_for_elements"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        this.autoAssignElementIDs.setLayoutData((Object)data);
        this.filterIDsOnCopy = new Button(composite, 32);
        this.filterIDsOnCopy.setText(this.isDocBook ? this.authorResourceBundle.getMessage("Remove_ids_on_copy") : this.authorResourceBundle.getMessage("Remove_ids_on_copy_in_same_doc"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        this.filterIDsOnCopy.setLayoutData((Object)data);
        this.autoAssignElementIDs.setSelection(this.autoIDElementsInfo.isAutoGenerateIDs());
        String idGenerationPattern = this.autoIDElementsInfo.getIdGenerationPattern();
        this.idGenerationPatternField.setText(idGenerationPattern != null ? idGenerationPattern : "");
        String[] elementsWithIDGeneration = this.autoIDElementsInfo.getElementsWithIDGeneration();
        this.listOfElements.setItems(elementsWithIDGeneration != null ? elementsWithIDGeneration : new String[]{});
        this.filterIDsOnCopy.setSelection(this.autoIDElementsInfo.isFilterIDsOnCopy());
        this.idGenerationPatternField.setToolTipText(this.autoIDElementsInfo.getPatternTooltip());
        this.updateButtonState();
        return composite;
    }

    private void updateButtonState() {
        int selectedIndex = this.listOfElements.getSelectionIndex();
        boolean selected = selectedIndex != -1;
        this.editButton.setEnabled(selected);
        this.removeButton.setEnabled(selected);
    }

    private void addNewElement() {
        String value;
        InputDialog inputDialog = new InputDialog(this.getShell(), this.authorResourceBundle.getMessage("Add"), this.listMessage + ": ", "", null);
        int open = inputDialog.open();
        if (open == 0 && (value = inputDialog.getValue()) != null) {
            this.listOfElements.add(value);
            this.listOfElements.setSelection(this.listOfElements.getItemCount() - 1);
        }
    }

    private void editElement() {
        String value;
        InputDialog inputDialog;
        int open;
        int selectedIndex = this.listOfElements.getSelectionIndex();
        if (selectedIndex != -1 && (open = (inputDialog = new InputDialog(this.getShell(), this.authorResourceBundle.getMessage("Edit"), this.listMessage + ": ", this.listOfElements.getItem(selectedIndex), null)).open()) == 0 && (value = inputDialog.getValue()) != null) {
            this.listOfElements.setItem(selectedIndex, value);
        }
    }

    private void removeElement() {
        int selectedIndex = this.listOfElements.getSelectionIndex();
        if (selectedIndex != -1) {
            this.listOfElements.remove(selectedIndex);
            int size = this.listOfElements.getItemCount();
            if (size > 0) {
                if (selectedIndex < size) {
                    this.listOfElements.setSelection(selectedIndex);
                } else {
                    this.listOfElements.setSelection(size - 1);
                }
            }
        }
    }

    protected void okPressed() {
        this.autoIDElementsInfo = new GenerateIDElementsInfo(this.autoAssignElementIDs.getSelection(), this.idGenerationPatternField.getText(), this.listOfElements.getItems(), this.filterIDsOnCopy.getSelection());
        super.okPressed();
    }

    public GenerateIDElementsInfo showDialog(GenerateIDElementsInfo info) {
        this.autoIDElementsInfo = info;
        if (this.open() == 0) {
            return this.autoIDElementsInfo;
        }
        return null;
    }

    protected String getHelpPageID() {
        return "generate-ids";
    }
}

