/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import ro.sync.emf.common.command.Command;
import ro.sync.emf.common.command.CompoundCommand;
import ro.sync.emf.common.notify.AdapterFactory;
import ro.sync.emf.common.notify.Notifier;
import ro.sync.emf.common.util.Enumerator;
import ro.sync.emf.common.util.ResourceLocator;
import ro.sync.emf.common.util.TreeIterator;
import ro.sync.emf.common.util.UniqueEList;
import ro.sync.emf.ecore.EAttribute;
import ro.sync.emf.ecore.EClass;
import ro.sync.emf.ecore.EClassifier;
import ro.sync.emf.ecore.EDataType;
import ro.sync.emf.ecore.EEnum;
import ro.sync.emf.ecore.EEnumLiteral;
import ro.sync.emf.ecore.EObject;
import ro.sync.emf.ecore.EReference;
import ro.sync.emf.ecore.EStructuralFeature;
import ro.sync.emf.ecore.EcorePackage;
import ro.sync.emf.ecore.resource.Resource;
import ro.sync.emf.ecore.resource.ResourceSet;
import ro.sync.emf.ecore.util.EcoreUtil;
import ro.sync.emf.ecore.util.ExtendedMetaData;
import ro.sync.emf.ecore.util.FeatureMap;
import ro.sync.emf.ecore.util.FeatureMapUtil;
import ro.sync.emf.edit.command.SetCommand;
import ro.sync.emf.edit.domain.AdapterFactoryEditingDomain;
import ro.sync.emf.edit.domain.EditingDomain;
import ro.sync.emf.edit.domain.IEditingDomainProvider;
import ro.sync.emf.edit.provider.AdapterFactoryItemDelegator;
import ro.sync.emf.edit.provider.ComposeableAdapterFactory;
import ro.sync.emf.edit.provider.IItemLabelProvider;
import ro.sync.emf.edit.provider.IItemPropertyDescriptor;
import ro.sync.emf.edit.provider.IItemPropertySource;

public class ItemPropertyDescriptor
implements IItemPropertyDescriptor,
IItemPropertyDescriptor.OverrideableCommandOwner {
    protected AdapterFactory adapterFactory;
    protected ResourceLocator resourceLocator;
    protected AdapterFactoryItemDelegator itemDelegator;
    protected boolean isSettable;
    protected String displayName;
    protected String description;
    protected EStructuralFeature feature;
    protected EReference[] parentReferences;
    protected boolean multiLine;
    protected boolean sortChoices;
    protected String category;
    protected String[] filterFlags;
    protected Object commandOwner;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public static String getDefaultId(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getName();
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, false, false, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        this(adapterFactory, null, displayName, description, feature, isSettable, false, false, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, false, false, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, null, displayName, description, feature, isSettable, false, false, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, false, false, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.feature = feature;
        this.isSettable = isSettable;
        this.multiLine = multiLine;
        this.sortChoices = sortChoices;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences) {
        this(adapterFactory, null, displayName, description, parentReferences, true, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, true, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, isSettable, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, isSettable, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.parentReferences = parentReferences;
        this.isSettable = isSettable;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    @Override
    public String getCategory(Object object) {
        return this.category;
    }

    @Override
    public String getDescription(Object object) {
        return this.description;
    }

    @Override
    public String getDisplayName(Object object) {
        return this.displayName;
    }

    @Override
    public String[] getFilterFlags(Object object) {
        return this.filterFlags;
    }

    @Override
    public String getId(Object object) {
        if (this.feature != null) {
            return ItemPropertyDescriptor.getDefaultId(this.feature);
        }
        if (this.parentReferences != null && this.parentReferences.length != 0) {
            StringBuffer result = new StringBuffer(ItemPropertyDescriptor.getDefaultId(this.parentReferences[0]));
            for (int i = 1; i < this.parentReferences.length; ++i) {
                result.append('-');
                result.append(ItemPropertyDescriptor.getDefaultId(this.parentReferences[i]));
            }
            return result.toString();
        }
        return this.displayName;
    }

    @Override
    public Object getHelpContextIds(Object object) {
        return null;
    }

    protected Collection<?> getComboBoxObjects(Object object) {
        if (object instanceof EObject) {
            if (this.parentReferences != null) {
                UniqueEList<EObject> result = new UniqueEList<EObject>();
                for (int i = 0; i < this.parentReferences.length; ++i) {
                    result.addAll(ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, this.parentReferences[i].getEType()));
                }
                return result;
            }
            if (this.feature != null) {
                if (this.feature instanceof EReference) {
                    Collection<EObject> result = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, this.feature.getEType());
                    if (!this.feature.isMany() && !result.contains(null)) {
                        result.add(null);
                    }
                    return result;
                }
                if (this.feature.getEType() instanceof EEnum) {
                    EEnum eEnum = (EEnum)this.feature.getEType();
                    ArrayList<Enumerator> enumerators = new ArrayList<Enumerator>();
                    for (EEnumLiteral eEnumLiteral : eEnum.getELiterals()) {
                        enumerators.add(eEnumLiteral.getInstance());
                    }
                    return enumerators;
                }
                EDataType eDataType = (EDataType)this.feature.getEType();
                List<String> enumeration = ExtendedMetaData.INSTANCE.getEnumerationFacet(eDataType);
                if (!enumeration.isEmpty()) {
                    ArrayList<Object> enumerators = new ArrayList<Object>();
                    for (String enumerator : enumeration) {
                        enumerators.add(EcoreUtil.createFromString(eDataType, enumerator));
                    }
                    return enumerators;
                }
            }
        }
        return null;
    }

    public static Collection<EObject> getReachableObjectsOfType(EObject object, EClassifier type) {
        LinkedList<EObject> itemQueue = new LinkedList<EObject>();
        HashSet<EObject> visited = new HashSet<EObject>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        Resource resource = object.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null) {
                TreeIterator<Notifier> i = resourceSet.getAllContents();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof EObject)) continue;
                    ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, (EObject)child, type);
                    i.prune();
                }
            } else {
                for (EObject eObject : resource.getContents()) {
                    ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, eObject, type);
                }
            }
        } else {
            ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, EcoreUtil.getRootContainer(object), type);
        }
        while (!itemQueue.isEmpty()) {
            EObject nextItem = itemQueue.removeFirst();
            ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, nextItem, type);
        }
        return result;
    }

    public static void collectReachableObjectsOfType(Collection<EObject> visited, Collection<EObject> result, EObject object, EClassifier type) {
        LinkedList<EObject> itemQueue = new LinkedList<EObject>();
        ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, object, type);
        while (!itemQueue.isEmpty()) {
            EObject nextItem = itemQueue.removeFirst();
            ItemPropertyDescriptor.collectReachableObjectsOfType(visited, itemQueue, result, nextItem, type);
        }
    }

    private static void collectReachableObjectsOfType(Collection<EObject> visited, LinkedList<EObject> itemQueue, Collection<EObject> result, EObject object, EClassifier type) {
        if (visited.add(object)) {
            if (type.isInstance(object)) {
                result.add(object);
            }
            EClass eClass = object.eClass();
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                if (eStructuralFeature.isDerived()) continue;
                if (eStructuralFeature instanceof EReference) {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isMany()) {
                        List list = (List)object.eGet(eReference);
                        itemQueue.addAll(list);
                        continue;
                    }
                    EObject eObject = (EObject)object.eGet(eReference);
                    if (eObject == null) continue;
                    itemQueue.addLast(eObject);
                    continue;
                }
                if (!FeatureMapUtil.isFeatureMap(eStructuralFeature)) continue;
                for (FeatureMap.Entry entry : (FeatureMap)object.eGet(eStructuralFeature)) {
                    if (!(entry.getEStructuralFeature() instanceof EReference) || entry.getValue() == null) continue;
                    itemQueue.addLast((EObject)entry.getValue());
                }
            }
        }
    }

    @Override
    public IItemLabelProvider getLabelProvider(Object object) {
        return this.itemDelegator;
    }

    @Override
    public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherItemPropertyDescriptor) {
        return false;
    }

    protected Object createPropertyValueWrapper(Object object, Object propertyValue) {
        return new PropertyValueWrapper(this.adapterFactory, object, propertyValue, null);
    }

    public static Object getDefaultValue(EClassifier eType) {
        if (eType.getEPackage() == EcorePackage.eINSTANCE) {
            switch (eType.getClassifierID()) {
                case 22: 
                case 23: {
                    return Boolean.FALSE;
                }
                case 24: 
                case 26: {
                    return (byte)0;
                }
                case 27: 
                case 28: {
                    return Character.valueOf(' ');
                }
                case 31: 
                case 32: {
                    return 0.0;
                }
                case 37: 
                case 38: {
                    return Float.valueOf(0.0f);
                }
                case 39: 
                case 40: {
                    return 0;
                }
                case 43: 
                case 44: {
                    return 0L;
                }
                case 48: 
                case 49: {
                    return (short)0;
                }
                case 50: {
                    return "";
                }
            }
        } else {
            EDataType eDataType;
            List<String> enumeration;
            if (eType instanceof EEnum) {
                return ((EEnumLiteral)((EEnum)eType).getELiterals().get(0)).getInstance();
            }
            if (eType instanceof EDataType && !(enumeration = ExtendedMetaData.INSTANCE.getEnumerationFacet(eDataType = (EDataType)eType)).isEmpty()) {
                return EcoreUtil.createFromString(eDataType, enumeration.get(0));
            }
        }
        return null;
    }

    protected Object getValue(EObject object, EStructuralFeature feature) {
        try {
            return object.eGet(feature);
        }
        catch (Throwable exception) {
            return null;
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        EObject eObject = (EObject)object;
        if (this.feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)this.feature;
            Object result = this.getValue(eObject, attribute);
            if (result == null) {
                return null;
            }
            return this.createPropertyValueWrapper(object, result);
        }
        if (this.parentReferences != null) {
            for (int i = 0; i < this.parentReferences.length; ++i) {
                Object result = this.getValue(eObject, this.parentReferences[i]);
                if (result == null) continue;
                return this.createPropertyValueWrapper(object, result);
            }
            return "";
        }
        return this.createPropertyValueWrapper(object, this.getValue(eObject, this.feature));
    }

    @Override
    public boolean isPropertySet(Object object) {
        EObject eObject = (EObject)object;
        if (this.parentReferences != null) {
            for (int i = 0; i < this.parentReferences.length; ++i) {
                if (eObject.eGet(this.parentReferences[i]) == null) continue;
                return true;
            }
            return false;
        }
        try {
            return this.feature instanceof EAttribute ? (this.feature.isMany() ? !((List)eObject.eGet(this.feature)).isEmpty() : eObject.eIsSet(this.feature)) : eObject.eGet(this.feature) != null;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    @Override
    public boolean canSetProperty(Object object) {
        if (this.isSettable) {
            EditingDomain editingDomain = this.getEditingDomain(object);
            if (editingDomain != null) {
                Resource resource = object instanceof EObject ? ((EObject)object).eResource() : (object instanceof Resource ? (Resource)object : null);
                return resource == null || !editingDomain.isReadOnly(resource);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setCommandOwner(Object commandOwner) {
        this.commandOwner = commandOwner;
    }

    @Override
    public Object getCommandOwner() {
        return this.commandOwner;
    }

    protected Object getCommandOwner(Object fallback) {
        return this.commandOwner != null ? this.commandOwner : fallback;
    }

    @Override
    public void resetPropertyValue(Object object) {
        EObject eObject = (EObject)object;
        EditingDomain editingDomain = this.getEditingDomain(object);
        if (this.parentReferences != null) {
            for (int i = 0; i < this.parentReferences.length; ++i) {
                EReference parentReference = this.parentReferences[i];
                if (!eObject.eIsSet(parentReference)) continue;
                if (editingDomain == null) {
                    eObject.eUnset(this.parentReferences[i]);
                } else {
                    editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, SetCommand.UNSET_VALUE));
                }
                break;
            }
        } else if (editingDomain == null) {
            eObject.eUnset(this.feature);
        } else {
            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), this.feature, SetCommand.UNSET_VALUE));
        }
    }

    public EditingDomain getEditingDomain(Object object) {
        EObject eObject = (EObject)object;
        EditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor(eObject);
        if (result == null) {
            ComposeableAdapterFactory rootAdapterFactory;
            if (this.adapterFactory instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)((Object)this.adapterFactory)).getEditingDomain();
            }
            if (result == null && this.adapterFactory instanceof ComposeableAdapterFactory && (rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)((Object)rootAdapterFactory)).getEditingDomain();
            }
        }
        return result;
    }

    @Override
    public void setPropertyValue(Object object, Object value) {
        EObject eObject = (EObject)object;
        EditingDomain editingDomain = this.getEditingDomain(object);
        if (this.parentReferences != null) {
            int i;
            Command removeCommand = null;
            for (i = 0; i < this.parentReferences.length; ++i) {
                Object oldValue = eObject.eGet(this.parentReferences[i]);
                if (oldValue == null) continue;
                EReference parentReference = this.parentReferences[i];
                if (oldValue == value) {
                    return;
                }
                if (parentReference.getEType().isInstance(value)) {
                    if (editingDomain == null) {
                        eObject.eSet(parentReference, value);
                    } else {
                        editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                    }
                    return;
                }
                if (editingDomain == null) {
                    eObject.eSet(parentReference, null);
                    break;
                }
                removeCommand = SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, null);
                break;
            }
            for (i = 0; i < this.parentReferences.length; ++i) {
                EReference parentReference = this.parentReferences[i];
                if (!parentReference.getEType().isInstance(value)) continue;
                if (editingDomain == null) {
                    eObject.eSet(this.parentReferences[i], value);
                } else if (removeCommand != null) {
                    CompoundCommand compoundCommand = new CompoundCommand(Integer.MIN_VALUE);
                    compoundCommand.append(removeCommand);
                    compoundCommand.append(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                    editingDomain.getCommandStack().execute(compoundCommand);
                } else {
                    editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                }
                break;
            }
        } else if (editingDomain == null) {
            eObject.eSet(this.feature, value);
        } else {
            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), this.feature, value));
        }
    }

    @Override
    public Object getFeature(Object object) {
        if (this.feature != null) {
            return this.feature;
        }
        if (this.parentReferences != null) {
            return this.parentReferences;
        }
        return null;
    }

    @Override
    public boolean isMany(Object object) {
        return this.parentReferences == null && this.feature != null && this.feature.isMany();
    }

    @Override
    public Collection<?> getChoiceOfValues(Object object) {
        return this.getComboBoxObjects(object);
    }

    @Override
    public boolean isMultiLine(Object object) {
        return this.multiLine;
    }

    @Override
    public boolean isSortChoices(Object object) {
        return this.sortChoices;
    }

    protected class ItemDelegator
    extends AdapterFactoryItemDelegator {
        protected ResourceLocator resourceLocator;

        public ItemDelegator(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public ItemDelegator(AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
            super(adapterFactory);
            this.resourceLocator = resourceLocator;
        }

        @Override
        public String getText(Object object) {
            EDataType eDataType;
            if (ItemPropertyDescriptor.this.feature instanceof EAttribute && (eDataType = ((EAttribute)ItemPropertyDescriptor.this.feature).getEAttributeType()).isSerializable() && (eDataType != EcorePackage.Literals.EJAVA_OBJECT || !ItemPropertyDescriptor.this.feature.isTransient())) {
                if (ItemPropertyDescriptor.this.isMany(object) && object instanceof List) {
                    StringBuffer result = new StringBuffer();
                    Iterator i = ((List)object).iterator();
                    while (i.hasNext()) {
                        Object value = i.next();
                        result.append(this.convert(eDataType, value));
                        if (!i.hasNext()) continue;
                        result.append(", ");
                    }
                    return result.toString();
                }
                if (eDataType.isInstance(object)) {
                    return this.convert(eDataType, object);
                }
            }
            return super.getText(object);
        }

        protected String convert(EDataType eDataType, Object value) {
            if (this.resourceLocator != null) {
                if (eDataType instanceof EEnum) {
                    try {
                        return this.resourceLocator.getString("_UI_" + eDataType.getName() + "_" + ((Enumerator)value).getName() + "_literal");
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                } else if (value instanceof Boolean) {
                    try {
                        return this.resourceLocator.getString(Boolean.TRUE.equals(value) ? "_UI_Boolean_true_literal" : "_UI_Boolean_false_literal");
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
            return this.crop(EcoreUtil.convertToString(eDataType, value));
        }

        protected String crop(String text) {
            if (text != null) {
                char[] chars = text.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (!Character.isISOControl(chars[i])) continue;
                    return text.substring(0, i) + "...";
                }
            }
            return text;
        }
    }

    public static class PropertyValueWrapper
    implements IItemLabelProvider,
    IItemPropertySource {
        protected Object object;
        protected Object propertyValue;
        protected Object nestedPropertySource;
        protected AdapterFactoryItemDelegator itemDelegator;

        public PropertyValueWrapper(AdapterFactory adapterFactory, Object object, Object propertyValue, Object nestedPropertySource) {
            this.object = object;
            this.propertyValue = propertyValue;
            this.nestedPropertySource = nestedPropertySource;
            this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
        }

        @Override
        public String getText(Object thisObject) {
            return this.itemDelegator.getText(this.propertyValue);
        }

        @Override
        public List<IItemPropertyDescriptor> getPropertyDescriptors(Object thisObject) {
            List<IItemPropertyDescriptor> list = this.itemDelegator.getPropertyDescriptors(this.nestedPropertySource);
            if (list != null) {
                ArrayList<IItemPropertyDescriptor> result = new ArrayList<IItemPropertyDescriptor>(list.size());
                for (IItemPropertyDescriptor itemPropertyDescriptor : list) {
                    result.add(this.createPropertyDescriptorDecorator(this.nestedPropertySource, itemPropertyDescriptor));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        public IItemPropertyDescriptor getPropertyDescriptor(Object thisObject, Object propertyId) {
            return this.createPropertyDescriptorDecorator(this.nestedPropertySource, this.itemDelegator.getPropertyDescriptor(this.nestedPropertySource, propertyId));
        }

        protected IItemPropertyDescriptor createPropertyDescriptorDecorator(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            return null;
        }
    }
}

