/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ro.sync.emf.common.notify.Adapter;
import ro.sync.emf.common.notify.AdapterFactory;
import ro.sync.emf.common.notify.Notifier;
import ro.sync.emf.common.util.UniqueEList;
import ro.sync.emf.ecore.EClass;
import ro.sync.emf.ecore.EObject;
import ro.sync.emf.ecore.EPackage;
import ro.sync.emf.ecore.EcoreFactory;
import ro.sync.emf.edit.provider.ComposeableAdapterFactory;

public class ComposedAdapterFactory
implements AdapterFactory,
ComposeableAdapterFactory {
    protected List<AdapterFactory> adapterFactories = new ArrayList<AdapterFactory>();
    protected ComposedAdapterFactory parentAdapterFactory;
    private static final Object ANY_OBJECT = new Object();
    private static final Object ANY_EOBJECT = EcoreFactory.eINSTANCE.createEObject();

    public ComposedAdapterFactory() {
    }

    public ComposedAdapterFactory(AdapterFactory adapterFactory) {
        this.addAdapterFactory(adapterFactory);
    }

    public ComposedAdapterFactory(AdapterFactory[] adapterFactories) {
        for (int i = 0; i < adapterFactories.length; ++i) {
            this.addAdapterFactory(adapterFactories[i]);
        }
    }

    public ComposedAdapterFactory(Collection<? extends AdapterFactory> adapterFactories) {
        for (AdapterFactory adapterFactory : adapterFactories) {
            this.addAdapterFactory(adapterFactory);
        }
    }

    @Override
    public boolean isFactoryForType(Object type) {
        for (AdapterFactory adapterFactory : this.adapterFactories) {
            if (!adapterFactory.isFactoryForType(type)) continue;
            return true;
        }
        return false;
    }

    public AdapterFactory getFactoryForType(Object type) {
        return this.getFactoryForTypes(Collections.singleton(type));
    }

    public AdapterFactory getFactoryForTypes(Collection<?> types) {
        AdapterFactory result = null;
        block0: for (AdapterFactory factory : this.adapterFactories) {
            if (factory instanceof ComposedAdapterFactory) {
                AdapterFactory candidate = ((ComposedAdapterFactory)factory).getFactoryForTypes(types);
                if (candidate == null) continue;
                if (!candidate.isFactoryForType(ANY_EOBJECT) && !candidate.isFactoryForType(ANY_OBJECT)) {
                    return candidate;
                }
                if (result != null) continue;
                result = candidate;
                continue;
            }
            for (Object type : types) {
                if (factory.isFactoryForType(type)) continue;
                continue block0;
            }
            if (!factory.isFactoryForType(ANY_EOBJECT) && !factory.isFactoryForType(ANY_OBJECT)) {
                return factory;
            }
            if (result != null) continue;
            result = factory;
        }
        return result == null ? this.delegatedGetFactoryForTypes(types) : result;
    }

    protected AdapterFactory delegatedGetFactoryForTypes(Collection<?> types) {
        return null;
    }

    @Override
    public Object adapt(Object target, Object type) {
        Object adapter = target;
        if (target instanceof Notifier) {
            adapter = this.adapt((Notifier)target, type);
        }
        if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
            return adapter;
        }
        return null;
    }

    @Override
    public Adapter adapt(Notifier target, Object type) {
        return this.adapt(target, type, false);
    }

    protected Adapter adapt(Notifier target, Object type, boolean isNew) {
        Adapter result = null;
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            EClass eClass = eObject.eClass();
            if (eClass != null) {
                AdapterFactory delegateAdapterFactory;
                EPackage ePackage = eClass.getEPackage();
                ArrayList<Object> types = new ArrayList<Object>();
                types.add(ePackage);
                if (type != null) {
                    types.add(type);
                }
                if ((delegateAdapterFactory = this.getFactoryForTypes(types)) != null) {
                    Adapter adapter = result = isNew ? delegateAdapterFactory.adaptNew(target, type) : delegateAdapterFactory.adapt(target, type);
                }
                if (result == null) {
                    HashSet<EPackage> failedPackageSet = new HashSet<EPackage>();
                    failedPackageSet.add(ePackage);
                    UniqueEList.FastCompare<EClass> allSuperTypes = new UniqueEList.FastCompare<EClass>(eClass.getESuperTypes());
                    for (int i = 0; i < allSuperTypes.size(); ++i) {
                        EClass eSuperType = (EClass)allSuperTypes.get(i);
                        EPackage eSupertypePackage = eSuperType.getEPackage();
                        if (failedPackageSet.add(eSupertypePackage)) {
                            ArrayList<Object> superTypes = new ArrayList<Object>();
                            superTypes.add(eSupertypePackage);
                            if (type != null) {
                                superTypes.add(type);
                            }
                            if ((delegateAdapterFactory = this.getFactoryForTypes(superTypes)) != null) {
                                Adapter adapter = result = isNew ? delegateAdapterFactory.adaptNew(target, type) : delegateAdapterFactory.adapt(target, type);
                                if (result != null) break;
                            }
                        }
                        allSuperTypes.addAll(eSuperType.getESuperTypes());
                    }
                }
            }
        } else {
            result = isNew ? this.adapt(target, type, new HashSet<Object>(), target.getClass(), true) : this.adapt(target, type, new HashSet<Object>(), target.getClass());
        }
        return result;
    }

    protected Adapter adapt(Notifier target, Object type, Collection<Object> failedPackages, Class<?> javaClass) {
        return this.adapt(target, type, failedPackages, javaClass, false);
    }

    protected Adapter adapt(Notifier target, Object type, Collection<Object> failedPackages, Class<?> javaClass, boolean isNew) {
        Adapter result = null;
        Package javaPackage = javaClass.getPackage();
        if (failedPackages.add(javaPackage)) {
            AdapterFactory delegateAdapterFactory;
            ArrayList<Object> types = new ArrayList<Object>();
            types.add(javaPackage);
            if (type != null) {
                types.add(type);
            }
            if ((delegateAdapterFactory = this.getFactoryForTypes(types)) != null) {
                Adapter adapter = result = isNew ? delegateAdapterFactory.adaptNew(target, type) : delegateAdapterFactory.adapt(target, type);
            }
        }
        if (result == null) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass != null) {
                result = this.adapt(target, type, failedPackages, javaClass.getSuperclass(), isNew);
            }
            if (result == null) {
                Class<?>[] interfaces = javaClass.getInterfaces();
                for (int i = 0; i < interfaces.length && (result = this.adapt(target, type, failedPackages, interfaces[i], isNew)) == null; ++i) {
                }
            }
        }
        return result;
    }

    @Override
    public Adapter adaptNew(Notifier target, Object type) {
        return this.adapt(target, type, true);
    }

    @Override
    public void adaptAllNew(Notifier target) {
        for (AdapterFactory adapterFactory : this.adapterFactories) {
            if (!adapterFactory.isFactoryForType(target)) continue;
            adapterFactory.adaptAllNew(target);
        }
    }

    public void insertAdapterFactory(AdapterFactory adapterFactory) {
        if (!this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.add(0, adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
            }
        }
    }

    public void addAdapterFactory(AdapterFactory adapterFactory) {
        if (!this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.add(adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
            }
        }
    }

    public void removeAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.remove(adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(null);
            }
        }
    }

    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public static interface Descriptor {
        public AdapterFactory createAdapterFactory();
    }
}

