/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.ecore.xml.namespace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ro.sync.emf.common.util.Enumerator;

public enum SpaceType implements Enumerator
{
    DEFAULT_LITERAL(0, "default", "default"),
    PRESERVE_LITERAL(1, "preserve", "preserve");

    public static final int DEFAULT = 0;
    public static final int PRESERVE = 1;
    private static final SpaceType[] VALUES_ARRAY;
    public static final List<SpaceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SpaceType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SpaceType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SpaceType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SpaceType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SpaceType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_LITERAL;
            }
            case 1: {
                return PRESERVE_LITERAL;
            }
        }
        return null;
    }

    private SpaceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SpaceType[]{DEFAULT_LITERAL, PRESERVE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

