/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.ecore.resource.impl;

import java.util.List;
import java.util.Map;
import ro.sync.emf.common.util.BasicEList;
import ro.sync.emf.common.util.BasicEMap;
import ro.sync.emf.common.util.URI;
import ro.sync.emf.ecore.resource.impl.URIConverterImpl;

public class URIMappingRegistryImpl
extends BasicEMap<URI, URI> {
    private static final long serialVersionUID = 1L;
    public static final URIMappingRegistryImpl INSTANCE = new URIMappingRegistryImpl();
    protected BasicEList<List<BasicEMap.Entry<URI, URI>>> prefixMaps = new BasicEList();

    @Override
    protected BasicEMap.Entry<URI, URI> newEntry(int hash, URI key, URI value) {
        this.validateKey(key);
        this.validateValue(value);
        return new MappingEntryImpl(hash, key, value);
    }

    public URI getURI(URI uri) {
        URI result = (URI)this.get(uri);
        if (result == null) {
            if (this.prefixMaps != null) {
                for (int i = Math.min(this.prefixMaps.size() - 1, uri.segmentCount()); i >= 0; --i) {
                    List<BasicEMap.Entry<URI, URI>> prefixes = this.prefixMaps.get(i);
                    for (int j = prefixes.size() - 1; j >= 0; --j) {
                        BasicEMap.Entry<URI, URI> entry = prefixes.get(j);
                        result = uri.replacePrefix((URI)entry.getKey(), (URI)entry.getValue());
                        if (result == null) continue;
                        return result;
                    }
                }
            }
            result = this.delegatedGetURI(uri);
        }
        return result;
    }

    protected URI delegatedGetURI(URI uri) {
        return uri;
    }

    @Override
    public Map<URI, URI> map() {
        if (this.view == null) {
            this.view = new BasicEMap.View();
        }
        if (this.view.map == null) {
            this.view.map = new URIMapImpl();
        }
        return this.view.map;
    }

    @Override
    protected void validateKey(URI key) {
    }

    @Override
    protected void validateValue(URI value) {
    }

    @Override
    protected void didAdd(BasicEMap.Entry<URI, URI> entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int length = ((URI)entry.getKey()).segmentCount();
            if (this.prefixMaps == null) {
                this.prefixMaps = new BasicEList();
            }
            for (int i = this.prefixMaps.size() - 1; i <= length; ++i) {
                this.prefixMaps.add(new BasicEList());
            }
            this.prefixMaps.get(length).add(entry);
        }
    }

    @Override
    protected void didModify(BasicEMap.Entry<URI, URI> entry, URI oldValue) {
        this.didRemove(entry);
        ((MappingEntryImpl)entry).determineEntryType();
        this.didAdd(entry);
    }

    @Override
    protected void didRemove(BasicEMap.Entry<URI, URI> entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int length = ((URI)entry.getKey()).segmentCount();
            this.prefixMaps.get(length).remove(entry);
        }
    }

    @Override
    protected void didClear(BasicEList<BasicEMap.Entry<URI, URI>>[] oldEntryData) {
        this.prefixMaps = null;
    }

    protected class MappingEntryImpl
    extends BasicEMap.EntryImpl {
        public boolean isPrefixMapEntry;

        public MappingEntryImpl(int hash, URI key, URI value) {
            super(URIMappingRegistryImpl.this, hash, key, value);
            this.determineEntryType();
        }

        public void determineEntryType() {
            this.isPrefixMapEntry = ((URI)this.key).isPrefix() && ((URI)this.value).isPrefix();
        }
    }

    protected class URIMapImpl
    extends BasicEMap.DelegatingMap
    implements URIConverterImpl.URIMap {
        public URIMapImpl() {
            super(URIMappingRegistryImpl.this);
        }

        @Override
        public URI getURI(URI uri) {
            return URIMappingRegistryImpl.this.getURI(uri);
        }
    }
}

