/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import ro.sync.emf.common.util.URI;
import ro.sync.emf.ecore.resource.ContentHandler;
import ro.sync.emf.ecore.resource.impl.ContentHandlerImpl;
import ro.sync.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;

public class PlatformContentHandlerImpl
extends ContentHandlerImpl {
    protected QualifiedName getQualifiedName(String property) {
        int index = property.lastIndexOf(":");
        if (index == -1) {
            return new QualifiedName(null, property);
        }
        return new QualifiedName(property.substring(0, index), property.substring(index + 1));
    }

    protected Object getDescriptionValue(QualifiedName qualifiedName, Object value) {
        if (value == null) {
            return null;
        }
        if (IContentDescription.BYTE_ORDER_MARK.equals((Object)qualifiedName)) {
            for (ContentHandler.ByteOrderMark byteOrderMarker : ContentHandler.ByteOrderMark.values()) {
                if (value != byteOrderMarker.bytes()) continue;
                return byteOrderMarker;
            }
            return null;
        }
        return value;
    }

    @Override
    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        IContentDescription contentDescription = uri.isPlatformResource() && PlatformResourceURIHandlerImpl.workspaceRoot != null ? PlatformResourceURIHandlerImpl.WorkbenchHelper.getContentDescription(uri.toPlatformString(true), options) : Platform.getContentTypeManager().getDescriptionFor(inputStream, uri.lastSegment(), IContentDescription.ALL);
        if (contentDescription == null) {
            return INVALID_CONTENT_DESCRIPTION;
        }
        Map<String, Object> result = PlatformContentHandlerImpl.createContentDescription(ContentHandler.Validity.VALID);
        result.put("ro.sync.emf.ecore:contentType", contentDescription.getContentType().getId());
        Set<String> requestedProperties = this.getRequestedProperties(options);
        if (requestedProperties != null) {
            for (String property : requestedProperties) {
                Object value;
                QualifiedName qualifiedName = this.getQualifiedName(property);
                if (qualifiedName == null || (value = this.getDescriptionValue(qualifiedName, contentDescription.getProperty(qualifiedName))) == null) continue;
                result.put(property, value);
            }
        }
        return result;
    }
}

