/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.ant.core.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.ant.core.project.AntProjectHelper;

public class AntUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)AntUtil.class.getName());

    public static String getSystemID(Location location) {
        String fileName;
        String systemID = null;
        if (location != null && (fileName = location.getFileName()) != null) {
            URL url = null;
            try {
                url = new URL(fileName);
            }
            catch (MalformedURLException e) {
                File file = new File(fileName);
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    logger.warn("Incorrect file URL: " + fileName, (Throwable)e1);
                }
            }
            if (url != null) {
                systemID = url.toExternalForm();
            }
        }
        return systemID;
    }

    public static void prepareProject(AntProject project, String systemID, AntProjectHelper helper) {
        project.setCoreLoader(Thread.currentThread().getContextClassLoader());
        project.setInputHandler((InputHandler)new DefaultInputHandler());
        project.fireBuildStarted();
        AntUtil.setProperties(systemID, project);
        project.setKeepGoingMode(false);
        project.addReference("ant.projectHelper", (Object)helper);
    }

    private static void setProperties(String systemID, AntProject project) {
        project.init();
        project.setUserProperty("ant.file.type", "url");
        project.setUserProperty("ant.file", systemID);
        project.setProperty("ant.file.type", "url");
        project.setProperty("ant.file", systemID);
    }

    public static File getFile(String systemID) {
        File file = null;
        if (systemID != null) {
            try {
                URL u = new URL(systemID);
                if (AntUtil.isFile(u)) {
                    String path = URLDecoder.decode(u.getPath(), "UTF-8");
                    file = new File(path);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return file;
    }

    private static boolean isFile(URL u) {
        return "file".equals(u.getProtocol());
    }

    public static boolean isFile(String systemID) {
        try {
            return AntUtil.isFile(new URL(systemID));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

