/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.ant.core.project.handlers;

import org.apache.tools.ant.Target;
import org.apache.tools.ant.helper.AntXMLContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.ant.core.project.AntProjectHandler;
import ro.sync.exml.ant.core.project.handlers.AntHandlerWrapper;
import ro.sync.exml.ant.core.util.AntUtil;

public class AntContentHandler
extends AntHandlerWrapper<ContentHandler>
implements ContentHandler {
    private final AntProject project;
    private boolean shouldFixCurrentTarget = false;

    public AntContentHandler(AntProject project, AntProjectHandler projectHandler, ContentHandler ... wrappedHandlers) {
        super(projectHandler, wrappedHandlers);
        this.project = project;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        for (ContentHandler handler : this.wrappedHandlers) {
            handler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.startDocument();
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void endDocument() {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.endDocument();
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.startPrefixMapping(prefix, uri);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.endPrefixMapping(prefix);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if ("project".equals(localName)) {
            this.shouldFixCurrentTarget = true;
            this.correctBasedir(atts);
        } else {
            AntXMLContext antXMLContext;
            if (this.shouldFixCurrentTarget && (antXMLContext = this.project.getAntXMLContext()) != null && !antXMLContext.isIgnoringProjectTag() && antXMLContext.getCurrentTarget() == null) {
                Target implicitTarget = antXMLContext.getImplicitTarget();
                this.project.addTarget("", implicitTarget);
                antXMLContext.setCurrentTarget(implicitTarget);
            }
            this.shouldFixCurrentTarget = false;
        }
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.startElement(uri, localName, qName, atts);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    private void correctBasedir(Attributes atts) {
        String systemID;
        String basedirProp;
        String basedir = null;
        if (atts != null) {
            basedir = atts.getValue("basedir");
        }
        if (!(basedir != null || (basedirProp = this.project.getUserProperty("basedir")) != null || (systemID = this.project.getUserProperty("ant.file")) != null && AntUtil.isFile(systemID))) {
            this.project.setUserProperty("basedir", ".");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.endElement(uri, localName, qName);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.characters(ch, start, length);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.ignorableWhitespace(ch, start, length);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.processingInstruction(target, data);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void skippedEntity(String name) {
        for (ContentHandler handler : this.wrappedHandlers) {
            try {
                handler.skippedEntity(name);
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }
}

