/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.ant.core.project;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import ro.sync.exml.ant.core.project.AntParserInput;

public class AntProjectHandler {
    private final String initialSystemID;
    private final Stack<String> systemIDsStack = new Stack();
    private final Set<String> parsedSystemIDs = new HashSet<String>(1);

    public AntProjectHandler(String initialSystemID) {
        this.initialSystemID = initialSystemID;
    }

    public String getSystemID() {
        if (this.systemIDsStack.size() > 0) {
            String systemID = this.systemIDsStack.peek();
            return systemID != null ? systemID : this.initialSystemID;
        }
        return this.initialSystemID;
    }

    public void error(Exception e) {
    }

    public void parsingStarted(AntParserInput parserInput) {
        String systemID = parserInput.getSystemID();
        this.parsedSystemIDs.add(systemID);
        this.systemIDsStack.push(systemID);
    }

    public void parsingEnded() {
        if (this.systemIDsStack.size() > 0) {
            this.systemIDsStack.pop();
        }
    }

    public boolean isInImports() {
        return this.systemIDsStack.size() > 1;
    }

    public boolean isParsed(AntParserInput parserInput) {
        return this.parsedSystemIDs.contains(parserInput.getSystemID());
    }
}

