/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.ant.core.project;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.URLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import ro.sync.exml.ant.core.project.AntParserInput;

public class AntParserInputResolver {
    private static final Logger logger = LoggerFactory.getLogger((String)AntParserInputResolver.class.getName());
    private final URIResolver uriResolver;

    public AntParserInputResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public AntParserInput resolveInput(Object source) throws Exception {
        AntParserInput parserInput = null;
        if (source instanceof AntParserInput) {
            parserInput = (AntParserInput)source;
        } else if (source instanceof File) {
            parserInput = this.getParserInput((File)source);
        } else if (source instanceof URL) {
            parserInput = this.getParserInput((URL)source);
        } else if (source instanceof Resource) {
            FileProvider fp = (FileProvider)((Resource)source).as(FileProvider.class);
            if (fp != null) {
                parserInput = this.getParserInput(fp.getFile());
            } else {
                URLProvider up = (URLProvider)((Resource)source).as(URLProvider.class);
                if (up != null) {
                    parserInput = this.getParserInput(up.getURL());
                }
            }
        }
        return parserInput;
    }

    private AntParserInput getParserInput(URL url) throws IOException {
        if (url != null) {
            String systemID = url.toExternalForm();
            Reader reader = this.resolveSystemID(systemID);
            if (reader == null) {
                reader = new InputStreamReader(url.openStream());
            }
            return new AntParserInput(reader, systemID);
        }
        return null;
    }

    private AntParserInput getParserInput(File file) throws IOException {
        if (file != null) {
            String systemID = file.toURI().toASCIIString();
            Reader reader = this.resolveSystemID(systemID);
            if (reader == null) {
                reader = new FileReader(file);
            }
            return new AntParserInput(reader, systemID);
        }
        return null;
    }

    private Reader resolveSystemID(String systemID) {
        Reader reader;
        block6: {
            reader = null;
            if (this.uriResolver != null) {
                try {
                    Source source = this.uriResolver.resolve(systemID, null);
                    if (source instanceof SAXSource) {
                        SAXSource saxSource = (SAXSource)source;
                        InputSource inputSource = saxSource.getInputSource();
                        if (inputSource != null) {
                            reader = inputSource.getCharacterStream();
                        }
                    } else {
                        logger.warn("Not a SAXSource or null --> Source = " + source);
                    }
                }
                catch (TransformerException e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
        return reader;
    }
}

