/*
 * Decompiled with CFR 0.152.
 */
package org.json.oxygen;

import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.util.XMLChar;
import org.json.JSONArray;
import org.json.JSONLocation;
import org.json.JSONObject;
import org.json.JSONParserConfiguration;
import org.json.JSONTokener;
import org.json.oxygen.JSONType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

public final class JSONUtil {
    public static final String OXY_TYPE = "oxy_Type";
    public static final String LOCATION_START_LINE = "startLine";
    public static final String LOCATION_END_LINE = "endLine";
    public static final String LOCATION_START_COL = "startCol";
    public static final String LOCATION_END_COL = "endCol";
    public static final String XPATH_LOCATION_PREFIX = "oxyXPathLoc";
    public static final String XPATH_LOCATION_NAMESPACE = "http://oxygenxml.com/xpath/location";
    public static final String PREFIX_FOR_ESCAPE = "_X";
    public static final char SUFFIX_FOR_ESCAPE_CHAR = '_';
    public static final String SUFFIX_FOR_ESCAPE = Character.toString('_');
    private static final String UNESCAPE_REGEX = "_X([0-9A-Fa-f]+)_";
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("_X([0-9A-Fa-f]+)_");
    public static final String EMPTY_KEY = "EMPTY_KEY";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";
    public static final String STRING = "string";

    private JSONUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Object createJsonInstance(String content) {
        return JSONUtil.createJsonInstance(new JSONTokener(content), false);
    }

    public static Object createJsonInstance(Reader reader) {
        return JSONUtil.createJsonInstance(new JSONTokener(reader), false);
    }

    public static Object createJsonInstance(JSONTokener jsonInstanceTokener, boolean isForSerialization) {
        JSONType jsonType = JSONUtil.getType(jsonInstanceTokener);
        Object instanceObject = null;
        switch (jsonType) {
            case OBJECT_TYPE: {
                instanceObject = new JSONObject(jsonInstanceTokener, new JSONParserConfiguration(), true, isForSerialization);
                break;
            }
            case ARRAY_TYPE: {
                instanceObject = new JSONArray(jsonInstanceTokener, true, isForSerialization);
                break;
            }
            case SIMPLE_TYPE: {
                instanceObject = jsonInstanceTokener.nextValue(false, isForSerialization);
            }
        }
        return instanceObject;
    }

    public static JSONType getType(String jsonContent) {
        return JSONUtil.getType(new JSONTokener(jsonContent));
    }

    public static JSONType getType(JSONTokener jsonTokener) {
        char nextClean = jsonTokener.nextClean();
        if (nextClean != '\u0000') {
            jsonTokener.back();
        }
        JSONType type = nextClean == '{' ? JSONType.OBJECT_TYPE : (nextClean == '[' ? JSONType.ARRAY_TYPE : JSONType.SIMPLE_TYPE);
        return type;
    }

    public static boolean isComplexValue(Object value) {
        return value instanceof Enum || value instanceof JSONObject || value instanceof JSONArray || value instanceof Map || value instanceof Collection || value.getClass().isArray();
    }

    public static String getQuotedString(Object value) {
        return "\"" + String.valueOf(value) + "\"";
    }

    private static void appendXPathLocationPrefixed(String locationDataField, int value, StringBuilder sb) {
        sb.append(' ').append(XPATH_LOCATION_PREFIX).append(':').append(locationDataField).append('=').append(JSONUtil.getQuotedString(value));
    }

    public static String generateLocationInfo(JSONLocation jsonLocation) {
        String locInfo = "";
        if (jsonLocation != null) {
            StringBuilder sb = new StringBuilder();
            JSONUtil.appendXPathLocationPrefixed(LOCATION_START_LINE, jsonLocation.getLine(), sb);
            JSONUtil.appendXPathLocationPrefixed(LOCATION_START_COL, jsonLocation.getColumn(), sb);
            JSONUtil.appendXPathLocationPrefixed(LOCATION_END_LINE, jsonLocation.getEndLine(), sb);
            JSONUtil.appendXPathLocationPrefixed(LOCATION_END_COL, jsonLocation.getEndColumn(), sb);
            locInfo = sb.toString();
        }
        return locInfo;
    }

    private static String getValueTypeAsString(Object value) {
        String oxyType = null;
        if (value instanceof Boolean) {
            oxyType = "Boolean";
        } else if (value instanceof Number) {
            oxyType = "Number";
        } else if (value == JSONObject.NULL) {
            oxyType = "Null";
        }
        return oxyType;
    }

    public static String getValueTypeAsAttribute(Object value, boolean addAttrs) {
        String oxyType = null;
        if (addAttrs) {
            oxyType = JSONUtil.getValueTypeAsString(value);
        }
        return oxyType == null ? "" : " oxy_Type=" + JSONUtil.getQuotedString(oxyType);
    }

    public static String appendIndexIfNecessary(String toAdd, JSONObject context) {
        if (context.has((String)toAdd)) {
            String[] previousKey = new String[1];
            context.keys().forEachRemaining(t -> {
                previousKey[0] = t;
            });
            if (!previousKey[0].equals(toAdd)) {
                if (!context.has((String)(toAdd = (String)toAdd + "#") + "1")) {
                    toAdd = (String)toAdd + "1";
                } else {
                    int index = 1;
                    while (true) {
                        if (context.has((String)toAdd + index) && !context.has((String)toAdd + (index + 1))) {
                            toAdd = (String)toAdd + (previousKey[0].equals((String)toAdd + index) ? index : index + 1);
                            break;
                        }
                        ++index;
                    }
                }
            }
        }
        return toAdd;
    }

    public static String escapeIllegalXMLChars(String key) {
        int len = key.length();
        StringBuilder sb = new StringBuilder(len);
        if (len == 0) {
            sb.append(EMPTY_KEY);
        } else {
            for (int i = 0; i < len; ++i) {
                char ch = key.charAt(i);
                if (ch == ':') {
                    JSONUtil.appendEscapedChar(ch, sb);
                    continue;
                }
                if (i == 0) {
                    if (XMLChar.isNameStart((int)ch)) {
                        sb.append(ch);
                        continue;
                    }
                    if (XMLChar.isName((int)ch)) {
                        sb.append('_').append(ch);
                        continue;
                    }
                    JSONUtil.appendEscapedChar(ch, sb);
                    continue;
                }
                if (XMLChar.isName((int)ch)) {
                    sb.append(ch);
                    continue;
                }
                JSONUtil.appendEscapedChar(ch, sb);
            }
        }
        return sb.toString();
    }

    private static void appendEscapedChar(char ch, StringBuilder sb) {
        sb.append(PREFIX_FOR_ESCAPE).append(Integer.toHexString(ch)).append('_');
    }

    public static String unescapeXMLTagName(String tagName) {
        char ch;
        if (tagName.isEmpty() || tagName.equals(EMPTY_KEY)) {
            return "";
        }
        if (tagName.length() > 1 && tagName.charAt(0) == '_' && (ch = tagName.charAt(1)) != 'X' && !XMLChar.isNameStart((int)ch)) {
            tagName = tagName.substring(1);
        }
        Matcher matcher = UNESCAPE_PATTERN.matcher(tagName);
        while (matcher.find()) {
            String currentGroup = matcher.group(0);
            String hexaString = currentGroup.substring(PREFIX_FOR_ESCAPE.length(), currentGroup.length() - 1);
            try {
                char hexaChar = (char)NumberParserUtil.parseInt((String)hexaString, (int)16);
                tagName = tagName.replaceFirst(currentGroup, "\\" + hexaChar);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return tagName;
    }

    public static Object getDefaultValue(Object jsonType) {
        if ("Number".equals(jsonType)) {
            return 0;
        }
        if ("Boolean".equals(jsonType)) {
            return false;
        }
        if ("Null".equals(jsonType)) {
            return null;
        }
        return "\"\"";
    }
}

