/*
 * Decompiled with CFR 0.152.
 */
package org.xqdoc.conversion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.xqdoc.conversion.XQDocRuntimeException;
import org.xqdoc.conversion.XQDocXML;

public class XQDocComment {
    private StringBuffer[] xqDocCommentBlock = new StringBuffer[9];
    private int xqDocCommentState = -1;
    private String xqDocComment;
    private static final String XQDOC_COMMENT_TAG = "comment";
    private static final int XQDOC_STATE_DESCRIPTION = 0;
    private static final int XQDOC_STATE_AUTHOR = 1;
    private static final String XQDOC_COMMENT_AUTHOR = "@author";
    private static final int XQDOC_STATE_VERSION = 2;
    private static final String XQDOC_COMMENT_VERSION = "@version";
    private static final int XQDOC_STATE_PARAM = 3;
    private static final String XQDOC_COMMENT_PARAM = "@param";
    private static final int XQDOC_STATE_RETURN = 4;
    private static final String XQDOC_COMMENT_RETURN = "@return";
    private static final int XQDOC_STATE_ERROR = 5;
    private static final String XQDOC_COMMENT_ERROR = "@error";
    private static final int XQDOC_STATE_DEPRECATED = 6;
    private static final String XQDOC_COMMENT_DEPRECATED = "@deprecated";
    private static final int XQDOC_STATE_SEE = 7;
    private static final String XQDOC_COMMENT_SEE = "@see";
    private static final int XQDOC_STATE_SINCE = 8;
    private static final String XQDOC_COMMENT_SINCE = "@since";
    private static final int XQDOC_STATE_LAST = 9;
    private static final String BEGIN_XQDOC_COMMENT = "(:~";
    private static final String END_XQDOC_COMMENT = ":)";
    private static final String[] XQDOC_STATE_TAG = new String[]{"description", "author", "version", "param", "return", "error", "deprecated", "see", "since"};

    public void clear() {
        this.xqDocComment = null;
        this.xqDocCommentState = -1;
        int i = 0;
        while (i < this.xqDocCommentBlock.length) {
            this.xqDocCommentBlock[i] = new StringBuffer(512);
            ++i;
        }
    }

    public void setComment(String comment) {
        this.xqDocComment = comment;
    }

    public StringBuffer getXML() {
        StringBuffer sb = new StringBuffer(1024);
        if (this.xqDocComment != null) {
            this.buildXQDocCommentSection();
            sb.append(XQDocXML.buildBeginTag(XQDOC_COMMENT_TAG));
            int i = 0;
            while (i < this.xqDocCommentBlock.length) {
                sb.append(this.xqDocCommentBlock[i]);
                ++i;
            }
            sb.append(XQDocXML.buildEndTag(XQDOC_COMMENT_TAG));
        }
        return sb;
    }

    private void xqDocCommentStateConcat(String line, int index) {
        int last = line.indexOf(END_XQDOC_COMMENT);
        if (last == -1) {
            last = line.length();
        }
        if (index == -1) {
            int i = line.indexOf(BEGIN_XQDOC_COMMENT);
            if (i > -1) {
                this.xqDocCommentBlock[this.xqDocCommentState].append(line.substring(i + BEGIN_XQDOC_COMMENT.length(), last));
            } else if (line.matches("^\\s*:.*")) {
                i = line.indexOf(":");
                if (i < last) {
                    this.xqDocCommentBlock[this.xqDocCommentState].append(line.substring(i + 1, last));
                } else if (last != line.length()) {
                    this.xqDocCommentBlock[this.xqDocCommentState].append(line.substring(0, last));
                }
            } else {
                this.xqDocCommentBlock[this.xqDocCommentState].append(line.substring(0, last));
            }
        } else {
            this.xqDocCommentBlock[this.xqDocCommentState].append(line.substring(index, last));
        }
    }

    private void xqDocCommentStateBegin() {
        this.xqDocCommentBlock[this.xqDocCommentState].append(XQDocXML.buildBeginTag(XQDOC_STATE_TAG[this.xqDocCommentState]));
    }

    private void xqDocCommentStateClose() {
        this.xqDocCommentBlock[this.xqDocCommentState].append(XQDocXML.buildEndTag(XQDOC_STATE_TAG[this.xqDocCommentState]));
    }

    private void buildXQDocCommentSection() throws XQDocRuntimeException {
        try {
            if (this.xqDocComment == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new StringReader(this.xqDocComment));
            String line = null;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
            int i = 0;
            while (i < lines.size()) {
                this.processXQDocLine((String)lines.get(i));
                ++i;
            }
        }
        catch (IOException ex) {
            throw new XQDocRuntimeException("Problems processing the comment block.", ex);
        }
    }

    private void processXQDocLine(String line) {
        int index = line.indexOf(XQDOC_COMMENT_PARAM);
        if (index > -1) {
            this.xqDocCommentStateClose();
            this.xqDocCommentState = 3;
            this.xqDocCommentStateBegin();
            this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_PARAM.length());
        } else {
            index = line.indexOf(XQDOC_COMMENT_RETURN);
            if (index > -1) {
                this.xqDocCommentStateClose();
                this.xqDocCommentState = 4;
                this.xqDocCommentStateBegin();
                this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_RETURN.length());
            } else {
                index = line.indexOf(XQDOC_COMMENT_ERROR);
                if (index > -1) {
                    this.xqDocCommentStateClose();
                    this.xqDocCommentState = 5;
                    this.xqDocCommentStateBegin();
                    this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_ERROR.length());
                } else {
                    index = line.indexOf(XQDOC_COMMENT_DEPRECATED);
                    if (index > -1) {
                        this.xqDocCommentStateClose();
                        this.xqDocCommentState = 6;
                        this.xqDocCommentStateBegin();
                        this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_DEPRECATED.length());
                    } else {
                        index = line.indexOf(XQDOC_COMMENT_SEE);
                        if (index > -1) {
                            this.xqDocCommentStateClose();
                            this.xqDocCommentState = 7;
                            this.xqDocCommentStateBegin();
                            this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_SEE.length());
                        } else {
                            index = line.indexOf(XQDOC_COMMENT_SINCE);
                            if (index > -1) {
                                this.xqDocCommentStateClose();
                                this.xqDocCommentState = 8;
                                this.xqDocCommentStateBegin();
                                this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_SINCE.length());
                            } else {
                                index = line.indexOf(XQDOC_COMMENT_AUTHOR);
                                if (index > -1) {
                                    this.xqDocCommentStateClose();
                                    this.xqDocCommentState = 1;
                                    this.xqDocCommentStateBegin();
                                    this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_AUTHOR.length());
                                } else {
                                    index = line.indexOf(XQDOC_COMMENT_VERSION);
                                    if (index > -1) {
                                        this.xqDocCommentStateClose();
                                        this.xqDocCommentState = 2;
                                        this.xqDocCommentStateBegin();
                                        this.xqDocCommentStateConcat(line, index + XQDOC_COMMENT_VERSION.length());
                                    } else {
                                        if (this.xqDocCommentState == -1) {
                                            this.xqDocCommentState = 0;
                                            this.xqDocCommentStateBegin();
                                        }
                                        this.xqDocCommentStateConcat(line, -1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (line.indexOf(END_XQDOC_COMMENT) > -1) {
            this.xqDocCommentStateClose();
        }
    }
}

