/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xslt;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XSLTNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)XSLTNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = XSLTNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(XSLTNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String nodeNS = context.getNodeNamespace();
            String iconPath = null;
            if ("http://www.w3.org/1999/XSL/Transform".equals(nodeNS)) {
                int index = nodeName.indexOf(":");
                Object imageKey = index == -1 ? nodeName : nodeName.substring(index + 1);
                if ("template".equals(imageKey)) {
                    String matchAttrValue;
                    String nameAttrValue = context.getAttributeValue("name");
                    imageKey = nameAttrValue != null ? ((matchAttrValue = context.getAttributeValue("match")) != null ? (String)imageKey + "@name@match" : (String)imageKey + "@name") : (String)imageKey + "@match";
                }
                iconPath = nameToIconPath.get(imageKey);
                renderingInfo.setIconPath(iconPath);
            }
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "XSLT Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("attribute-set", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLAttributeSet16.png"));
        nameToIconPath.put("character-map", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLCharacterMap16.png"));
        nameToIconPath.put("function", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLFunction16.png"));
        nameToIconPath.put("param", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLParam16.png"));
        nameToIconPath.put("variable", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLVariable16.png"));
        nameToIconPath.put("import", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/Import16.png"));
        nameToIconPath.put("include", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/Include16.png"));
        nameToIconPath.put("key", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLKey16.png"));
        nameToIconPath.put("output", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOutput16.png"));
        nameToIconPath.put("stylesheet", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementStylesheet16.png"));
        nameToIconPath.put("template@name@match", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLNamedMatchTemplate16.png"));
        nameToIconPath.put("template@name", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLNamedTemplate16.png"));
        nameToIconPath.put("template@match", XSLTNodeRendererCustomizer.getImageURL("/images/node-customizer/XSLTemplate16.png"));
    }
}

