/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.TagNodeVisitor;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.XPather;
import org.htmlcleaner.XPatherException;
import org.htmlcleaner.conditional.ITagNodeCondition;
import org.htmlcleaner.conditional.TagAllCondition;
import org.htmlcleaner.conditional.TagNodeAttExistsCondition;
import org.htmlcleaner.conditional.TagNodeAttValueCondition;
import org.htmlcleaner.conditional.TagNodeNameCondition;

public class TagNode
extends TagToken
implements HtmlNode {
    private final LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private final List<BaseToken> children = new ArrayList<BaseToken>();
    private DoctypeToken docType;
    private List<BaseToken> itemsToMove;
    private Map<String, String> nsDeclarations;
    private transient boolean isFormed;
    private boolean autoGenerated;
    private boolean isForeignMarkup;
    private boolean foreignMarkupFlagSet = false;
    private boolean isTrimAttributeValues = true;
    private boolean pruned;
    private final boolean isCopy;

    public TagNode(String string) {
        this(string, false);
    }

    private TagNode(String string, boolean bl) {
        super(string);
        this.isCopy = bl;
    }

    public String getName() {
        if (this.isForeignMarkup) {
            return this.name;
        }
        return this.name == null ? null : this.name.toLowerCase();
    }

    public String getAttributeByName(String string) {
        if (string == null) {
            return null;
        }
        return string != null ? this.getAttributesInLowerCase(false).get(string.toLowerCase()) : null;
    }

    public Map<String, String> getAttributes() {
        return new LinkedHashMap<String, String>(this.attributes);
    }

    public Map<String, String> getAttributesInLowerCase(boolean bl) {
        return this.attributesToLowerCase(bl);
    }

    public void setAttributes(Map<String, String> map) {
        if (this.foreignMarkupFlagSet) {
            this.replaceAttributes(map);
        } else {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                if (Thread.currentThread().isInterrupted()) {
                    this.handleInterruption();
                    return;
                }
                String string2 = string;
                String string3 = map.get(string);
                if (!this.foreignMarkupFlagSet) {
                    for (String string4 : this.attributes.keySet()) {
                        if (!string4.equalsIgnoreCase(string)) continue;
                        string2 = string4;
                    }
                }
                if (linkedHashMap.containsKey(string2)) continue;
                linkedHashMap.put(string2, string3);
            }
            this.replaceAttributes(linkedHashMap);
        }
    }

    private void replaceAttributes(Map<String, String> map) {
        this.attributes.clear();
        this.attributes.putAll(map);
    }

    public boolean hasAttribute(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.attributes.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(String string, String string2) {
        if (string != null) {
            String string3;
            String string4 = string.trim();
            if (!this.isForeignMarkup && this.foreignMarkupFlagSet) {
                string4 = string4.toLowerCase();
            }
            String string5 = string3 = string2 == null ? "" : string2.replaceAll("\\p{Cntrl}", " ");
            if (string4.length() != 0 && !this.attributes.containsKey(string4)) {
                this.attributes.put(string4, string3);
            }
        }
    }

    public void removeAttribute(String string) {
        if (string != null && !"".equals(string.trim())) {
            this.attributes.remove(string.toLowerCase());
        }
    }

    @Deprecated
    public List<TagNode> getChildren() {
        return this.getChildTagList();
    }

    public void setChildren(List<? extends BaseToken> list) {
        this.children.clear();
        this.children.addAll(list);
    }

    public List<? extends BaseToken> getAllChildren() {
        return this.children;
    }

    public List<TagNode> getChildTagList() {
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>();
        for (BaseToken baseToken : this.children) {
            if (!(baseToken instanceof TagNode)) continue;
            arrayList.add((TagNode)baseToken);
        }
        return arrayList;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TagNode[] getChildTags() {
        List<TagNode> list = this.getChildTagList();
        TagNode[] tagNodeArray = new TagNode[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            tagNodeArray[i2] = list.get(i2);
        }
        return tagNodeArray;
    }

    public CharSequence getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (BaseToken baseToken : this.children) {
            if (baseToken instanceof ContentNode) {
                stringBuilder.append(((ContentNode)baseToken).getContent());
                continue;
            }
            if (!(baseToken instanceof TagNode)) continue;
            CharSequence charSequence = ((TagNode)baseToken).getText();
            stringBuilder.append(charSequence);
        }
        return stringBuilder;
    }

    public int getChildIndex(HtmlNode htmlNode) {
        int n2 = 0;
        for (BaseToken baseToken : this.children) {
            if (baseToken == htmlNode) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void insertChild(int n2, HtmlNode htmlNode) {
        this.children.add(n2, (BaseToken)htmlNode);
    }

    public void insertChildBefore(HtmlNode htmlNode, HtmlNode htmlNode2) {
        int n2 = this.getChildIndex(htmlNode);
        if (n2 >= 0) {
            this.insertChild(n2, htmlNode2);
        }
    }

    public void insertChildAfter(HtmlNode htmlNode, HtmlNode htmlNode2) {
        int n2 = this.getChildIndex(htmlNode);
        if (n2 >= 0) {
            this.insertChild(n2 + 1, htmlNode2);
        }
    }

    public DoctypeToken getDocType() {
        return this.docType;
    }

    public void setDocType(DoctypeToken doctypeToken) {
        this.docType = doctypeToken;
    }

    public void addChild(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            this.addChildren((List)object);
        } else if (object instanceof ProxyTagNode) {
            this.children.add(((ProxyTagNode)object).getToken());
        } else if (object instanceof BaseToken) {
            this.children.add((BaseToken)object);
            if (object instanceof TagNode) {
                TagNode tagNode = (TagNode)((Object)object);
                tagNode.parent = this;
            }
        } else {
            throw new RuntimeException("Attempted to add invalid child object to TagNode; class=" + object.getClass());
        }
    }

    public void addChildren(List list) {
        if (list != null) {
            for (Object e2 : list) {
                this.addChild(e2);
            }
        }
    }

    private TagNode findElement(ITagNodeCondition iTagNodeCondition, boolean bl) {
        if (iTagNodeCondition != null) {
            for (BaseToken baseToken : this.children) {
                TagNode tagNode;
                if (!(baseToken instanceof TagNode)) continue;
                TagNode tagNode2 = (TagNode)baseToken;
                if (iTagNodeCondition.satisfy(tagNode2)) {
                    return tagNode2;
                }
                if (!bl || (tagNode = tagNode2.findElement(iTagNodeCondition, bl)) == null) continue;
                return tagNode;
            }
        }
        return null;
    }

    private List<TagNode> findMatchingTagNodes(ITagNodeCondition iTagNodeCondition, boolean bl) {
        LinkedList<TagNode> linkedList = new LinkedList<TagNode>();
        if (iTagNodeCondition == null) {
            return linkedList;
        }
        for (BaseToken baseToken : this.children) {
            List<TagNode> list;
            if (!(baseToken instanceof TagNode)) continue;
            TagNode tagNode = (TagNode)baseToken;
            if (iTagNodeCondition.satisfy(tagNode)) {
                linkedList.add(tagNode);
            }
            if (!bl || (list = tagNode.findMatchingTagNodes(iTagNodeCondition, bl)) == null || list.size() <= 0) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public List<? extends TagNode> getElementList(ITagNodeCondition iTagNodeCondition, boolean bl) {
        return this.findMatchingTagNodes(iTagNodeCondition, bl);
    }

    private TagNode[] getElements(ITagNodeCondition iTagNodeCondition, boolean bl) {
        List<TagNode> list = this.findMatchingTagNodes(iTagNodeCondition, bl);
        TagNode[] tagNodeArray = list == null ? new TagNode[]{} : list.toArray(new TagNode[list.size()]);
        return tagNodeArray;
    }

    public List<? extends TagNode> getAllElementsList(boolean bl) {
        return this.getElementList((ITagNodeCondition)new TagAllCondition(), bl);
    }

    public TagNode[] getAllElements(boolean bl) {
        return this.getElements((ITagNodeCondition)new TagAllCondition(), bl);
    }

    public TagNode findElementByName(String string, boolean bl) {
        return this.findElement((ITagNodeCondition)new TagNodeNameCondition(string), bl);
    }

    public List<? extends TagNode> getElementListByName(String string, boolean bl) {
        return this.getElementList((ITagNodeCondition)new TagNodeNameCondition(string), bl);
    }

    public TagNode[] getElementsByName(String string, boolean bl) {
        return this.getElements((ITagNodeCondition)new TagNodeNameCondition(string), bl);
    }

    public TagNode findElementHavingAttribute(String string, boolean bl) {
        return this.findElement((ITagNodeCondition)new TagNodeAttExistsCondition(string), bl);
    }

    public List<? extends TagNode> getElementListHavingAttribute(String string, boolean bl) {
        return this.getElementList((ITagNodeCondition)new TagNodeAttExistsCondition(string), bl);
    }

    public TagNode[] getElementsHavingAttribute(String string, boolean bl) {
        return this.getElements((ITagNodeCondition)new TagNodeAttExistsCondition(string), bl);
    }

    public TagNode findElementByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.findElement((ITagNodeCondition)new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public List<? extends TagNode> getElementListByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.getElementList((ITagNodeCondition)new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public TagNode[] getElementsByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.getElements((ITagNodeCondition)new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public Object[] evaluateXPath(String string) throws XPatherException {
        return new XPather(string).evaluateAgainstNode(this);
    }

    public boolean removeFromTree() {
        return this.parent != null ? this.parent.removeChild((Object)this) : false;
    }

    public boolean removeChild(Object object) {
        return this.children.remove(object);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    void addItemForMoving(Object object) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList<BaseToken>();
        }
        if (!(object instanceof BaseToken)) {
            throw new RuntimeException("Attempt to add invalid item for moving; class=" + object.getClass());
        }
        this.itemsToMove.add((BaseToken)object);
    }

    List<? extends BaseToken> getItemsToMove() {
        return this.itemsToMove;
    }

    void setItemsToMove(List<BaseToken> list) {
        this.itemsToMove = list;
    }

    boolean isFormed() {
        return this.isFormed;
    }

    void setFormed(boolean bl) {
        this.isFormed = bl;
    }

    void setFormed() {
        this.setFormed(true);
    }

    public void setAutoGenerated(boolean bl) {
        this.autoGenerated = bl;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public boolean isPruned() {
        return this.pruned;
    }

    public void setPruned(boolean bl) {
        this.pruned = bl;
    }

    public boolean isEmpty() {
        if (!this.isPruned()) {
            for (BaseToken baseToken : this.children) {
                if (baseToken instanceof TagNode) {
                    if (((TagNode)baseToken).isPruned()) continue;
                    return false;
                }
                if (baseToken instanceof ContentNode) {
                    if (((ContentNode)baseToken).isBlank()) continue;
                    return false;
                }
                if (baseToken instanceof CommentNode) {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public void addNamespaceDeclaration(String string, String string2) {
        if (this.nsDeclarations == null) {
            this.nsDeclarations = new TreeMap<String, String>();
        }
        this.nsDeclarations.put(string, string2);
    }

    void collectNamespacePrefixesOnPath(Set<String> set) {
        Map<String, String> map = this.getNamespaceDeclarations();
        if (map != null) {
            for (String string : map.keySet()) {
                set.add(string);
            }
        }
        if (this.parent != null) {
            this.parent.collectNamespacePrefixesOnPath(set);
        }
    }

    String getNamespaceURIOnPath(String string) {
        if (this.nsDeclarations != null) {
            for (Map.Entry<String, String> entry : this.nsDeclarations.entrySet()) {
                String string2 = entry.getKey();
                if (!string2.equals(string) && (!"".equals(string2) || string != null)) continue;
                return entry.getValue();
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURIOnPath(string);
        }
        return null;
    }

    public Map<String, String> getNamespaceDeclarations() {
        return this.nsDeclarations;
    }

    public void serialize(Serializer serializer, Writer writer) throws IOException {
        serializer.serialize(this, writer);
    }

    public TagNode makeCopy() {
        TagNode tagNode = new TagNode(this.name, true);
        tagNode.attributes.putAll(this.attributes);
        return tagNode;
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    public void traverse(TagNodeVisitor tagNodeVisitor) {
        this.traverseInternally(tagNodeVisitor);
    }

    private boolean traverseInternally(TagNodeVisitor tagNodeVisitor) {
        if (tagNodeVisitor != null) {
            boolean bl = this.parent != null;
            boolean bl2 = tagNodeVisitor.visit(this.parent, (HtmlNode)this);
            if (!bl2) {
                return false;
            }
            if (bl && this.parent == null) {
                return true;
            }
            for (Object object : this.children.toArray()) {
                if (object instanceof TagNode) {
                    bl2 = ((TagNode)((Object)object)).traverseInternally(tagNodeVisitor);
                } else if (object instanceof ContentNode) {
                    bl2 = tagNodeVisitor.visit(this, (HtmlNode)((ContentNode)object));
                } else if (object instanceof CommentNode) {
                    bl2 = tagNodeVisitor.visit(this, (HtmlNode)((CommentNode)object));
                }
                if (bl2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isForeignMarkup() {
        return this.isForeignMarkup;
    }

    public void setForeignMarkup(boolean bl, boolean bl2) {
        this.foreignMarkupFlagSet = true;
        this.isForeignMarkup = bl;
        if (!bl) {
            this.replaceAttributes(this.getAttributesInLowerCase(bl2));
        }
    }

    public boolean isTrimAttributeValues() {
        return this.isTrimAttributeValues;
    }

    public void setTrimAttributeValues(boolean bl) {
        this.isTrimAttributeValues = bl;
    }

    private Map<String, String> attributesToLowerCase(boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String string;
            String string2 = string = entry.getKey();
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (linkedHashMap.containsKey(string.toLowerCase())) continue;
            linkedHashMap.put(string2, this.attributes.get(string));
        }
        return linkedHashMap;
    }

    private void handleInterruption() {
    }
}

