/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.Html4TagProvider;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.OptionalOutput;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.audit.HtmlModificationListener;
import org.htmlcleaner.conditional.ITagNodeCondition;
import org.htmlcleaner.conditional.TagNodeAutoGeneratedCondition;
import org.htmlcleaner.conditional.TagNodeNameCondition;

public class CleanerProperties
implements HtmlModificationListener {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String BOOL_ATT_SELF = "self";
    public static final String BOOL_ATT_EMPTY = "empty";
    public static final String BOOL_ATT_TRUE = "true";
    private ITagInfoProvider tagInfoProvider;
    private boolean advancedXmlEscape;
    private String useCdataFor;
    private List<String> useCdataForList;
    private boolean translateSpecialEntities;
    private boolean recognizeUnicodeChars;
    private boolean omitUnknownTags;
    private boolean treatUnknownTagsAsContent;
    private boolean omitDeprecatedTags;
    private boolean omitComments;
    private boolean treatDeprecatedTagsAsContent;
    private OptionalOutput omitXmlDeclaration;
    private OptionalOutput omitDoctypeDeclaration;
    private OptionalOutput omitHtmlEnvelope;
    private boolean useEmptyElementTags;
    private boolean allowMultiWordAttributes;
    private String booleanAttributeValues;
    private boolean ignoreQuestAndExclam;
    private boolean allowHtmlInsideAttributes;
    private boolean namespacesAware;
    private boolean transSpecialEntitiesToNCR;
    private boolean omitCdataOutsideScriptAndStyle;
    private boolean deserializeEntities;
    private boolean trimAttributeValues;
    private int htmlVersion;
    private boolean allowInvalidAttributeNames;
    private String invalidAttributeNamePrefix;
    private int maxDepth;
    private boolean addNewlineToHeadAndBody;
    private boolean keepWhitespaceAndCommentsInHead;
    private String hyphenReplacementInComment;
    private String pruneTags;
    private String allowTags;
    private CleanerTransformations cleanerTransformations = new CleanerTransformations();
    private List<HtmlModificationListener> htmlModificationListeners;
    private Set<ITagNodeCondition> pruneTagSet = new HashSet<ITagNodeCondition>();
    private Set<ITagNodeCondition> allowTagSet = new HashSet<ITagNodeCondition>();
    private String charset = "UTF-8";
    private boolean transResCharsToNCR;
    private boolean ignoreAttributesCase;

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n2) {
        this.maxDepth = n2;
    }

    public boolean isIgnoreAttributesCase() {
        return this.ignoreAttributesCase;
    }

    public void setIgnoreAttributesCase(boolean bl) {
        this.ignoreAttributesCase = bl;
    }

    public CleanerProperties() {
        this.reset();
    }

    public CleanerProperties(ITagInfoProvider iTagInfoProvider) {
        this.reset();
        this.tagInfoProvider = iTagInfoProvider;
    }

    void setTagInfoProvider(ITagInfoProvider iTagInfoProvider) {
        this.tagInfoProvider = iTagInfoProvider;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.tagInfoProvider;
    }

    public boolean isAdvancedXmlEscape() {
        return this.advancedXmlEscape;
    }

    public void setAdvancedXmlEscape(boolean bl) {
        this.advancedXmlEscape = bl;
    }

    public boolean isTransResCharsToNCR() {
        return this.transResCharsToNCR;
    }

    public void setTransResCharsToNCR(boolean bl) {
        this.transResCharsToNCR = bl;
    }

    public boolean isUseCdataForScriptAndStyle() {
        return this.isUseCdataFor("script") && this.isUseCdataFor("style");
    }

    public void setUseCdataForScriptAndStyle(boolean bl) {
        if (bl) {
            this.setUseCdataFor("script,style");
        } else {
            this.setUseCdataFor("");
        }
    }

    public void setUseCdataFor(String string) {
        if (string != null) {
            this.useCdataFor = string;
            this.useCdataForList = Arrays.asList(string.toLowerCase().split(","));
        } else {
            this.useCdataFor = "";
            this.useCdataForList = null;
        }
    }

    public String getUseCdataFor() {
        return this.useCdataFor;
    }

    public boolean isUseCdataFor(String string) {
        if (this.useCdataForList != null && string != null) {
            return this.useCdataForList.contains(string.toLowerCase());
        }
        return false;
    }

    public boolean isTranslateSpecialEntities() {
        return this.translateSpecialEntities;
    }

    public void setTranslateSpecialEntities(boolean bl) {
        this.translateSpecialEntities = bl;
    }

    public boolean isRecognizeUnicodeChars() {
        return this.recognizeUnicodeChars;
    }

    public void setRecognizeUnicodeChars(boolean bl) {
        this.recognizeUnicodeChars = bl;
    }

    public boolean isOmitUnknownTags() {
        return this.omitUnknownTags;
    }

    public void setOmitUnknownTags(boolean bl) {
        this.omitUnknownTags = bl;
    }

    public boolean isTreatUnknownTagsAsContent() {
        return this.treatUnknownTagsAsContent;
    }

    public void setTreatUnknownTagsAsContent(boolean bl) {
        this.treatUnknownTagsAsContent = bl;
    }

    public boolean isOmitDeprecatedTags() {
        return this.omitDeprecatedTags;
    }

    public void setOmitDeprecatedTags(boolean bl) {
        this.omitDeprecatedTags = bl;
    }

    public boolean isTreatDeprecatedTagsAsContent() {
        return this.treatDeprecatedTagsAsContent;
    }

    public void setTreatDeprecatedTagsAsContent(boolean bl) {
        this.treatDeprecatedTagsAsContent = bl;
    }

    public boolean isOmitComments() {
        return this.omitComments;
    }

    public void setOmitComments(boolean bl) {
        this.omitComments = bl;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration == OptionalOutput.omit;
    }

    public void setOmitXmlDeclaration(boolean bl) {
        this.omitXmlDeclaration = bl ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isOmitDoctypeDeclaration() {
        return this.omitDoctypeDeclaration == OptionalOutput.omit || this.isOmitHtmlEnvelope();
    }

    public void setOmitDoctypeDeclaration(boolean bl) {
        this.omitDoctypeDeclaration = bl ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isOmitHtmlEnvelope() {
        return this.omitHtmlEnvelope == OptionalOutput.omit;
    }

    public void setOmitHtmlEnvelope(boolean bl) {
        this.omitHtmlEnvelope = bl ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isUseEmptyElementTags() {
        return this.useEmptyElementTags;
    }

    public void setUseEmptyElementTags(boolean bl) {
        this.useEmptyElementTags = bl;
    }

    public boolean isAllowMultiWordAttributes() {
        return this.allowMultiWordAttributes;
    }

    public void setAllowMultiWordAttributes(boolean bl) {
        this.allowMultiWordAttributes = bl;
    }

    public boolean isAllowHtmlInsideAttributes() {
        return this.allowHtmlInsideAttributes;
    }

    public void setAllowHtmlInsideAttributes(boolean bl) {
        this.allowHtmlInsideAttributes = bl;
    }

    public boolean isIgnoreQuestAndExclam() {
        return this.ignoreQuestAndExclam;
    }

    public void setIgnoreQuestAndExclam(boolean bl) {
        this.ignoreQuestAndExclam = bl;
    }

    public boolean isNamespacesAware() {
        return this.namespacesAware;
    }

    public void setNamespacesAware(boolean bl) {
        this.namespacesAware = bl;
    }

    public boolean isAddNewlineToHeadAndBody() {
        return this.addNewlineToHeadAndBody;
    }

    public void setAddNewlineToHeadAndBody(boolean bl) {
        this.addNewlineToHeadAndBody = bl;
    }

    public boolean isKeepWhitespaceAndCommentsInHead() {
        return this.keepWhitespaceAndCommentsInHead;
    }

    public void setKeepWhitespaceAndCommentsInHead(boolean bl) {
        this.keepWhitespaceAndCommentsInHead = bl;
    }

    public String getHyphenReplacementInComment() {
        return this.hyphenReplacementInComment;
    }

    public void setHyphenReplacementInComment(String string) {
        this.hyphenReplacementInComment = string;
    }

    public String getPruneTags() {
        return this.pruneTags;
    }

    public boolean isOmitCdataOutsideScriptAndStyle() {
        return this.omitCdataOutsideScriptAndStyle;
    }

    public void setOmitCdataOutsideScriptAndStyle(boolean bl) {
        this.omitCdataOutsideScriptAndStyle = bl;
    }

    public boolean isDeserializeEntities() {
        return this.deserializeEntities;
    }

    public void setDeserializeEntities(boolean bl) {
        this.deserializeEntities = bl;
    }

    public void setHtmlVersion(int n2) {
        this.htmlVersion = n2;
        if (n2 == 4) {
            this.setTagInfoProvider((ITagInfoProvider)Html4TagProvider.INSTANCE);
        } else {
            this.setTagInfoProvider((ITagInfoProvider)Html5TagProvider.INSTANCE);
        }
    }

    public int getHtmlVersion() {
        return this.htmlVersion;
    }

    public boolean isTrimAttributeValues() {
        return this.trimAttributeValues;
    }

    public void setTrimAttributeValues(boolean bl) {
        this.trimAttributeValues = bl;
    }

    public void setPruneTags(String string) {
        this.pruneTags = string;
        this.resetPruneTagSet();
        this.addTagNameConditions(this.pruneTagSet, string);
    }

    public void addPruneTagNodeCondition(ITagNodeCondition iTagNodeCondition) {
        this.pruneTagSet.add(iTagNodeCondition);
    }

    public Set<ITagNodeCondition> getPruneTagSet() {
        return this.pruneTagSet;
    }

    public String getAllowTags() {
        return this.allowTags;
    }

    public void setAllowTags(String string) {
        this.allowTags = string;
        this.setAllowTagSet(string);
    }

    private void setAllowTagSet(String string) {
        this.allowTagSet.clear();
        this.addTagNameConditions(this.allowTagSet, string);
    }

    public boolean isTransSpecialEntitiesToNCR() {
        return this.transSpecialEntitiesToNCR;
    }

    public void setTransSpecialEntitiesToNCR(boolean bl) {
        this.transSpecialEntitiesToNCR = bl;
    }

    private void addTagNameConditions(Set<ITagNodeCondition> set, String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                set.add((ITagNodeCondition)new TagNodeNameCondition(stringTokenizer.nextToken().trim().toLowerCase()));
            }
        }
    }

    public Set<ITagNodeCondition> getAllowTagSet() {
        return this.allowTagSet;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBooleanAttributeValues() {
        return this.booleanAttributeValues;
    }

    public void setBooleanAttributeValues(String string) {
        this.booleanAttributeValues = BOOL_ATT_SELF.equalsIgnoreCase(string) || BOOL_ATT_EMPTY.equalsIgnoreCase(string) || BOOL_ATT_TRUE.equalsIgnoreCase(string) ? string.toLowerCase() : BOOL_ATT_SELF;
    }

    public void reset() {
        this.advancedXmlEscape = true;
        this.setUseCdataFor("script,style");
        this.translateSpecialEntities = true;
        this.recognizeUnicodeChars = true;
        this.omitUnknownTags = false;
        this.treatUnknownTagsAsContent = false;
        this.omitDeprecatedTags = false;
        this.treatDeprecatedTagsAsContent = false;
        this.omitComments = false;
        this.omitXmlDeclaration = OptionalOutput.alwaysOutput;
        this.omitDoctypeDeclaration = OptionalOutput.alwaysOutput;
        this.omitHtmlEnvelope = OptionalOutput.alwaysOutput;
        this.useEmptyElementTags = true;
        this.allowMultiWordAttributes = true;
        this.allowHtmlInsideAttributes = false;
        this.ignoreQuestAndExclam = true;
        this.namespacesAware = true;
        this.addNewlineToHeadAndBody = true;
        this.keepWhitespaceAndCommentsInHead = true;
        this.hyphenReplacementInComment = "=";
        this.setPruneTags(null);
        this.setAllowTags(null);
        this.booleanAttributeValues = BOOL_ATT_SELF;
        this.charset = DEFAULT_CHARSET;
        this.cleanerTransformations.clear();
        this.resetPruneTagSet();
        this.tagInfoProvider = this.getHtmlVersion() == HtmlCleaner.HTML_4 ? Html4TagProvider.INSTANCE : Html5TagProvider.INSTANCE;
        this.htmlModificationListeners = new ArrayList<HtmlModificationListener>();
        this.omitCdataOutsideScriptAndStyle = false;
        this.trimAttributeValues = true;
        this.invalidAttributeNamePrefix = "";
        this.allowInvalidAttributeNames = false;
        this.maxDepth = 1000;
    }

    private void resetPruneTagSet() {
        this.pruneTagSet.clear();
        this.pruneTagSet.add((ITagNodeCondition)TagNodeAutoGeneratedCondition.INSTANCE);
    }

    public CleanerTransformations getCleanerTransformations() {
        return this.cleanerTransformations;
    }

    public void setCleanerTransformations(CleanerTransformations cleanerTransformations) {
        if (cleanerTransformations == null) {
            this.cleanerTransformations.clear();
        } else {
            this.cleanerTransformations = cleanerTransformations;
        }
    }

    public void addHtmlModificationListener(HtmlModificationListener htmlModificationListener) {
        this.htmlModificationListeners.add(htmlModificationListener);
    }

    public void fireConditionModification(ITagNodeCondition iTagNodeCondition, TagNode tagNode) {
        for (HtmlModificationListener htmlModificationListener : this.htmlModificationListeners) {
            htmlModificationListener.fireConditionModification(iTagNodeCondition, tagNode);
        }
    }

    public void fireHtmlError(boolean bl, TagNode tagNode, ErrorType errorType) {
        for (HtmlModificationListener htmlModificationListener : this.htmlModificationListeners) {
            htmlModificationListener.fireHtmlError(bl, tagNode, errorType);
        }
    }

    public void fireUglyHtml(boolean bl, TagNode tagNode, ErrorType errorType) {
        for (HtmlModificationListener htmlModificationListener : this.htmlModificationListeners) {
            htmlModificationListener.fireUglyHtml(bl, tagNode, errorType);
        }
    }

    public void fireUserDefinedModification(boolean bl, TagNode tagNode, ErrorType errorType) {
        for (HtmlModificationListener htmlModificationListener : this.htmlModificationListeners) {
            htmlModificationListener.fireUserDefinedModification(bl, tagNode, errorType);
        }
    }

    public String getInvalidXmlAttributeNamePrefix() {
        return this.invalidAttributeNamePrefix;
    }

    public void setInvalidXmlAttributeNamePrefix(String string) {
        this.invalidAttributeNamePrefix = string;
    }

    public void setAllowInvalidAttributeNames(boolean bl) {
        this.allowInvalidAttributeNames = bl;
    }

    public boolean isAllowInvalidAttributeNames() {
        return this.allowInvalidAttributeNames;
    }
}

