/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.text.linebreak;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.text.linebreak.LineBreakUtils;

public class LineBreakStatus {
    private static final Log LOG = LogFactory.getLog(LineBreakStatus.class);
    private static final int MINIMUM_DISTANCE_BETWEEN_BREAK_OPPORTUNITIES_FOR_SLASH = 4;
    private static final int MAXIMUM_DISTANCE_BETWEEN_BREAK_OPPORTUNITIES_FOR_SLASH = 10;
    public static final byte DIRECT_BREAK = 0;
    public static final byte INDIRECT_BREAK = 1;
    public static final byte COMBINING_INDIRECT_BREAK = 2;
    public static final byte COMBINING_PROHIBITED_BREAK = 3;
    public static final byte PROHIBITED_BREAK = 4;
    public static final byte EXPLICIT_BREAK = 5;
    private byte leftClass;
    private boolean hadSpace;
    private boolean avoidBreakLineAtHyphens;
    private boolean alwaysBreakLineAtHyphens;
    private CharState currentState = CharState.ZERO;

    public LineBreakStatus(boolean bl, boolean bl2) {
        if (bl && bl2) {
            LOG.error((Object)"Impossible to avoid and always break line at hyphen simultaneously. The '-oxy-avoid-breaking-line-at-hyphens' property will be ignored.");
            bl = false;
        }
        this.avoidBreakLineAtHyphens = bl;
        this.alwaysBreakLineAtHyphens = bl2;
        this.reset();
    }

    public void reset() {
        this.leftClass = (byte)-1;
        this.hadSpace = false;
    }

    public byte nextChar(char c2, int n2) {
        int n3 = this.nextCharInternal(c2);
        byte by = LineBreakUtils.getLineBreakProperty((char)c2);
        switch (this.currentState) {
            case ZERO: {
                if (by == 34) {
                    this.currentState = CharState.SLASH;
                } else if (by == 33 || by == 27) {
                    this.currentState = CharState.SPACE_OR_OPENING_PUNCTUATION;
                }
                if (by != 16) break;
                if (this.avoidBreakLineAtHyphens) {
                    this.currentState = CharState.HYPHEN_IN_AVOID_BREAK_LINE_AT_HYPHEN;
                    break;
                }
                if (!this.alwaysBreakLineAtHyphens) break;
                this.currentState = CharState.HYPHEN_IN_ALWAYS_BREAK_LINE_AT_HYPHEN;
                break;
            }
            case SPACE_OR_OPENING_PUNCTUATION: {
                if (by == 27) break;
                if (by == 16) {
                    this.currentState = CharState.LEADING_HYPHEN;
                    break;
                }
                this.currentState = CharState.ZERO;
                break;
            }
            case LEADING_HYPHEN: {
                this.currentState = CharState.ZERO;
                if (this.avoidBreakLineAtHyphens && by == 16) {
                    this.currentState = CharState.HYPHEN_IN_AVOID_BREAK_LINE_AT_HYPHEN;
                }
                n3 = 4;
                break;
            }
            case SLASH: {
                this.currentState = CharState.ZERO;
                if (n2 < 4) {
                    n3 = 4;
                    break;
                }
                if (n2 <= 10) break;
                n3 = 0;
                break;
            }
            case HYPHEN_IN_AVOID_BREAK_LINE_AT_HYPHEN: {
                this.currentState = CharState.ZERO;
                n3 = 4;
                break;
            }
            case HYPHEN_IN_ALWAYS_BREAK_LINE_AT_HYPHEN: {
                this.currentState = CharState.ZERO;
                n3 = 0;
            }
        }
        return (byte)n3;
    }

    private byte nextCharInternal(char c2) {
        int n2 = LineBreakUtils.getLineBreakProperty((char)c2);
        block0 : switch (n2) {
            case 0: 
            case 1: 
            case 32: 
            case 36: {
                n2 = 2;
                break;
            }
            case 31: {
                switch (Character.getType(c2)) {
                    case 6: 
                    case 8: {
                        n2 = 9;
                        break block0;
                    }
                }
                n2 = 2;
            }
        }
        switch (this.leftClass) {
            case -1: {
                this.leftClass = (byte)n2;
                if (this.leftClass == 9) {
                    this.leftClass = (byte)2;
                }
                return 4;
            }
            case 6: 
            case 23: 
            case 24: {
                this.reset();
                this.leftClass = (byte)n2;
                return 5;
            }
            case 11: {
                if (n2 == 23) break;
                this.reset();
                this.leftClass = (byte)n2;
                return 5;
            }
        }
        switch (n2) {
            case 6: 
            case 11: 
            case 23: 
            case 24: {
                this.leftClass = (byte)n2;
                return 4;
            }
            case 33: {
                this.hadSpace = true;
                return 4;
            }
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                if (this.hadSpace) break;
                return 4;
            }
        }
        boolean bl = this.hadSpace;
        this.hadSpace = false;
        byte by = LineBreakUtils.getLineBreakPairProperty((int)this.leftClass, (int)n2);
        switch (by) {
            case 0: 
            case 4: {
                this.leftClass = (byte)n2;
                return by;
            }
            case 1: {
                this.leftClass = (byte)n2;
                if (bl) {
                    return 1;
                }
                return 4;
            }
            case 2: {
                if (bl) {
                    this.leftClass = (byte)n2;
                    return 2;
                }
                return 4;
            }
            case 3: {
                if (bl) {
                    this.leftClass = (byte)n2;
                }
                return 3;
            }
        }
        assert (false);
        return by;
    }

    private static enum CharState {
        ZERO,
        SPACE_OR_OPENING_PUNCTUATION,
        LEADING_HYPHEN,
        HYPHEN_IN_AVOID_BREAK_LINE_AT_HYPHEN,
        HYPHEN_IN_ALWAYS_BREAK_LINE_AT_HYPHEN,
        SLASH;

    }
}

