/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg.font;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.List;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.GlyphMapping;
import org.apache.fop.fonts.TextFragment;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.traits.MinOptMax;

public class FOPGVTGlyphVector
implements GVTGlyphVector {
    protected final TextFragment text;
    protected final FOPGVTFont font;
    private final int fontSize;
    private final FontMetrics fontMetrics;
    private final FontRenderContext frc;
    protected int[] glyphs;
    protected List associations;
    protected int[][] gposAdjustments;
    protected float[] positions;
    protected Rectangle2D[] boundingBoxes;
    protected GeneralPath outline;
    protected AffineTransform[] glyphTransforms;
    protected boolean[] glyphVisibilities;
    protected Rectangle2D logicalBounds;
    private static final int[] PA_ZERO = new int[4];

    FOPGVTGlyphVector(FOPGVTFont fOPGVTFont, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        this.text = new SVGTextFragment(characterIterator);
        this.font = fOPGVTFont;
        Font font = fOPGVTFont.getFont();
        this.fontSize = font.getFontSize();
        this.fontMetrics = font.getFontMetrics();
        this.frc = fontRenderContext;
    }

    public void performDefaultLayout() {
        Font font = this.font.getFont();
        MinOptMax minOptMax = MinOptMax.ZERO;
        MinOptMax[] minOptMaxArray = new MinOptMax[this.text.getEndIndex()];
        boolean bl = false;
        boolean bl2 = GlyphMapping.getEnableLatinGlyphSubstitutions();
        if (bl2) {
            GlyphMapping.setEnableLatinGlyphSubstitutions(false);
        }
        GlyphMapping glyphMapping = GlyphMapping.doGlyphMapping(this.text, this.text.getBeginIndex(), this.text.getEndIndex(), font, minOptMax, minOptMaxArray, '\u0000', '\u0000', false, this.text.getBidiLevel(), true, true, bl);
        if (bl2) {
            GlyphMapping.setEnableLatinGlyphSubstitutions(true);
        }
        CharacterIterator characterIterator = glyphMapping.mapping != null ? new StringCharacterIterator(glyphMapping.mapping) : this.text.getIterator();
        this.glyphs = this.buildGlyphs(font, characterIterator);
        this.associations = glyphMapping.associations;
        this.gposAdjustments = glyphMapping.gposAdjustments;
        if (this.text.getBeginIndex() > 0) {
            int n2 = this.text.getEndIndex() - this.text.getBeginIndex();
            MinOptMax[] minOptMaxArray2 = new MinOptMax[n2];
            System.arraycopy(minOptMaxArray, this.text.getBeginIndex(), minOptMaxArray2, 0, n2);
            minOptMaxArray = minOptMaxArray2;
        }
        this.positions = this.buildGlyphPositions(characterIterator, glyphMapping.gposAdjustments, minOptMaxArray);
        this.glyphVisibilities = new boolean[this.glyphs.length];
        Arrays.fill(this.glyphVisibilities, true);
        this.glyphTransforms = new AffineTransform[this.glyphs.length];
    }

    private int[] buildGlyphs(Font font, CharacterIterator characterIterator) {
        int[] nArray = new int[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
        int n2 = 0;
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            nArray[n2] = font.mapChar(c2);
            ++n2;
            c2 = characterIterator.next();
        }
        return nArray;
    }

    private float[] buildGlyphPositions(CharacterIterator characterIterator, int[][] nArray, MinOptMax[] minOptMaxArray) {
        float[] fArray;
        block3: {
            float f2;
            float f3;
            int n2;
            block2: {
                n2 = characterIterator.getEndIndex() - characterIterator.getBeginIndex();
                fArray = new float[2 * (n2 + 1)];
                f3 = 0.0f;
                f2 = 0.0f;
                if (nArray == null) break block2;
                for (int i2 = 0; i2 < n2 + 1; ++i2) {
                    int[] nArray2 = i2 >= nArray.length || nArray[i2] == null ? PA_ZERO : nArray[i2];
                    float f4 = f3 + (float)nArray2[0] / 1000.0f;
                    float f5 = f2 - (float)nArray2[1] / 1000.0f;
                    float f6 = this.getGlyphWidth(i2) + (float)nArray2[2] / 1000.0f;
                    float f7 = (float)nArray2[3] / 1000.0f;
                    int n3 = 2 * i2;
                    fArray[n3 + 0] = f4;
                    fArray[n3 + 1] = f5;
                    f3 += f6;
                    f2 += f7;
                }
                break block3;
            }
            if (minOptMaxArray == null) break block3;
            for (int i3 = 0; i3 < n2 + 1; ++i3) {
                MinOptMax minOptMax = i3 + 1 >= minOptMaxArray.length || minOptMaxArray[i3 + 1] == null ? MinOptMax.ZERO : minOptMaxArray[i3 + 1];
                float f8 = f3;
                float f9 = f2;
                float f10 = this.getGlyphWidth(i3) + (float)minOptMax.getOpt() / 1000.0f;
                float f11 = 0.0f;
                int n4 = 2 * i3;
                fArray[n4 + 0] = f8;
                fArray[n4 + 1] = f9;
                f3 += f10;
                f2 += f11;
            }
        }
        return fArray;
    }

    private float getGlyphWidth(int n2) {
        if (n2 < this.glyphs.length) {
            return (float)this.fontMetrics.getWidth(this.glyphs[n2], this.fontSize) / 1000000.0f;
        }
        return 0.0f;
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void setGlyphCode(int n2, int n3) {
        this.glyphs[n2] = n3;
    }

    public int getGlyphCode(int n2) {
        return this.glyphs[n2];
    }

    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n3];
        }
        System.arraycopy(this.glyphs, n2, nArray, 0, n3);
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        throw new UnsupportedOperationException();
    }

    public Shape getGlyphLogicalBounds(int n2) {
        GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(n2);
        Point2D point2D = this.getGlyphPosition(n2);
        GVTLineMetrics gVTLineMetrics = this.font.getLineMetrics(0);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, -gVTLineMetrics.getDescent(), gVTGlyphMetrics.getHorizontalAdvance(), gVTLineMetrics.getAscent() + gVTLineMetrics.getDescent());
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        AffineTransform affineTransform2 = this.getGlyphTransform(n2);
        if (affineTransform2 != null) {
            affineTransform.concatenate(affineTransform2);
        }
        affineTransform.scale(1.0, -1.0);
        return affineTransform.createTransformedShape(float_);
    }

    public GVTGlyphMetrics getGlyphMetrics(int n2) {
        Rectangle2D rectangle2D = this.getBoundingBoxes()[n2];
        return new GVTGlyphMetrics(this.positions[2 * (n2 + 1)] - this.positions[2 * n2], (float)(this.fontMetrics.getAscender(this.fontSize) - this.fontMetrics.getDescender(this.fontSize)) / 1000000.0f, rectangle2D, 0);
    }

    public Shape getGlyphOutline(int n2) {
        Rectangle2D rectangle2D = this.getBoundingBoxes()[n2];
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.positions[n2 * 2], this.positions[n2 * 2 + 1]);
        AffineTransform affineTransform2 = this.getGlyphTransform(n2);
        if (affineTransform2 != null) {
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform.createTransformedShape(rectangle2D);
    }

    public Rectangle2D getGlyphCellBounds(int n2) {
        throw new UnsupportedOperationException();
    }

    public int[][] getGlyphPositionAdjustments() {
        return this.gposAdjustments;
    }

    public Point2D getGlyphPosition(int n2) {
        int n3 = n2 * 2;
        return new Point2D.Float(this.positions[n3], this.positions[n3 + 1]);
    }

    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n3 * 2];
        }
        System.arraycopy(this.positions, n2 * 2, fArray, 0, n3 * 2);
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n2) {
        return this.glyphTransforms[n2];
    }

    public Shape getGlyphVisualBounds(int n2) {
        Rectangle2D rectangle2D = this.getBoundingBoxes()[n2];
        Point2D point2D = this.getGlyphPosition(n2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        AffineTransform affineTransform2 = this.getGlyphTransform(n2);
        if (affineTransform2 != null) {
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform.createTransformedShape(rectangle2D);
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
                Shape shape = this.getGlyphLogicalBounds(i2);
                generalPath.append(shape, false);
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
                this.outline.append(this.getGlyphOutline(i2), false);
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f2, float f3) {
        throw new UnsupportedOperationException();
    }

    public Rectangle2D getGeometricBounds() {
        throw new UnsupportedOperationException();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        return this.getOutline().getBounds2D();
    }

    public void setGlyphPosition(int n2, Point2D point2D) {
        int n3 = n2 * 2;
        this.positions[n3] = (float)point2D.getX();
        this.positions[n3 + 1] = (float)point2D.getY();
    }

    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        this.glyphTransforms[n2] = affineTransform;
    }

    public void setGlyphVisible(int n2, boolean bl) {
        this.glyphVisibilities[n2] = bl;
    }

    public boolean isGlyphVisible(int n2) {
        return this.glyphVisibilities[n2];
    }

    public int getCharacterCount(int n2, int n3) {
        return n3 - n2 + 1;
    }

    public boolean isReversed() {
        return false;
    }

    public void maybeReverse(boolean bl) {
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
    }

    private Rectangle2D[] getBoundingBoxes() {
        if (this.boundingBoxes == null) {
            this.buildBoundingBoxes();
        }
        return this.boundingBoxes;
    }

    private void buildBoundingBoxes() {
        this.boundingBoxes = new Rectangle2D[this.glyphs.length];
        for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
            Rectangle rectangle = this.fontMetrics.getBoundingBox(this.glyphs[i2], this.fontSize);
            this.boundingBoxes[i2] = new Rectangle2D.Float((float)rectangle.x / 1000000.0f, (float)(-(rectangle.y + rectangle.height)) / 1000000.0f, (float)rectangle.width / 1000000.0f, (float)rectangle.height / 1000000.0f);
        }
    }

    private static class SVGTextFragment
    implements TextFragment {
        private final CharacterIterator charIter;
        private String script;
        private String language;
        private int level = -1;

        SVGTextFragment(CharacterIterator characterIterator) {
            this.charIter = characterIterator;
            if (characterIterator instanceof AttributedCharacterIterator) {
                AttributedCharacterIterator attributedCharacterIterator = (AttributedCharacterIterator)characterIterator;
                attributedCharacterIterator.first();
                this.script = (String)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.SCRIPT);
                this.language = (String)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LANGUAGE);
                Integer n2 = (Integer)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
                if (n2 != null) {
                    this.level = n2;
                }
            }
        }

        public CharacterIterator getIterator() {
            return this.charIter;
        }

        public int getBeginIndex() {
            return this.charIter.getBeginIndex();
        }

        public int getEndIndex() {
            return this.charIter.getEndIndex();
        }

        public CharSequence subSequence(int n2, int n3) {
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = this.charIter.first();
            while (c2 != '\uffff') {
                stringBuilder.append(c2);
                c2 = this.charIter.next();
            }
            return stringBuilder.toString();
        }

        public String getScript() {
            if (this.script != null) {
                return this.script;
            }
            return "auto";
        }

        public String getLanguage() {
            if (this.language != null) {
                return this.language;
            }
            return "none";
        }

        public int getBidiLevel() {
            return this.level;
        }

        public char charAt(int n2) {
            return this.charIter.setIndex(n2 - this.charIter.getBeginIndex());
        }
    }
}

