/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFLinkRectangleWithShape;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.gradient.Function;
import org.apache.fop.render.gradient.GradientMaker;
import org.apache.fop.render.gradient.Pattern;
import org.apache.fop.render.gradient.Shading;
import org.apache.fop.render.intermediate.IFRenderer;
import org.apache.fop.render.pdf.ImageRawCCITTFaxAdapter;
import org.apache.fop.render.pdf.ImageRawJPEGAdapter;
import org.apache.fop.render.pdf.ImageRenderedAdapter;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.GraphicsConfigurationWithTransparency;

public class PDFGraphics2D
extends AbstractGraphics2D
implements NativeImageHandler {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final int DEC = 8;
    static final int OPAQUE = 255;
    protected PDFDocument pdfDoc;
    protected PDFResourceContext resourceContext;
    protected PDFReference pageRef;
    protected PDFPaintingState paintingState;
    protected PDFColorHandler colorHandler;
    protected int baseLevel;
    protected int nativeCount;
    protected FontInfo fontInfo;
    protected Font ovFontState;
    protected StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected float currentFontSize;
    protected OutputStream outputStream;
    private TransparencyIgnoredEventListener transparencyIgnoredEventListener;
    private Graphics2D fmg;

    public PDFGraphics2D(boolean bl, FontInfo fontInfo, PDFDocument pDFDocument, PDFResourceContext pDFResourceContext, PDFReference pDFReference, String string, float f2, TransparencyIgnoredEventListener transparencyIgnoredEventListener) {
        this(bl);
        this.pdfDoc = pDFDocument;
        this.colorHandler = new PDFColorHandler(pDFDocument.getResources(), pDFResourceContext);
        this.resourceContext = pDFResourceContext;
        this.currentFontName = string;
        this.currentFontSize = f2;
        this.fontInfo = fontInfo;
        this.pageRef = pDFReference;
        this.paintingState = new PDFPaintingState();
        this.transparencyIgnoredEventListener = transparencyIgnoredEventListener;
    }

    protected PDFGraphics2D(boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PDFGraphics2D(PDFGraphics2D pDFGraphics2D) {
        super((AbstractGraphics2D)pDFGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.pdfDoc = pDFGraphics2D.pdfDoc;
        this.colorHandler = pDFGraphics2D.colorHandler;
        this.resourceContext = pDFGraphics2D.resourceContext;
        this.currentFontName = pDFGraphics2D.currentFontName;
        this.currentFontSize = pDFGraphics2D.currentFontSize;
        this.fontInfo = pDFGraphics2D.fontInfo;
        this.pageRef = pDFGraphics2D.pageRef;
        this.paintingState = pDFGraphics2D.paintingState;
        this.currentStream = pDFGraphics2D.currentStream;
        this.nativeCount = pDFGraphics2D.nativeCount;
        this.outputStream = pDFGraphics2D.outputStream;
        this.ovFontState = pDFGraphics2D.ovFontState;
        this.transparencyIgnoredEventListener = pDFGraphics2D.transparencyIgnoredEventListener;
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    protected void handleIOException(IOException iOException) {
        iOException.printStackTrace();
    }

    protected void preparePainting() {
    }

    public void setPaintingState(PDFPaintingState pDFPaintingState) {
        this.paintingState = pDFPaintingState;
        this.baseLevel = this.paintingState.getStackLevel();
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public String getString() {
        return this.currentStream.toString();
    }

    public StringBuffer getBuffer() {
        return this.currentStream.getBuffer();
    }

    public PDFReference getPageReference() {
        return this.pageRef;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
        this.setPrivateHints();
    }

    private void setPrivateHints() {
        this.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
    }

    public void setOverrideFontState(Font font) {
        this.ovFontState = font;
    }

    private void concatMatrix(double[] dArray) {
        this.currentStream.write(PDFNumber.doubleOut((double)dArray[0], (int)8) + " " + PDFNumber.doubleOut((double)dArray[1], (int)8) + " " + PDFNumber.doubleOut((double)dArray[2], (int)8) + " " + PDFNumber.doubleOut((double)dArray[3], (int)8) + " " + PDFNumber.doubleOut((double)dArray[4], (int)8) + " " + PDFNumber.doubleOut((double)dArray[5], (int)8) + " cm\n");
    }

    private void concatMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.concatMatrix(dArray);
        }
    }

    protected AffineTransform getBaseTransform() {
        AffineTransform affineTransform = new AffineTransform(this.paintingState.getTransform());
        return affineTransform;
    }

    public void addLink(Shape shape, AffineTransform affineTransform, String string, int n2) {
        if (!this.pdfDoc.getProfile().isAnnotationAllowed()) {
            return;
        }
        this.preparePainting();
        AffineTransform affineTransform2 = this.getTransform();
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        shape2 = affineTransform.createTransformedShape(shape2);
        if (shape2 != null) {
            if (n2 != 0 || string.startsWith("#")) {
                IFRenderer iFRenderer = IFRenderer.IF_RENDERER_INSTANCE.get();
                if (iFRenderer != null) {
                    iFRenderer.processInternalLinkFromForeignObject(new PDFLinkRectangleWithShape(shape2), string);
                } else {
                    String string2 = "/FitR " + string;
                    this.resourceContext.addAnnotation((PDFObject)this.pdfDoc.getFactory().makeLink((Rectangle2D)new PDFLinkRectangleWithShape(shape2), this.getPageReference().toString(), string2));
                }
            } else {
                this.resourceContext.addAnnotation((PDFObject)this.pdfDoc.getFactory().makeLink(new PDFLinkRectangleWithShape(shape2), string, n2, 0.0f));
            }
        }
    }

    public void addNativeImage(org.apache.xmlgraphics.image.loader.Image image, float f2, float f3, float f4, float f5) {
        ImageRawJPEGAdapter imageRawJPEGAdapter;
        this.preparePainting();
        Object object = image.getInfo().getOriginalURI();
        if (object == null) {
            object = "__AddNative_" + ((Object)((Object)this)).hashCode() + "_" + this.nativeCount;
            ++this.nativeCount;
        }
        if (image instanceof ImageRawJPEG) {
            imageRawJPEGAdapter = new ImageRawJPEGAdapter((ImageRawJPEG)image, (String)object);
        } else if (image instanceof ImageRawCCITTFax) {
            imageRawJPEGAdapter = new ImageRawCCITTFaxAdapter((ImageRawCCITTFax)image, (String)object);
        } else {
            throw new IllegalArgumentException("Unsupported Image subclass: " + image.getClass().getName());
        }
        PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, (PDFImage)imageRawJPEGAdapter);
        this.flushPDFDocument();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f2, f3);
        this.useXObject((PDFXObject)pDFImageXObject, affineTransform, f4, f5);
    }

    private void flushPDFDocument() {
        if (this.outputStream != null && !this.pdfDoc.isLinearizationEnabled()) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        this.preparePainting();
        int n4 = image.getWidth(imageObserver);
        int n5 = image.getHeight(imageObserver);
        if (n4 == -1 || n5 == -1) {
            return false;
        }
        return this.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    private BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        Cloneable cloneable;
        this.preparePainting();
        String string = "TempImage:" + image.toString();
        PDFXObject pDFXObject = this.pdfDoc.getXObject(string);
        if (pDFXObject == null) {
            cloneable = new Dimension(n4, n5);
            BufferedImage bufferedImage = this.buildBufferedImage((Dimension)cloneable);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setBackground(new Color(1, 1, 1, 0));
            graphics2D.setPaint(new Color(1, 1, 1, 0));
            graphics2D.fillRect(0, 0, n4, n5);
            int n6 = bufferedImage.getWidth();
            int n7 = bufferedImage.getHeight();
            graphics2D.clip(new Rectangle(0, 0, n6, n7));
            graphics2D.setComposite(this.gc.getComposite());
            boolean bl = graphics2D.drawImage(image, 0, 0, n6, n7, imageObserver);
            if (!bl) {
                return false;
            }
            graphics2D.dispose();
            pDFXObject = this.addRenderedImage(string, bufferedImage);
        } else {
            this.resourceContext.addXObject(pDFXObject);
        }
        cloneable = new AffineTransform();
        ((AffineTransform)cloneable).translate(n2, n3);
        this.useXObject(pDFXObject, (AffineTransform)cloneable, n4, n5);
        return true;
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontInfo = null;
        this.currentStream = null;
        this.currentFontName = null;
    }

    public void draw(Shape shape) {
        boolean bl;
        this.preparePainting();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        Shape shape2 = this.getClip();
        boolean bl2 = this.paintingState.checkClip(shape2);
        boolean bl3 = bl = this.paintingState.checkTransform(affineTransform) && !affineTransform.isIdentity();
        if (bl2 || bl) {
            this.saveGraphicsState();
            if (bl) {
                this.concatMatrix(dArray);
            }
            if (bl2) {
                this.writeClip(shape2);
            }
        }
        this.applyAlpha(255, color.getAlpha());
        color = this.getColor();
        this.applyColor(color, false);
        color = this.getBackground();
        this.applyColor(color, true);
        Paint paint = this.getPaint();
        if (this.paintingState.setPaint(paint) && !this.applyPaint(paint, false)) {
            Shape shape3 = this.getStroke().createStrokedShape(shape);
            this.applyUnknownPaint(paint, shape3);
            if (bl2 || bl) {
                this.restoreGraphicsState();
            }
            return;
        }
        this.applyStroke(this.getStroke());
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        this.processPathIterator(pathIterator);
        this.doDrawing(false, true, false);
        if (bl2 || bl) {
            this.restoreGraphicsState();
        }
    }

    protected void writeClip(Shape shape) {
        if (shape == null) {
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        if (pathIterator.isDone()) {
            return;
        }
        this.preparePainting();
        this.processPathIterator(pathIterator);
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    protected void applyColor(Color color, boolean bl) {
        this.preparePainting();
        if (color.getColorSpace().getType() == 9 && this.pdfDoc.getProfile().getPDFAMode().isPart1()) {
            throw new PDFConformanceException("PDF/A-1 does not allow mixing DeviceRGB and DeviceCMYK.");
        }
        boolean bl2 = false;
        if (bl) {
            if (this.paintingState.setBackColor(color)) {
                bl2 = true;
            }
        } else if (this.paintingState.setColor(color)) {
            bl2 = true;
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            this.colorHandler.establishColor(stringBuffer, color, bl, false);
            this.currentStream.write(stringBuffer.toString());
        }
    }

    protected boolean applyPaint(Paint paint, boolean bl) {
        GradientPaint gradientPaint;
        this.preparePainting();
        if (paint instanceof Color) {
            return true;
        }
        if (paint instanceof GradientPaint) {
            gradientPaint = (GradientPaint)paint;
            paint = new LinearGradientPaint((float)gradientPaint.getPoint1().getX(), (float)gradientPaint.getPoint1().getY(), (float)gradientPaint.getPoint2().getX(), (float)gradientPaint.getPoint2().getY(), new float[]{0.0f, 1.0f}, new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()}, gradientPaint.isCyclic() ? LinearGradientPaint.REPEAT : LinearGradientPaint.NO_CYCLE);
        }
        if (paint instanceof LinearGradientPaint && this.gradientSupported((MultipleGradientPaint)((LinearGradientPaint)paint))) {
            gradientPaint = GradientMaker.makeLinearGradient((LinearGradientPaint)((LinearGradientPaint)paint), (AffineTransform)this.getBaseTransform(), (AffineTransform)this.getTransform());
            PDFPattern pDFPattern = this.createPDFPattern((Pattern)gradientPaint);
            this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
            return true;
        }
        if (paint instanceof RadialGradientPaint && this.gradientSupported((MultipleGradientPaint)((RadialGradientPaint)paint))) {
            gradientPaint = GradientMaker.makeRadialGradient((RadialGradientPaint)((RadialGradientPaint)paint), (AffineTransform)this.getBaseTransform(), (AffineTransform)this.getTransform());
            PDFPattern pDFPattern = this.createPDFPattern((Pattern)gradientPaint);
            this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
            return true;
        }
        if (paint instanceof PatternPaint) {
            gradientPaint = (PatternPaint)paint;
            return this.createPattern((PatternPaint)gradientPaint, bl);
        }
        return false;
    }

    private PDFPattern createPDFPattern(Pattern pattern) {
        Function function3;
        Shading shading = pattern.getShading();
        Function function2 = shading.getFunction();
        ArrayList<PDFFunction> arrayList = new ArrayList<PDFFunction>(function2.getFunctions().size());
        for (Function function3 : function2.getFunctions()) {
            arrayList.add(this.registerFunction(new PDFFunction(function3)));
        }
        PDFFunction pDFFunction = this.registerFunction(new PDFFunction(function2, arrayList));
        function3 = new PDFShading(shading.getShadingType(), shading.getColorSpace(), shading.getCoords(), pDFFunction);
        function3 = this.registerShading((PDFShading)function3);
        PDFPattern pDFPattern = new PDFPattern(pattern.getPatternType(), (PDFShading)function3, null, null, pattern.getMatrix());
        return this.registerPattern(pDFPattern);
    }

    private boolean gradientSupported(MultipleGradientPaint multipleGradientPaint) {
        return !this.gradientContainsTransparency(multipleGradientPaint) && !this.gradientIsRepeated(multipleGradientPaint);
    }

    private boolean gradientContainsTransparency(MultipleGradientPaint multipleGradientPaint) {
        for (Color color : multipleGradientPaint.getColors()) {
            if (color.getAlpha() == 255) continue;
            return true;
        }
        return false;
    }

    private boolean gradientIsRepeated(MultipleGradientPaint multipleGradientPaint) {
        return multipleGradientPaint.getCycleMethod() != MultipleGradientPaint.NO_CYCLE;
    }

    private boolean createPattern(PatternPaint patternPaint, boolean bl) {
        this.preparePainting();
        FontInfo fontInfo = new FontInfo();
        boolean bl2 = false;
        FontSetup.setup((FontInfo)fontInfo, (boolean)bl2);
        PDFResources pDFResources = this.pdfDoc.getFactory().makeResources();
        PDFResourceContext pDFResourceContext = new PDFResourceContext(pDFResources);
        PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(this.textAsShapes, fontInfo, this.pdfDoc, pDFResourceContext, this.getPageReference(), "", 0.0f, this.transparencyIgnoredEventListener);
        pDFGraphics2D.setGraphicContext(new GraphicContext());
        pDFGraphics2D.gc.validateTransformStack();
        pDFGraphics2D.setRenderingHints(this.getRenderingHints());
        pDFGraphics2D.setOutputStream(this.outputStream);
        GraphicsNode graphicsNode = patternPaint.getGraphicsNode();
        Rectangle2D rectangle2D = patternPaint.getPatternRect();
        graphicsNode.paint((Graphics2D)((Object)pDFGraphics2D));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(rectangle2D.getX());
        arrayList.add(rectangle2D.getHeight() + rectangle2D.getY());
        arrayList.add(rectangle2D.getWidth() + rectangle2D.getX());
        arrayList.add(rectangle2D.getY());
        AffineTransform affineTransform = new AffineTransform(this.getBaseTransform());
        affineTransform.concatenate(this.getTransform());
        affineTransform.concatenate(patternPaint.getPatternTransform());
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (double d2 : dArray) {
            arrayList2.add(d2);
        }
        pDFResources.addFonts(this.pdfDoc, fontInfo);
        PDFPattern pDFPattern = this.pdfDoc.getFactory().makePattern(this.resourceContext, 1, pDFResources, 1, 1, arrayList, rectangle2D.getWidth(), rectangle2D.getHeight(), arrayList2, null, pDFGraphics2D.getBuffer());
        this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
        PDFAnnotList pDFAnnotList = pDFResourceContext.getAnnotations();
        if (pDFAnnotList != null) {
            this.pdfDoc.addObject((PDFObject)pDFAnnotList);
        }
        this.flushPDFDocument();
        return true;
    }

    protected boolean applyUnknownPaint(Paint paint, Shape shape) {
        Rectangle rectangle;
        this.preparePainting();
        Shape shape2 = this.getClip();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (shape2 != null) {
            Rectangle2D rectangle2D2 = shape2.getBounds2D();
            if (!rectangle2D2.intersects(rectangle2D)) {
                return true;
            }
            Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        AffineTransform affineTransform = this.getTransform();
        Rectangle rectangle2 = affineTransform.createTransformedShape(shape).getBounds();
        if (shape2 != null) {
            Rectangle rectangle3 = affineTransform.createTransformedShape(shape2).getBounds();
            if (!rectangle3.intersects(rectangle2)) {
                return true;
            }
            rectangle = rectangle2.intersection(rectangle3);
        } else {
            rectangle = rectangle2;
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 0);
        PaintContext paintContext = paint.createContext(directColorModel, rectangle, rectangle2D, affineTransform, this.getRenderingHints());
        PDFXObject pDFXObject = this.pdfDoc.getXObject("TempImage:" + paintContext.toString());
        if (pDFXObject != null) {
            this.resourceContext.addXObject(pDFXObject);
        } else {
            BitmapImage bitmapImage;
            byte[] byArray;
            Raster raster = paintContext.getRaster(n2, n3, n4, n5);
            assert (raster instanceof WritableRaster);
            WritableRaster writableRaster = (WritableRaster)raster;
            writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
            ColorModel colorModel = paintContext.getColorModel();
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            byte[] byArray2 = new byte[n4 * n5 * 3];
            int[] nArray = new int[n4];
            int n6 = 0;
            if (colorModel.hasAlpha()) {
                byArray = new byte[n4 * n5];
                int n7 = 0;
                for (int i2 = 0; i2 < n5; ++i2) {
                    bufferedImage.getRGB(0, i2, n4, 1, nArray, 0, n4);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n8 = nArray[i3];
                        byArray[n7++] = (byte)(n8 >>> 24);
                        byArray2[n6++] = (byte)(n8 >> 16 & 0xFF);
                        byArray2[n6++] = (byte)(n8 >> 8 & 0xFF);
                        byArray2[n6++] = (byte)(n8 & 0xFF);
                    }
                }
            } else {
                byArray = null;
                for (int i4 = 0; i4 < n5; ++i4) {
                    bufferedImage.getRGB(0, i4, n4, 1, nArray, 0, n4);
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n9 = nArray[i5];
                        byArray2[n6++] = (byte)(n9 >> 16 & 0xFF);
                        byArray2[n6++] = (byte)(n9 >> 8 & 0xFF);
                        byArray2[n6++] = (byte)(n9 & 0xFF);
                    }
                }
            }
            PDFReference pDFReference = null;
            if (byArray != null) {
                bitmapImage = new BitmapImage("TempImageMask:" + paintContext.toString(), n4, n5, byArray, null);
                bitmapImage.setColorSpace(new PDFDeviceColorSpace(1));
                PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, (PDFImage)bitmapImage);
                pDFReference = pDFImageXObject.makeReference();
                this.flushPDFDocument();
            }
            bitmapImage = new BitmapImage("TempImage:" + paintContext.toString(), n4, n5, byArray2, pDFReference);
            bitmapImage.setTransparent(new PDFColor(255, 255, 255));
            pDFXObject = this.pdfDoc.addImage(this.resourceContext, (PDFImage)bitmapImage);
            this.flushPDFDocument();
        }
        this.currentStream.write("q\n");
        this.writeClip(shape);
        this.currentStream.write(PDFNumber.doubleOut((double)d4) + " 0 0 " + PDFNumber.doubleOut((double)(-d5)) + " " + PDFNumber.doubleOut((double)d2) + " " + PDFNumber.doubleOut((double)(d3 + d5)) + " cm\n" + pDFXObject.getName() + " Do\nQ\n");
        return true;
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                this.currentStream.write("[");
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    this.currentStream.write(PDFNumber.doubleOut((double)fArray[i2]));
                    if (i2 >= fArray.length - 1) continue;
                    this.currentStream.write(" ");
                }
                this.currentStream.write("] ");
                float f2 = basicStroke.getDashPhase();
                this.currentStream.write(PDFNumber.doubleOut((double)f2) + " d\n");
            } else {
                this.currentStream.write("[] 0 d\n");
            }
            int n2 = basicStroke.getEndCap();
            switch (n2) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                    break;
                }
            }
            int n3 = basicStroke.getLineJoin();
            switch (n3) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                    break;
                }
            }
            float f3 = basicStroke.getLineWidth();
            this.currentStream.write(PDFNumber.doubleOut((double)f3) + " w\n");
            float f4 = Math.max(1.0f, basicStroke.getMiterLimit());
            this.currentStream.write(PDFNumber.doubleOut((double)f4) + " M\n");
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        String string = "TempImage:" + renderedImage.toString();
        this.drawInnerRenderedImage(string, renderedImage, affineTransform);
    }

    public void drawInnerRenderedImage(String string, RenderedImage renderedImage, AffineTransform affineTransform) {
        this.preparePainting();
        PDFXObject pDFXObject = this.pdfDoc.getXObject(string);
        if (pDFXObject == null) {
            pDFXObject = this.addRenderedImage(string, renderedImage);
        } else {
            this.resourceContext.addXObject(pDFXObject);
        }
        this.useXObject(pDFXObject, affineTransform, renderedImage.getWidth(), renderedImage.getHeight());
    }

    private void useXObject(PDFXObject pDFXObject, AffineTransform affineTransform, float f2, float f3) {
        this.currentStream.write("q\n");
        this.concatMatrix(this.getTransform());
        Shape shape = this.getClip();
        this.writeClip(shape);
        this.concatMatrix(affineTransform);
        String string = PDFNumber.doubleOut((double)f2, (int)8);
        String string2 = PDFNumber.doubleOut((double)f3, (int)8);
        this.currentStream.write(string + " 0 0 -" + string2 + " 0 " + string2 + " cm\n" + pDFXObject.getName() + " Do\nQ\n");
    }

    private PDFXObject addRenderedImage(String string, RenderedImage renderedImage) {
        ImageInfo imageInfo = new ImageInfo(null, "image/unknown");
        ImageSize imageSize = new ImageSize(renderedImage.getWidth(), renderedImage.getHeight(), 72.0);
        imageInfo.setSize(imageSize);
        ImageRendered imageRendered = new ImageRendered(imageInfo, renderedImage, null);
        ImageRenderedAdapter imageRenderedAdapter = new ImageRenderedAdapter(imageRendered, string);
        PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, (PDFImage)imageRenderedAdapter);
        this.flushPDFDocument();
        return pDFImageXObject;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawString(String string, float f2, float f3) {
        Font font;
        Serializable serializable;
        this.preparePainting();
        AffineTransform affineTransform = null;
        if (this.ovFontState == null) {
            serializable = this.getFont();
            affineTransform = ((java.awt.Font)serializable).getTransform();
            font = this.fontInfo.getFontInstanceForAWTFont((java.awt.Font)serializable);
        } else {
            font = this.fontInfo.getFontInstance(this.ovFontState.getFontTriplet(), this.ovFontState.getFontSize());
            this.ovFontState = null;
        }
        this.updateCurrentFont(font);
        this.saveGraphicsState();
        serializable = this.getColor();
        this.applyColor((Color)serializable, true);
        this.applyPaint(this.getPaint(), true);
        this.applyAlpha(((Color)serializable).getAlpha(), 255);
        Map<Integer, Map<Integer, Integer>> map = font.getKerning();
        boolean bl = map != null && !map.isEmpty();
        boolean bl2 = this.isMultiByteFont(this.currentFontName);
        String string2 = bl2 ? "<" : "(";
        String string3 = bl2 ? "> " : ") ";
        AffineTransform affineTransform2 = this.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.concatMatrix(dArray);
        Shape shape = this.getClip();
        this.writeClip(shape);
        this.currentStream.write("BT\n");
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(f2, f3);
        if (affineTransform != null) {
            affineTransform3.concatenate(affineTransform);
        }
        affineTransform3.scale(1.0, -1.0);
        double[] dArray2 = new double[6];
        affineTransform3.getMatrix(dArray2);
        this.currentStream.write(PDFNumber.doubleOut((double)dArray2[0]) + " " + PDFNumber.doubleOut((double)dArray2[1]) + " " + PDFNumber.doubleOut((double)dArray2[2]) + " " + PDFNumber.doubleOut((double)dArray2[3]) + " " + PDFNumber.doubleOut((double)dArray2[4]) + " " + PDFNumber.doubleOut((double)dArray2[5]) + " Tm [" + string2);
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = font.mapChar(string.charAt(i2));
            if (!bl2) {
                if (c2 > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(c2));
                } else {
                    switch (c2) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                            break;
                        }
                    }
                    this.currentStream.write(c2);
                }
            } else {
                this.currentStream.write(PDFText.toUnicodeHex((char)c2));
            }
            if (!bl || i2 + 1 >= n2) continue;
            this.addKerning(this.currentStream, Integer.valueOf(c2), Integer.valueOf(font.mapChar(string.charAt(i2 + 1))), map, string2, string3);
        }
        this.currentStream.write(string3);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.restoreGraphicsState();
    }

    protected void applyAlpha(int n2, int n3) {
        if (n2 != 255 || n3 != 255) {
            Object object = this.isTransparencyAllowed();
            if (object == null) {
                HashMap<String, Float> hashMap = new HashMap<String, Float>();
                if (n2 != 255) {
                    hashMap.put("ca", Float.valueOf((float)n2 / 255.0f));
                }
                if (n3 != 255) {
                    hashMap.put("CA", Float.valueOf((float)n3 / 255.0f));
                }
                PDFGState pDFGState = this.pdfDoc.getFactory().makeGState(hashMap, this.paintingState.getGState());
                this.resourceContext.addGState(pDFGState);
                this.currentStream.write("/" + pDFGState.getName() + " gs\n");
            } else if (this.transparencyIgnoredEventListener != null) {
                this.transparencyIgnoredEventListener.transparencyIgnored(object);
            }
        }
    }

    protected void updateCurrentFont(Font font) {
        String string = font.getFontName();
        float f2 = (float)font.getFontSize() / 1000.0f;
        if (!string.equals(this.currentFontName) || f2 != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = f2;
            this.currentStream.write("/" + string + " " + f2 + " Tf\n");
        }
    }

    @Deprecated
    protected Font getInternalFontForAWTFont(java.awt.Font font) {
        return this.fontInfo.getFontInstanceForAWTFont(font);
    }

    protected boolean isMultiByteFont(String string) {
        Typeface typeface = this.fontInfo.getFonts().get(string);
        return typeface.isMultiByte();
    }

    private void addKerning(StringWriter stringWriter, Integer n2, Integer n3, Map<Integer, Map<Integer, Integer>> map, String string, String string2) {
        Integer n4;
        this.preparePainting();
        Map<Integer, Integer> map2 = map.get(n2);
        if (map2 != null && (n4 = map2.get(n3)) != null) {
            this.currentStream.write(string2 + -n4.intValue() + " " + string);
        }
    }

    public void fill(Shape shape) {
        boolean bl;
        this.preparePainting();
        Color color = this.getBackground();
        if (color.getAlpha() == 0 && (color = this.getColor()).getAlpha() == 0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        Shape shape2 = this.getClip();
        boolean bl2 = this.paintingState.checkClip(shape2);
        boolean bl3 = bl = this.paintingState.checkTransform(affineTransform) && !affineTransform.isIdentity();
        if (bl2 || bl) {
            this.saveGraphicsState();
            if (bl) {
                this.concatMatrix(dArray);
            }
            if (bl2) {
                this.writeClip(shape2);
            }
        }
        this.applyAlpha(color.getAlpha(), 255);
        color = this.getColor();
        this.applyColor(color, true);
        color = this.getBackground();
        this.applyColor(color, false);
        Paint paint = this.getPaint();
        if (this.paintingState.setPaint(paint) && !this.applyPaint(paint, true)) {
            this.applyUnknownPaint(paint, shape);
            if (bl2 || bl) {
                this.restoreGraphicsState();
            }
            return;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.currentStream.write(PDFNumber.doubleOut((double)rectangle2D.getMinX(), (int)8) + " " + PDFNumber.doubleOut((double)rectangle2D.getMinY(), (int)8) + " ");
            this.currentStream.write(PDFNumber.doubleOut((double)rectangle2D.getWidth(), (int)8) + " " + PDFNumber.doubleOut((double)rectangle2D.getHeight(), (int)8) + " re ");
            this.doDrawing(true, false, false);
        } else {
            PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
            this.processPathIterator(pathIterator);
            this.doDrawing(true, false, pathIterator.getWindingRule() == 0);
        }
        if (bl2 || bl) {
            this.restoreGraphicsState();
        }
    }

    void saveGraphicsState() {
        this.currentStream.write("q\n");
        this.paintingState.save();
    }

    void restoreGraphicsState() {
        this.currentStream.write("Q\n");
        this.paintingState.restore();
    }

    protected Object isTransparencyAllowed() {
        return this.pdfDoc.getProfile().isTransparencyAllowed();
    }

    public void processPathIterator(PathIterator pathIterator) {
        double d2 = 0.0;
        double d3 = 0.0;
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 3: {
                    d2 = dArray[4];
                    d3 = dArray[5];
                    this.currentStream.write(PDFNumber.doubleOut((double)dArray[0], (int)8) + " " + PDFNumber.doubleOut((double)dArray[1], (int)8) + " " + PDFNumber.doubleOut((double)dArray[2], (int)8) + " " + PDFNumber.doubleOut((double)dArray[3], (int)8) + " " + PDFNumber.doubleOut((double)dArray[4], (int)8) + " " + PDFNumber.doubleOut((double)dArray[5], (int)8) + " c\n");
                    break;
                }
                case 1: {
                    d2 = dArray[0];
                    d3 = dArray[1];
                    this.currentStream.write(PDFNumber.doubleOut((double)dArray[0], (int)8) + " " + PDFNumber.doubleOut((double)dArray[1], (int)8) + " l\n");
                    break;
                }
                case 0: {
                    d2 = dArray[0];
                    d3 = dArray[1];
                    this.currentStream.write(PDFNumber.doubleOut((double)dArray[0], (int)8) + " " + PDFNumber.doubleOut((double)dArray[1], (int)8) + " m\n");
                    break;
                }
                case 2: {
                    double d4 = d2 + 0.6666666666666666 * (dArray[0] - d2);
                    double d5 = d3 + 0.6666666666666666 * (dArray[1] - d3);
                    double d6 = dArray[2] + 0.6666666666666666 * (dArray[0] - dArray[2]);
                    double d7 = dArray[3] + 0.6666666666666666 * (dArray[1] - dArray[3]);
                    this.currentStream.write(PDFNumber.doubleOut((double)d4, (int)8) + " " + PDFNumber.doubleOut((double)d5, (int)8) + " " + PDFNumber.doubleOut((double)d6, (int)8) + " " + PDFNumber.doubleOut((double)d7, (int)8) + " " + PDFNumber.doubleOut((double)dArray[2], (int)8) + " " + PDFNumber.doubleOut((double)dArray[3], (int)8) + " c\n");
                    d2 = dArray[2];
                    d3 = dArray[3];
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            pathIterator.next();
        }
    }

    protected void doDrawing(boolean bl, boolean bl2, boolean bl3) {
        this.preparePainting();
        if (bl) {
            if (bl2) {
                if (bl3) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (bl3) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new GraphicsConfigurationWithTransparency();
    }

    public FontMetrics getFontMetrics(java.awt.Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public void setXORMode(Color color) {
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public PDFFunction registerFunction(PDFFunction pDFFunction) {
        return this.pdfDoc.getFactory().registerFunction(pDFFunction);
    }

    public PDFShading registerShading(PDFShading pDFShading) {
        return this.pdfDoc.getFactory().registerShading(this.resourceContext, pDFShading);
    }

    public PDFPattern registerPattern(PDFPattern pDFPattern) {
        return this.pdfDoc.getFactory().registerPattern(this.resourceContext, pDFPattern);
    }

    public static interface TransparencyIgnoredEventListener {
        public void transparencyIgnored(Object var1);
    }
}

